/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.world;

import com.google.common.collect.ImmutableList;
import com.mysticsbiomes.init.MysticBiomes;
import com.mysticsbiomes.init.MysticBlocks;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class MysticSurfaceRules {
    private static final SurfaceRules.RuleSource AIR = MysticSurfaceRules.makeStateRule(Blocks.f_50016_);
    private static final SurfaceRules.RuleSource BEDROCK = MysticSurfaceRules.makeStateRule(Blocks.f_50752_);
    private static final SurfaceRules.RuleSource WHITE_TERRACOTTA = MysticSurfaceRules.makeStateRule(Blocks.f_50287_);
    private static final SurfaceRules.RuleSource ORANGE_TERRACOTTA = MysticSurfaceRules.makeStateRule(Blocks.f_50288_);
    private static final SurfaceRules.RuleSource TERRACOTTA = MysticSurfaceRules.makeStateRule(Blocks.f_50352_);
    private static final SurfaceRules.RuleSource RED_SAND = MysticSurfaceRules.makeStateRule(Blocks.f_49993_);
    private static final SurfaceRules.RuleSource RED_SANDSTONE = MysticSurfaceRules.makeStateRule(Blocks.f_50394_);
    private static final SurfaceRules.RuleSource STONE = MysticSurfaceRules.makeStateRule(Blocks.f_50069_);
    private static final SurfaceRules.RuleSource DEEPSLATE = MysticSurfaceRules.makeStateRule(Blocks.f_152550_);
    private static final SurfaceRules.RuleSource DIRT = MysticSurfaceRules.makeStateRule(Blocks.f_50493_);
    private static final SurfaceRules.RuleSource PODZOL = MysticSurfaceRules.makeStateRule(Blocks.f_50599_);
    private static final SurfaceRules.RuleSource COARSE_DIRT = MysticSurfaceRules.makeStateRule(Blocks.f_50546_);
    private static final SurfaceRules.RuleSource MYCELIUM = MysticSurfaceRules.makeStateRule(Blocks.f_50195_);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = MysticSurfaceRules.makeStateRule(Blocks.f_50440_);
    private static final SurfaceRules.RuleSource CALCITE = MysticSurfaceRules.makeStateRule(Blocks.f_152497_);
    private static final SurfaceRules.RuleSource GRAVEL = MysticSurfaceRules.makeStateRule(Blocks.f_49994_);
    private static final SurfaceRules.RuleSource SAND = MysticSurfaceRules.makeStateRule(Blocks.f_49992_);
    private static final SurfaceRules.RuleSource SANDSTONE = MysticSurfaceRules.makeStateRule(Blocks.f_50062_);
    private static final SurfaceRules.RuleSource PACKED_ICE = MysticSurfaceRules.makeStateRule(Blocks.f_50354_);
    private static final SurfaceRules.RuleSource SNOW_BLOCK = MysticSurfaceRules.makeStateRule(Blocks.f_50127_);
    private static final SurfaceRules.RuleSource POWDER_SNOW = MysticSurfaceRules.makeStateRule(Blocks.f_152499_);
    private static final SurfaceRules.RuleSource ICE = MysticSurfaceRules.makeStateRule(Blocks.f_50126_);
    private static final SurfaceRules.RuleSource WATER = MysticSurfaceRules.makeStateRule(Blocks.f_49990_);
    private static final SurfaceRules.RuleSource GRASSY_LUSH_SAND = MysticSurfaceRules.makeStateRule((Block)MysticBlocks.GRASSY_LUSH_SAND.get());
    private static final SurfaceRules.RuleSource LUSH_SAND = MysticSurfaceRules.makeStateRule((Block)MysticBlocks.LUSH_SAND.get());
    private static final SurfaceRules.RuleSource LUSH_SANDSTONE = MysticSurfaceRules.makeStateRule((Block)MysticBlocks.LUSH_SANDSTONE.get());

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.m_189390_((BlockState)block.m_49966_());
    }

    public static SurfaceRules.RuleSource overworld() {
        return MysticSurfaceRules.overworldLike(true, false, true);
    }

    public static SurfaceRules.RuleSource overworldLike(boolean surface, boolean nether, boolean overworld) {
        SurfaceRules.ConditionSource above97 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)97), (int)2);
        SurfaceRules.ConditionSource above256 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)256), (int)0);
        SurfaceRules.ConditionSource above63_1 = SurfaceRules.m_189422_((VerticalAnchor)VerticalAnchor.m_158922_((int)63), (int)-1);
        SurfaceRules.ConditionSource above74 = SurfaceRules.m_189422_((VerticalAnchor)VerticalAnchor.m_158922_((int)74), (int)1);
        SurfaceRules.ConditionSource above62 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)62), (int)0);
        SurfaceRules.ConditionSource above63_0 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)63), (int)0);
        SurfaceRules.ConditionSource isAtOrAboveWaterLevel = SurfaceRules.m_189382_((int)-1, (int)0);
        SurfaceRules.ConditionSource isAboveWaterLevel = SurfaceRules.m_189382_((int)0, (int)0);
        SurfaceRules.ConditionSource conditionSource8 = SurfaceRules.m_189419_((int)-6, (int)-1);
        SurfaceRules.ConditionSource isHole = SurfaceRules.m_189418_();
        SurfaceRules.ConditionSource isFrozenOcean = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48211_, Biomes.f_48172_});
        SurfaceRules.ConditionSource isSteep = SurfaceRules.m_189381_();
        SurfaceRules.RuleSource grassSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        SurfaceRules.RuleSource sandstoneLinedSand = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)SANDSTONE), SAND});
        SurfaceRules.RuleSource stoneLinedGravel = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)STONE), GRAVEL});
        SurfaceRules.ConditionSource isSandstoneLiningBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48166_, Biomes.f_48203_, Biomes.f_48217_, Biomes.f_48148_, MysticBiomes.LAGOON});
        SurfaceRules.RuleSource ruleSource3 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{MysticSurfaceRules.mysticRule(), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186759_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189266_, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)CALCITE), STONE})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186760_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189267_, (double)-0.05, (double)0.05), (SurfaceRules.RuleSource)stoneLinedGravel), STONE})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186765_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSandstoneLiningBiome, (SurfaceRules.RuleSource)sandstoneLinedSand), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_151784_}), (SurfaceRules.RuleSource)STONE)});
        SurfaceRules.RuleSource ruleSource4 = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189268_, (double)0.45, (double)0.58), (SurfaceRules.RuleSource)POWDER_SNOW);
        SurfaceRules.RuleSource ruleSource5 = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189268_, (double)0.35, (double)0.6), (SurfaceRules.RuleSource)POWDER_SNOW);
        SurfaceRules.RuleSource ruleSource6 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186757_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189270_, (double)-0.5, (double)0.2), (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189271_, (double)-0.0625, (double)0.025), (SurfaceRules.RuleSource)ICE), SNOW_BLOCK})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186756_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)STONE), ruleSource4, SNOW_BLOCK})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186758_}), (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186755_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource4, DIRT})), ruleSource3, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186768_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)STONE)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186766_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)stoneLinedGravel), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)DIRT), stoneLinedGravel})), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticBiomes.LUSH_OASIS}), (SurfaceRules.RuleSource)LUSH_SAND), DIRT})});
        SurfaceRules.RuleSource grassyAndLushSandMix = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.1, (double)0.2), (SurfaceRules.RuleSource)GRASSY_LUSH_SAND), LUSH_SAND});
        SurfaceRules.RuleSource grassyLush = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)GRASSY_LUSH_SAND), LUSH_SAND});
        SurfaceRules.RuleSource atOrAboveWaterLevelRules = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186757_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189270_, (double)0.0, (double)0.2), (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189271_, (double)0.0, (double)0.025), (SurfaceRules.RuleSource)ICE), SNOW_BLOCK})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186756_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)STONE), ruleSource5, SNOW_BLOCK})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186758_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSteep, (SurfaceRules.RuleSource)STONE), SNOW_BLOCK})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186755_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource5, SNOW_BLOCK})), ruleSource3, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186768_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(-0.5), (SurfaceRules.RuleSource)COARSE_DIRT)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186766_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)stoneLinedGravel), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)grassSurface), stoneLinedGravel})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186763_, Biomes.f_186764_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)PODZOL)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48182_}), (SurfaceRules.RuleSource)SNOW_BLOCK), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48215_}), (SurfaceRules.RuleSource)MYCELIUM), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticBiomes.LUSH_OASIS}), (SurfaceRules.RuleSource)grassyLush)}), grassSurface});
        SurfaceRules.ConditionSource conditionSource13 = SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.909, (double)-0.5454);
        SurfaceRules.ConditionSource conditionSource14 = SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.1818, (double)0.1818);
        SurfaceRules.ConditionSource conditionSource15 = SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)0.5454, (double)0.909);
        SurfaceRules.RuleSource isLushSandstone = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{LUSH_SANDSTONE});
        SurfaceRules.RuleSource surfaceRules = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186753_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)above97, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource13, (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource14, (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource15, (SurfaceRules.RuleSource)COARSE_DIRT), grassSurface}))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48207_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)above62, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)above63_0), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189409_((ResourceKey)Noises.f_189265_, (double)0.0), (SurfaceRules.RuleSource)WATER))))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48159_, Biomes.f_48194_, Biomes.f_186753_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)above256, (SurfaceRules.RuleSource)ORANGE_TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)above74, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource13, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource14, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource15, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.m_189427_()})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)RED_SANDSTONE), RED_SAND})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)ORANGE_TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource8, (SurfaceRules.RuleSource)WHITE_TERRACOTTA), stoneLinedGravel})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)above63_1, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)above63_0, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)above74), (SurfaceRules.RuleSource)ORANGE_TERRACOTTA)), SurfaceRules.m_189427_()})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource8, (SurfaceRules.RuleSource)WHITE_TERRACOTTA))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isFrozenOcean, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isHole, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAboveWaterLevel, (SurfaceRules.RuleSource)AIR), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189426_(), (SurfaceRules.RuleSource)ICE), WATER}))), atOrAboveWaterLevelRules}))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)conditionSource8, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isFrozenOcean, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isHole, (SurfaceRules.RuleSource)WATER))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)ruleSource6), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSandstoneLiningBiome, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202169_, (SurfaceRules.RuleSource)SANDSTONE)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticBiomes.LUSH_OASIS}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202169_, (SurfaceRules.RuleSource)isLushSandstone))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186757_, Biomes.f_186758_}), (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_}), (SurfaceRules.RuleSource)sandstoneLinedSand), stoneLinedGravel}))});
        ImmutableList.Builder bedrockBuilder = ImmutableList.builder();
        if (nether) {
            bedrockBuilder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.m_158935_((int)5), (VerticalAnchor)VerticalAnchor.m_158929_())), (SurfaceRules.RuleSource)BEDROCK));
        }
        if (overworld) {
            bedrockBuilder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        }
        SurfaceRules.RuleSource ruleSource9 = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)surfaceRules);
        bedrockBuilder.add((Object)(surface ? ruleSource9 : surfaceRules));
        bedrockBuilder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8)), (SurfaceRules.RuleSource)DEEPSLATE));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])bedrockBuilder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource mysticRule() {
        SurfaceRules.RuleSource lushOasisSurface = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)MysticSurfaceRules.surfaceNoiseAbove(0.1), (SurfaceRules.RuleSource)LUSH_SAND);
        SurfaceRules.RuleSource lagoonSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)SANDSTONE), SAND});
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticBiomes.LUSH_OASIS}), (SurfaceRules.RuleSource)lushOasisSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticBiomes.LAGOON}), (SurfaceRules.RuleSource)lagoonSurface)});
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double value) {
        return SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)(value / 8.25), (double)Double.MAX_VALUE);
    }
}

