/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.world.feature;

import com.mysticsbiomes.common.world.feature.decorator.ButterflyNestDecorator;
import com.mysticsbiomes.common.world.feature.decorator.PeachFruitDecorator;
import com.mysticsbiomes.common.world.feature.decorator.VanillaOrchidDecorator;
import com.mysticsbiomes.common.world.feature.trunk.CherryTrunkPlacer;
import com.mysticsbiomes.common.world.feature.trunk.ShrubTrunkPlacer;
import com.mysticsbiomes.common.world.feature.trunk.TropicalTrunkPlacer;
import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticFeatures;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.BendingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class MysticTreeFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> STRAWBERRY_TREE = MysticFeatures.Configured.createKey("strawberry_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_CHERRY_TREE = MysticFeatures.Configured.createKey("pink_cherry_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_CHERRY_TREE = MysticFeatures.Configured.createKey("white_cherry_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PEONY_BUSH = MysticFeatures.Configured.createKey("peony_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PEACH_TREE = MysticFeatures.Configured.createKey("peach_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DESERT_SHRUB = MysticFeatures.Configured.createKey("desert_shrub");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_TREE = MysticFeatures.Configured.createKey("maple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORANGE_MAPLE_TREE = MysticFeatures.Configured.createKey("orange_maple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_MAPLE_TREE = MysticFeatures.Configured.createKey("yellow_maple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEA_SHRUB = MysticFeatures.Configured.createKey("sea_shrub");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TROPICAL_TREE = MysticFeatures.Configured.createKey("tropical_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HYDRANGEA_BUSH = MysticFeatures.Configured.createKey("hydrangea_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUNGLE_SHRUB = MysticFeatures.Configured.createKey("jungle_shrub");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JACARANDA_TREE = MysticFeatures.Configured.createKey("jacaranda_tree");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.m_254977_(context, STRAWBERRY_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.bushyTree((Block)MysticBlocks.STRAWBERRY_LOG.get(), (Block)MysticBlocks.STRAWBERRY_BLOSSOMS.get(), 9, 0, 164).m_68251_());
        FeatureUtils.m_254977_(context, PINK_CHERRY_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.cherryTree((Block)MysticBlocks.PINK_CHERRY_BLOSSOMS.get()).m_68251_());
        FeatureUtils.m_254977_(context, WHITE_CHERRY_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.cherryTree((Block)MysticBlocks.WHITE_CHERRY_BLOSSOMS.get()).m_68251_());
        FeatureUtils.m_254977_(context, PEONY_BUSH, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.bush((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), MysticTreeFeatures.randomFoliage((Block)MysticBlocks.BUDDING_PEONY_LEAVES.get(), 4, (Block)MysticBlocks.PEONY_LEAVES.get(), 4)).m_68251_());
        FeatureUtils.m_254977_(context, PEACH_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.bushyTree((Block)MysticBlocks.PEACH_LOG.get(), (Block)MysticBlocks.PEACH_LEAVES.get(), 8, 0, 164).m_68249_(List.of(new PeachFruitDecorator((Supplier<Block>)MysticBlocks.PEACH_PLANT, 0.5))).m_68251_());
        FeatureUtils.m_254977_(context, DESERT_SHRUB, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.shrub((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50003_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50054_)).m_68251_());
        FeatureUtils.m_254977_(context, MAPLE_TREE, (Feature)((Feature)MysticFeatures.MAPLE_TREE.get()), (FeatureConfiguration)MysticTreeFeatures.bushyTree((Block)MysticBlocks.MAPLE_LOG.get(), (Block)MysticBlocks.MAPLE_LEAVES.get(), 10, 3, 164).m_68251_());
        FeatureUtils.m_254977_(context, ORANGE_MAPLE_TREE, (Feature)((Feature)MysticFeatures.MAPLE_TREE.get()), (FeatureConfiguration)MysticTreeFeatures.bushyTree((Block)MysticBlocks.MAPLE_LOG.get(), (Block)MysticBlocks.ORANGE_MAPLE_LEAVES.get(), 10, 3, 164).m_68251_());
        FeatureUtils.m_254977_(context, YELLOW_MAPLE_TREE, (Feature)((Feature)MysticFeatures.MAPLE_TREE.get()), (FeatureConfiguration)MysticTreeFeatures.bushyTree((Block)MysticBlocks.WHITE_MAPLE_LOG.get(), (Block)MysticBlocks.YELLOW_MAPLE_LEAVES.get(), 10, 3, 164).m_68251_());
        FeatureUtils.m_254977_(context, SEA_SHRUB, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.shrub((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.SEA_FOAM_LOG.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.SEA_SHRUB_LEAVES.get()))).m_68251_());
        FeatureUtils.m_254977_(context, TROPICAL_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.TROPICAL_LOG.get())), (TrunkPlacer)new TropicalTrunkPlacer(6, 7, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.TROPICAL_LEAVES.get())), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)3), 200), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68249_(List.of(new VanillaOrchidDecorator(0.5))).m_68251_());
        FeatureUtils.m_254977_(context, HYDRANGEA_BUSH, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.bush((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.HYDRANGEA_LEAVES.get()))).m_68251_());
        FeatureUtils.m_254977_(context, JUNGLE_SHRUB, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.shrub((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50002_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50053_)).m_68251_());
        FeatureUtils.m_254977_(context, JACARANDA_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)MysticTreeFeatures.base((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.JACARANDA_LOG.get())), (TrunkPlacer)new BendingTrunkPlacer(4, 2, 0, 2, (IntProvider)UniformInt.m_146622_((int)1, (int)1)), MysticTreeFeatures.randomFoliage((Block)MysticBlocks.JACARANDA_BLOSSOMS.get(), 3, (Block)MysticBlocks.JACARANDA_LEAVES.get(), 2), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)3), 82)).m_68249_(List.of(new ButterflyNestDecorator(0.25f))).m_68251_());
    }

    private static TreeConfiguration.TreeConfigurationBuilder bushyTree(Block log, Block leaves, int baseHeight, int heightRandomA, int foliageAttempts) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)log), (TrunkPlacer)new FancyTrunkPlacer(baseHeight, heightRandomA, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)3), foliageAttempts), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder cherryTree(Block leaves) {
        return MysticTreeFeatures.base((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.CHERRY_LOG.get())), new CherryTrunkPlacer(7, 3, 0, (IntProvider)new WeightedListInt(SimpleWeightedRandomList.m_146263_().m_146271_((Object)ConstantInt.m_146483_((int)2), 1).m_146271_((Object)ConstantInt.m_146483_((int)2), 1).m_146271_((Object)ConstantInt.m_146483_((int)3), 1).m_146270_()), (IntProvider)UniformInt.m_146622_((int)2, (int)3), UniformInt.m_146622_((int)-4, (int)-3), (IntProvider)UniformInt.m_146622_((int)-1, (int)0)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)3), 164), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder bush(BlockStateProvider log, BlockStateProvider leaves) {
        return MysticTreeFeatures.base(log, (TrunkPlacer)new StraightTrunkPlacer(1, 0, 0), leaves, (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 2));
    }

    private static TreeConfiguration.TreeConfigurationBuilder shrub(BlockStateProvider log, BlockStateProvider leaves) {
        return MysticTreeFeatures.base(log, new ShrubTrunkPlacer(1, 0, 0), leaves, (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)2), 112));
    }

    private static TreeConfiguration.TreeConfigurationBuilder base(BlockStateProvider log, TrunkPlacer trunkPlacer, BlockStateProvider leaves, FoliagePlacer foliagePlacer) {
        return MysticTreeFeatures.base(log, trunkPlacer, leaves, foliagePlacer, (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder base(BlockStateProvider log, TrunkPlacer trunkPlacer, BlockStateProvider leaves, FoliagePlacer foliagePlacer, FeatureSize size) {
        return new TreeConfiguration.TreeConfigurationBuilder(log, trunkPlacer, leaves, foliagePlacer, size);
    }

    private static BlockStateProvider randomFoliage(Block leaves, int weight, Block leaves2, int weight2) {
        return new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)leaves.m_49966_(), weight).m_146271_((Object)leaves2.m_49966_(), weight2));
    }
}

