/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.world.feature.decorator;

import com.mojang.serialization.Codec;
import com.mysticsbiomes.common.block.ButterflyNestBlock;
import com.mysticsbiomes.common.entity.animal.Butterfly;
import com.mysticsbiomes.init.MysticBlockEntities;
import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticEntities;
import com.mysticsbiomes.init.MysticFeatures;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.registries.ForgeRegistries;

public class ButterflyNestDecorator
extends TreeDecorator {
    public static final Codec<ButterflyNestDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(ButterflyNestDecorator::new, decorator -> Float.valueOf(decorator.probability)).codec();
    private static final Direction WORLDGEN_FACING = Direction.SOUTH;
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> direction != WORLDGEN_FACING.m_122424_()).toArray(Direction[]::new);
    private final float probability;

    public ButterflyNestDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)MysticFeatures.BUTTERFLY_NEST.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        if (!(random.m_188501_() >= this.probability)) {
            ObjectArrayList leaves = context.m_226069_();
            ObjectArrayList logs = context.m_226068_();
            int i = !leaves.isEmpty() ? Math.max(((BlockPos)leaves.get(0)).m_123342_() - 1, ((BlockPos)logs.get(0)).m_123342_() + 1) : Math.min(((BlockPos)logs.get(0)).m_123342_() + 1 + random.m_188503_(3), ((BlockPos)logs.get(logs.size() - 1)).m_123342_());
            List list = leaves.stream().filter(pos -> pos.m_123342_() == i).flatMap(pos -> Stream.of(SPAWN_DIRECTIONS).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0))).collect(Collectors.toList());
            if (!list.isEmpty()) {
                Collections.shuffle(list);
                Optional<BlockPos> optional = list.stream().filter(pos -> {
                    BlockPos belowPos = pos.m_7495_();
                    return context.m_226059_(pos) && context.m_226059_(pos.m_121945_(WORLDGEN_FACING)) && context.m_226059_(belowPos);
                }).findFirst();
                if (optional.isPresent()) {
                    context.m_226061_(optional.get(), (BlockState)((Block)MysticBlocks.BUTTERFLY_NEST.get()).m_49966_().m_61124_((Property)ButterflyNestBlock.FACING, (Comparable)WORLDGEN_FACING));
                    context.m_226058_().m_141902_(optional.get(), (BlockEntityType)MysticBlockEntities.BUTTERFLY_NEST.get()).ifPresent(blockEntity -> {
                        int j = 2 + random.m_188503_(2);
                        for (int k = 0; k < j; ++k) {
                            CompoundTag tag = new CompoundTag();
                            int c = random.m_188503_(Butterfly.Type.values().length);
                            tag.m_128405_("TypeId", c);
                            tag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)MysticEntities.BUTTERFLY.get())).toString());
                            blockEntity.storeButterfly(tag, random.m_188503_(599), false);
                        }
                    });
                }
            }
        }
    }
}

