/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.world.feature.misc;

import com.mysticsbiomes.common.block.SaguaroCactusBlock;
import com.mysticsbiomes.init.MysticBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;

public class SaguaroCactusFeature
extends Feature<BlockColumnConfiguration> {
    public SaguaroCactusFeature() {
        super(BlockColumnConfiguration.f_191206_);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockColumnConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockColumnConfiguration configuration = (BlockColumnConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        int layers = configuration.f_191207_().size();
        int[] heights = new int[layers];
        for (int i = 0; i < layers; ++i) {
            heights[i] = ((BlockColumnConfiguration.Layer)configuration.f_191207_().get(i)).f_191234_().m_214085_(random);
        }
        BlockPos.MutableBlockPos mutablePos = context.m_159777_().m_122032_();
        for (int i = 0; i < layers; ++i) {
            int height = heights[i];
            if (height == 0) continue;
            for (int j = 0; j < height; ++j) {
                level.m_7731_((BlockPos)mutablePos, ((BlockColumnConfiguration.Layer)configuration.f_191207_().get(i)).f_191235_().m_213972_(random, (BlockPos)mutablePos), 18);
                mutablePos.m_122173_(configuration.f_191208_());
            }
            if (random.m_188503_(2) == 0) {
                this.placeFlower(level, (BlockPos)mutablePos);
            }
            for (int branchHeight = 0; branchHeight < 3; ++branchHeight) {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
                this.placeBranch(level, mutablePos.m_121945_(direction).m_7494_().m_6625_(height), direction, height, random);
            }
        }
        return true;
    }

    private void placeBranch(WorldGenLevel level, BlockPos pos, Direction direction, int height, RandomSource random) {
        BlockState baseState = (BlockState)((BlockState)((BlockState)((BlockState)((Block)MysticBlocks.SAGUARO_CACTUS.get()).m_49966_().m_61124_((Property)SaguaroCactusBlock.NATURAL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SaguaroCactusBlock.BRANCH, (Comparable)Boolean.valueOf(true))).m_61124_(SaguaroCactusBlock.ATTACHMENT, (Comparable)((Object)SaguaroCactusBlock.BranchShape.BASE_BRANCH_UPWARD))).m_61124_((Property)SaguaroCactusBlock.FACING, (Comparable)direction.m_122424_());
        level.m_7731_(pos, this.updateState(level, pos, baseState), 18);
        BlockPos highestPos = pos.m_7494_();
        BlockState branchState = (BlockState)baseState.m_61124_(SaguaroCactusBlock.ATTACHMENT, (Comparable)((Object)SaguaroCactusBlock.BranchShape.BRANCH));
        int branchHeight = random.m_188503_(height > 5 ? 3 : 2);
        for (int i = 1; i < branchHeight; ++i) {
            level.m_7731_(highestPos, this.updateState(level, highestPos, branchState), 18);
            highestPos = highestPos.m_7494_();
        }
        level.m_7731_(highestPos, this.updateState(level, highestPos, branchState), 18);
        if (random.m_188503_(2) == 0) {
            this.placeFlower(level, highestPos.m_7494_());
        }
    }

    private void placeFlower(WorldGenLevel level, BlockPos pos) {
        level.m_7731_(pos, ((Block)MysticBlocks.SAGUARO_BLOSSOM.get()).m_49966_(), 18);
    }

    private BlockState updateState(WorldGenLevel level, BlockPos pos, BlockState state) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_() instanceof SaguaroCactusBlock) {
            state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)SaguaroCactusBlock.AGE, (Comparable)((Integer)currentState.m_61143_((Property)SaguaroCactusBlock.AGE)))).m_61124_((Property)SaguaroCactusBlock.NATURAL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SaguaroCactusBlock.BRANCH, (Comparable)((Boolean)currentState.m_61143_((Property)SaguaroCactusBlock.BRANCH)));
        }
        return state;
    }
}

