/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.world.feature.trunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mysticsbiomes.init.MysticFeatures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CherryTrunkPlacer
extends TrunkPlacer {
    private static final Codec<UniformInt> BRANCH_START_CODEC = ExtraCodecs.m_264370_((Codec)UniformInt.f_146614_, i -> i.m_142737_() - i.m_142739_() < 1 ? DataResult.error(() -> "Need at least 2 blocks variation for the branch starts to fit both branches") : DataResult.success((Object)i));
    public static final Codec<CherryTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CherryTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.m_146545_((int)1, (int)3).fieldOf("branch_count").forGetter(placer -> placer.branchCount), (App)IntProvider.m_146545_((int)2, (int)16).fieldOf("branch_horizontal_length").forGetter(placer -> placer.branchHorizontalLength), (App)IntProvider.m_272161_((int)-16, (int)0, BRANCH_START_CODEC).fieldOf("branch_start_offset_from_top").forGetter(placer -> placer.branchStartOffsetFromTop), (App)IntProvider.m_146545_((int)-16, (int)16).fieldOf("branch_end_offset_from_top").forGetter(placer -> placer.branchEndOffsetFromTop))).apply((Applicative)instance, CherryTrunkPlacer::new));
    private final IntProvider branchCount;
    private final IntProvider branchHorizontalLength;
    private final UniformInt branchStartOffsetFromTop;
    private final UniformInt thirdBranchStartOffsetFromTop;
    private final IntProvider branchEndOffsetFromTop;

    public CherryTrunkPlacer(int height, int randomHeightA, int randomHeightB, IntProvider branchCount, IntProvider branchLength, UniformInt startOffset, IntProvider endOffset) {
        super(height, randomHeightA, randomHeightB);
        this.branchCount = branchCount;
        this.branchHorizontalLength = branchLength;
        this.branchStartOffsetFromTop = startOffset;
        this.thirdBranchStartOffsetFromTop = UniformInt.m_146622_((int)startOffset.m_142739_(), (int)(startOffset.m_142737_() - 1));
        this.branchEndOffsetFromTop = endOffset;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)MysticFeatures.CHERRY_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int integer, BlockPos pos, TreeConfiguration configuration) {
        boolean flag1;
        int l;
        if (CherryTrunkPlacer.hasPodzolNearby(reader, pos)) {
            return Collections.emptyList();
        }
        CherryTrunkPlacer.m_226169_((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)configuration);
        int i = Math.max(0, integer - 1 + this.branchStartOffsetFromTop.m_214085_(random));
        int j = Math.max(0, integer - 1 + this.thirdBranchStartOffsetFromTop.m_214085_(random));
        int k = Math.max(0, integer - 1 + this.thirdBranchStartOffsetFromTop.m_214085_(random));
        if (j >= i) {
            ++j;
        }
        if (k >= i && k >= j) {
            ++k;
        }
        boolean flag = (l = this.branchCount.m_214085_(random)) == 3;
        boolean bl = flag1 = l >= 2;
        int m = flag ? integer : (flag1 ? Math.max(Math.max(i, j), k) + 1 : i + 1);
        for (int n = 0; n < m; ++n) {
            this.m_226187_(reader, consumer, random, pos.m_6630_(n), configuration);
        }
        ArrayList<FoliagePlacer.FoliageAttachment> list = new ArrayList<FoliagePlacer.FoliageAttachment>();
        if (flag) {
            list.add(new FoliagePlacer.FoliageAttachment(pos.m_6630_(m), 0, false));
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        Function<BlockState, BlockState> logRotation = state -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
        list.add(this.generateBranch(reader, consumer, random, integer, pos, configuration, logRotation, direction, i, i < m - 1, mutablePos));
        if (flag1) {
            list.add(this.generateBranch(reader, consumer, random, integer, pos, configuration, logRotation, direction.m_122424_(), j, j < m - 1, mutablePos));
            list.add(this.generateBranch(reader, consumer, random, integer, pos, configuration, logRotation, direction.m_122427_(), k, k < m - 1, mutablePos));
        }
        return list;
    }

    private FoliagePlacer.FoliageAttachment generateBranch(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int integer, BlockPos pos, TreeConfiguration configuration, Function<BlockState, BlockState> logRotation, Direction direction, int integer2, boolean valid, BlockPos.MutableBlockPos mutablePos) {
        Direction direction2;
        mutablePos.m_122190_((Vec3i)pos).m_122175_(Direction.UP, integer2);
        int i = integer - 1 + this.branchEndOffsetFromTop.m_214085_(random);
        boolean flag = valid || i < integer2;
        int j = this.branchHorizontalLength.m_214085_(random) + (flag ? 1 : 0);
        BlockPos abovePos = pos.m_5484_(direction, j).m_6630_(i);
        int k = flag ? 2 : 1;
        for (int l = 0; l < k; ++l) {
            Direction logRotationDir;
            BlockPos.MutableBlockPos logPos = mutablePos.m_122173_(direction);
            Direction direction3 = logRotationDir = direction.m_122434_().m_122479_() ? direction : Direction.UP;
            if (!reader.m_7433_((BlockPos)logPos, BlockBehaviour.BlockStateBase::m_247087_) || CherryTrunkPlacer.hasPodzolNearby(reader, (BlockPos)logPos)) {
                return new FoliagePlacer.FoliageAttachment(logPos.m_7494_(), 0, false);
            }
            this.m_226175_(reader, consumer, random, (BlockPos)logPos, configuration, state -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)logRotationDir.m_122434_()));
        }
        Direction direction4 = direction2 = abovePos.m_123342_() > mutablePos.m_123342_() ? Direction.UP : Direction.DOWN;
        while (true) {
            Direction logRotationDir;
            int i1;
            if ((i1 = mutablePos.m_123333_((Vec3i)abovePos)) == 0) {
                return new FoliagePlacer.FoliageAttachment(abovePos.m_7494_(), 0, false);
            }
            float f = (float)Math.abs(abovePos.m_123342_() - mutablePos.m_123342_()) / (float)i1;
            boolean flag1 = random.m_188501_() < f;
            mutablePos.m_122173_(flag1 ? direction2 : direction);
            Direction direction5 = logRotationDir = flag1 ? direction2 : direction;
            if (!reader.m_7433_((BlockPos)mutablePos, BlockBehaviour.BlockStateBase::m_247087_) || CherryTrunkPlacer.hasPodzolNearby(reader, (BlockPos)mutablePos)) break;
            this.m_226175_(reader, consumer, random, (BlockPos)mutablePos, configuration, state -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)logRotationDir.m_122434_()));
        }
        return new FoliagePlacer.FoliageAttachment(mutablePos.m_7494_(), 0, false);
    }

    private static boolean hasPodzolNearby(LevelSimulatedReader reader, BlockPos pos) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    checkPos.m_122190_((Vec3i)pos).m_122184_(dx, dy, dz);
                    if (!reader.m_7433_((BlockPos)checkPos, state -> state.m_60734_() == Blocks.f_50599_)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

