/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.world.feature.trunk;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mysticsbiomes.init.MysticFeatures;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class TropicalTrunkPlacer
extends TrunkPlacer {
    public static final Codec<TropicalTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> TropicalTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TropicalTrunkPlacer::new));

    public TropicalTrunkPlacer(int height, int heightRandomA, int randomHeightB) {
        super(height, heightRandomA, randomHeightB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)MysticFeatures.TROPICAL_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int trunkHeight, BlockPos initialPos, TreeConfiguration config) {
        Direction secondaryBranchDirection;
        TropicalTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)random, (BlockPos)initialPos.m_7495_(), (TreeConfiguration)config);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        Direction mainBranchDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
        int branchHeightLimit = trunkHeight - random.m_188503_(4) - 1;
        int branchLengthLimit = 3 - random.m_188503_(3);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int currentX = initialPos.m_123341_();
        int currentZ = initialPos.m_123343_();
        OptionalInt highestLog = OptionalInt.empty();
        for (int currentHeight = 0; currentHeight < trunkHeight; ++currentHeight) {
            int currentY = initialPos.m_123342_() + currentHeight;
            if (currentHeight >= branchHeightLimit && branchLengthLimit > 0) {
                currentX += mainBranchDirection.m_122429_();
                currentZ += mainBranchDirection.m_122431_();
                --branchLengthLimit;
            }
            if (!this.m_226187_(level, consumer, random, (BlockPos)mutablePos.m_122178_(currentX, currentY, currentZ), config)) continue;
            highestLog = OptionalInt.of(currentY + 1);
        }
        if (highestLog.isPresent()) {
            foliageAttachments.add(new FoliagePlacer.FoliageAttachment(new BlockPos(currentX, highestLog.getAsInt(), currentZ), 1, false));
        }
        if (trunkHeight > 7 && (secondaryBranchDirection = Direction.Plane.HORIZONTAL.m_235690_(random)) != mainBranchDirection) {
            int secondaryBranchStartHeight = branchHeightLimit - 3 - random.m_188503_(2);
            BlockPos lowBranchPos = initialPos.m_6630_(secondaryBranchStartHeight).m_121945_(secondaryBranchDirection);
            foliageAttachments.add(this.generateBranch(level, consumer, random, lowBranchPos, secondaryBranchDirection, config));
        }
        return foliageAttachments;
    }

    private FoliagePlacer.FoliageAttachment generateBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, BlockPos pos, Direction direction, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int currentX = pos.m_123341_();
        int currentZ = pos.m_123343_();
        this.m_226175_(level, consumer, random, pos, config, state -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
        for (int height = 1; height < 3 + random.m_188503_(1); ++height) {
            this.m_226175_(level, consumer, random, (BlockPos)mutablePos.m_122178_(currentX += direction.m_122429_(), pos.m_123342_() + height, currentZ += direction.m_122431_()), config, state -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
        }
        return new FoliagePlacer.FoliageAttachment((BlockPos)mutablePos, 0, false);
    }
}

