/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.init;

import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.common.biome.MysticBiomeProvider;
import com.mysticsbiomes.common.biome.OverworldBiomes;
import com.mysticsbiomes.common.world.MysticSurfaceRules;
import com.mysticsbiomes.init.MysticConfig;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class MysticBiomes {
    public static final ResourceKey<Biome> STRAWBERRY_FIELDS = MysticBiomes.createKey("strawberry_fields");
    public static final ResourceKey<Biome> LAVENDER_MEADOW = MysticBiomes.createKey("lavender_meadow");
    public static final ResourceKey<Biome> BAMBOO_BLOSSOM_FOREST = MysticBiomes.createKey("bamboo_blossom_forest");
    public static final ResourceKey<Biome> AUTUMNAL_GROVE = MysticBiomes.createKey("autumnal_grove");
    public static final ResourceKey<Biome> LUSH_OASIS = MysticBiomes.createKey("lush_oasis");
    public static final ResourceKey<Biome> LAGOON = MysticBiomes.createKey("lagoon");
    public static final ResourceKey<Biome> TROPICS = MysticBiomes.createKey("tropics");

    public static void registerRegionProvider() {
        Regions.register((Region)new MysticBiomeProvider((Integer)MysticConfig.COMMON.biomeRegionWeight.get()));
    }

    public static void registerSurfaceRules() {
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"mysticsbiomes", (SurfaceRules.RuleSource)MysticSurfaceRules.overworld());
    }

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter carver = context.m_255420_(Registries.f_257003_);
        HolderGetter placedFeature = context.m_255420_(Registries.f_256988_);
        context.m_255272_(STRAWBERRY_FIELDS, (Object)OverworldBiomes.strawberryFields((HolderGetter<PlacedFeature>)placedFeature, carver));
        context.m_255272_(LAVENDER_MEADOW, (Object)OverworldBiomes.lavenderMeadow((HolderGetter<PlacedFeature>)placedFeature, carver));
        context.m_255272_(BAMBOO_BLOSSOM_FOREST, (Object)OverworldBiomes.bambooBlossomForest((HolderGetter<PlacedFeature>)placedFeature, carver));
        context.m_255272_(AUTUMNAL_GROVE, (Object)OverworldBiomes.autumnalGrove((HolderGetter<PlacedFeature>)placedFeature, carver));
        context.m_255272_(LUSH_OASIS, (Object)OverworldBiomes.lushOasis((HolderGetter<PlacedFeature>)placedFeature, carver));
        context.m_255272_(LAGOON, (Object)OverworldBiomes.lagoon((HolderGetter<PlacedFeature>)placedFeature, carver));
        context.m_255272_(TROPICS, (Object)OverworldBiomes.tropics((HolderGetter<PlacedFeature>)placedFeature, carver));
    }

    private static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)MysticsBiomes.modLoc(name));
    }
}

