/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MysticConfig {
    private static final Pair<Common, ForgeConfigSpec> specPair = new ForgeConfigSpec.Builder().configure(Common::new);
    public static final ForgeConfigSpec COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    public static final Common COMMON = (Common)specPair.getLeft();

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> biomeRegionWeight;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableStrawberryFields;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableLavenderMeadow;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableBambooBlossomForest;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableAutumnalGrove;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableLushOasis;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableLagoon;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableTropics;
        public ForgeConfigSpec.ConfigValue<List<String>> rainbowChickenBiomeSpawns;
        public final ForgeConfigSpec.ConfigValue<Integer> rainbowChickenSpawnChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Mystic's Biomes", "Common Config Center"});
            builder.push("World Gen");
            this.biomeRegionWeight = builder.comment(new String[]{"The higher the number, the more common the biomes will be.", "Default: 4"}).define("Biome Region Weight", (Object)4);
            this.enableStrawberryFields = builder.comment("Determines if each biome will generate or not.").define("Strawberry Fields", true);
            this.enableLavenderMeadow = builder.define("Lavender Meadow", true);
            this.enableBambooBlossomForest = builder.define("Bamboo Blossom Forest", true);
            this.enableAutumnalGrove = builder.define("Autumnal Grove", true);
            this.enableLushOasis = builder.define("Lush Oasis", true);
            this.enableLagoon = builder.define("Lagoon", true);
            this.enableTropics = builder.define("Tropics", true);
            builder.pop();
            builder.push("Animal Spawns");
            this.rainbowChickenBiomeSpawns = builder.comment(new String[]{"Biomes an animal can spawn in.", "Values can include modded biomes and biome tags. example: \"mysticsbiomes:strawberry_fields\""}).define("Rainbow Chickens", new ArrayList<String>(Arrays.asList("minecraft:plains", "minecraft:forest", "minecraft:flower_forest")));
            this.rainbowChickenSpawnChance = builder.comment(new String[]{"The chance an animal will spawn.", "The higher the number, the more common an animal will spawn.", "Default: 6"}).define("Rainbow Chicken Spawn Chance", (Object)6);
            builder.pop();
        }
    }
}

