/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.init;

import com.mysticsbiomes.client.entity.model.ButterflyModel;
import com.mysticsbiomes.client.entity.model.RedPandaModel;
import com.mysticsbiomes.client.entity.model.SeaOtterModel;
import com.mysticsbiomes.client.entity.model.layer.MysticModelLayers;
import com.mysticsbiomes.client.entity.renderer.ButterflyRenderer;
import com.mysticsbiomes.client.entity.renderer.ChocolateCowRenderer;
import com.mysticsbiomes.client.entity.renderer.MysticBoatRenderer;
import com.mysticsbiomes.client.entity.renderer.RainbowChickenRenderer;
import com.mysticsbiomes.client.entity.renderer.RedPandaRenderer;
import com.mysticsbiomes.client.entity.renderer.SeaOtterRenderer;
import com.mysticsbiomes.client.entity.renderer.StrawberryCowRenderer;
import com.mysticsbiomes.client.entity.renderer.VanillaCowRenderer;
import com.mysticsbiomes.common.entity.MysticBoat;
import com.mysticsbiomes.common.entity.MysticChestBoat;
import com.mysticsbiomes.common.entity.MysticThrownEgg;
import com.mysticsbiomes.common.entity.animal.Butterfly;
import com.mysticsbiomes.common.entity.animal.ChocolateCow;
import com.mysticsbiomes.common.entity.animal.RainbowChicken;
import com.mysticsbiomes.common.entity.animal.RedPanda;
import com.mysticsbiomes.common.entity.animal.SeaOtter;
import com.mysticsbiomes.common.entity.animal.StrawberryCow;
import com.mysticsbiomes.common.entity.animal.VanillaCow;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="mysticsbiomes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MysticEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"mysticsbiomes");
    public static final RegistryObject<EntityType<StrawberryCow>> STRAWBERRY_COW = ENTITIES.register("strawberry_cow", () -> EntityType.Builder.m_20704_(StrawberryCow::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_("mysticsbiomes:strawberry_cow"));
    public static final RegistryObject<EntityType<VanillaCow>> VANILLA_COW = ENTITIES.register("vanilla_cow", () -> EntityType.Builder.m_20704_(VanillaCow::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_("mysticsbiomes:vanilla_cow"));
    public static final RegistryObject<EntityType<ChocolateCow>> CHOCOLATE_COW = ENTITIES.register("chocolate_cow", () -> EntityType.Builder.m_20704_(ChocolateCow::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_("mysticsbiomes:chocolate_cow"));
    public static final RegistryObject<EntityType<RainbowChicken>> RAINBOW_CHICKEN = ENTITIES.register("rainbow_chicken", () -> EntityType.Builder.m_20704_(RainbowChicken::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(10).m_20712_("mysticsbiomes:rainbow_chicken"));
    public static final RegistryObject<EntityType<RedPanda>> RED_PANDA = ENTITIES.register("red_panda", () -> EntityType.Builder.m_20704_(RedPanda::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.6f).m_20702_(10).m_20712_("mysticsbiomes:red_panda"));
    public static final RegistryObject<EntityType<SeaOtter>> SEA_OTTER = ENTITIES.register("sea_otter", () -> EntityType.Builder.m_20704_(SeaOtter::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.4f).m_20702_(10).m_20712_("mysticsbiomes:sea_otter"));
    public static final RegistryObject<EntityType<Butterfly>> BUTTERFLY = ENTITIES.register("butterfly", () -> EntityType.Builder.m_20704_(Butterfly::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.3f).m_20702_(10).m_20712_("mysticsbiomes:butterfly"));
    public static final RegistryObject<EntityType<MysticThrownEgg>> RAINBOW_EGG = ENTITIES.register("rainbow_egg", () -> EntityType.Builder.m_20704_(MysticThrownEgg::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_("mysticsbiomes:rainbow_egg"));
    public static final RegistryObject<EntityType<MysticBoat>> BOAT = ENTITIES.register("boat", () -> EntityType.Builder.m_20704_(MysticBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("mysticsbiomes:boat"));
    public static final RegistryObject<EntityType<MysticChestBoat>> CHEST_BOAT = ENTITIES.register("chest_boat", () -> EntityType.Builder.m_20704_(MysticChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("mysticsbiomes:chest_boat"));

    @SubscribeEvent
    public static void registerEntities(EntityAttributeCreationEvent event) {
        event.put((EntityType)STRAWBERRY_COW.get(), StrawberryCow.createAttributes().m_22265_());
        event.put((EntityType)VANILLA_COW.get(), VanillaCow.createAttributes().m_22265_());
        event.put((EntityType)CHOCOLATE_COW.get(), ChocolateCow.createAttributes().m_22265_());
        event.put((EntityType)RAINBOW_CHICKEN.get(), RainbowChicken.createAttributes().m_22265_());
        event.put((EntityType)RED_PANDA.get(), RedPanda.createAttributes().m_22265_());
        event.put((EntityType)SEA_OTTER.get(), SeaOtter.createAttributes().m_22265_());
        event.put((EntityType)BUTTERFLY.get(), Butterfly.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerEntitySpawns(SpawnPlacementRegisterEvent event) {
        MysticEntities.registerBasicSpawn(event, (EntityType)STRAWBERRY_COW.get());
        MysticEntities.registerBasicSpawn(event, (EntityType)VANILLA_COW.get());
        MysticEntities.registerBasicSpawn(event, (EntityType)CHOCOLATE_COW.get());
        MysticEntities.registerBasicSpawn(event, (EntityType)RAINBOW_CHICKEN.get());
        MysticEntities.registerBasicSpawn(event, (EntityType)RED_PANDA.get());
        event.register((EntityType)SEA_OTTER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SeaOtter::checkSurfaceWaterAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        MysticEntities.registerBasicSpawn(event, (EntityType)BUTTERFLY.get());
    }

    private static <T extends Animal> void registerBasicSpawn(SpawnPlacementRegisterEvent event, EntityType<T> entityType) {
        event.register(entityType, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    @Mod.EventBusSubscriber(modid="mysticsbiomes", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(MysticModelLayers.STRAWBERRY_COW, CowModel::m_170516_);
            event.registerLayerDefinition(MysticModelLayers.VANILLA_COW, CowModel::m_170516_);
            event.registerLayerDefinition(MysticModelLayers.CHOCOLATE_COW, CowModel::m_170516_);
            event.registerLayerDefinition(MysticModelLayers.RAINBOW_CHICKEN, ChickenModel::m_170491_);
            event.registerLayerDefinition(MysticModelLayers.RED_PANDA, RedPandaModel::createBodyLayer);
            event.registerLayerDefinition(MysticModelLayers.SEA_OTTER, SeaOtterModel::createBodyLayer);
            event.registerLayerDefinition(MysticModelLayers.BUTTERFLY, ButterflyModel::createBodyLayer);
            for (MysticBoat.Type type : MysticBoat.Type.values()) {
                event.registerLayerDefinition(MysticBoatRenderer.createBoatModelName(type), BoatModel::m_246613_);
                event.registerLayerDefinition(MysticBoatRenderer.createChestBoatModelName(type), ChestBoatModel::m_247175_);
            }
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)STRAWBERRY_COW.get(), StrawberryCowRenderer::new);
            event.registerEntityRenderer((EntityType)VANILLA_COW.get(), VanillaCowRenderer::new);
            event.registerEntityRenderer((EntityType)CHOCOLATE_COW.get(), ChocolateCowRenderer::new);
            event.registerEntityRenderer((EntityType)RAINBOW_CHICKEN.get(), RainbowChickenRenderer::new);
            event.registerEntityRenderer((EntityType)RED_PANDA.get(), RedPandaRenderer::new);
            event.registerEntityRenderer((EntityType)SEA_OTTER.get(), SeaOtterRenderer::new);
            event.registerEntityRenderer((EntityType)BUTTERFLY.get(), ButterflyRenderer::new);
            event.registerEntityRenderer((EntityType)RAINBOW_EGG.get(), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)BOAT.get()), context -> new MysticBoatRenderer(context, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)CHEST_BOAT.get()), context -> new MysticBoatRenderer(context, true));
        }
    }
}

