/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.init;

import com.mojang.serialization.Codec;
import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.common.world.feature.MysticTreeFeatures;
import com.mysticsbiomes.common.world.feature.MysticVegetationFeatures;
import com.mysticsbiomes.common.world.feature.decorator.ButterflyNestDecorator;
import com.mysticsbiomes.common.world.feature.decorator.PeachFruitDecorator;
import com.mysticsbiomes.common.world.feature.decorator.VanillaOrchidDecorator;
import com.mysticsbiomes.common.world.feature.misc.MapleTreeFeature;
import com.mysticsbiomes.common.world.feature.misc.SaguaroCactusFeature;
import com.mysticsbiomes.common.world.feature.misc.SpringBambooFeature;
import com.mysticsbiomes.common.world.feature.trunk.CherryTrunkPlacer;
import com.mysticsbiomes.common.world.feature.trunk.TropicalTrunkPlacer;
import com.mysticsbiomes.common.world.placement.MysticTreePlacements;
import com.mysticsbiomes.common.world.placement.MysticVegetationPlacements;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class MysticFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.f_256833_, (String)"mysticsbiomes");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATORS = DeferredRegister.create((ResourceKey)Registries.f_256845_, (String)"mysticsbiomes");
    public static final DeferredRegister<TrunkPlacerType<?>> TRUNK_PLACERS = DeferredRegister.create((ResourceKey)Registries.f_256963_, (String)"mysticsbiomes");
    public static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> SPRING_BAMBOO = FEATURES.register("spring_bamboo", () -> new SpringBambooFeature((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    public static final RegistryObject<Feature<BlockColumnConfiguration>> SAGUARO_CACTUS = FEATURES.register("saguaro_cactus", SaguaroCactusFeature::new);
    public static final RegistryObject<Feature<TreeConfiguration>> MAPLE_TREE = FEATURES.register("maple_tree", () -> new MapleTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<TreeDecoratorType<ButterflyNestDecorator>> BUTTERFLY_NEST = TREE_DECORATORS.register("butterfly_nest", () -> new TreeDecoratorType(ButterflyNestDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<PeachFruitDecorator>> PEACHES = TREE_DECORATORS.register("peaches", () -> new TreeDecoratorType(PeachFruitDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<VanillaOrchidDecorator>> VANILLA_ORCHID = TREE_DECORATORS.register("vanilla_orchid", () -> new TreeDecoratorType(VanillaOrchidDecorator.CODEC));
    public static final RegistryObject<TrunkPlacerType<CherryTrunkPlacer>> CHERRY_TRUNK_PLACER = TRUNK_PLACERS.register("cherry_trunk_placer", () -> new TrunkPlacerType(CherryTrunkPlacer.CODEC));
    public static final RegistryObject<TrunkPlacerType<TropicalTrunkPlacer>> TROPICAL_TRUNK_PLACER = TRUNK_PLACERS.register("tropical_trunk_placer", () -> new TrunkPlacerType(TropicalTrunkPlacer.CODEC));

    public static class Placed {
        public static void bootstrap(BootstapContext<PlacedFeature> context) {
            MysticTreePlacements.bootstrap(context);
            MysticVegetationPlacements.bootstrap(context);
        }

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)MysticsBiomes.modLoc(name));
        }
    }

    public static class Configured {
        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
            MysticTreeFeatures.bootstrap(context);
            MysticVegetationFeatures.bootstrap(context);
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)MysticsBiomes.modLoc(name));
        }
    }
}

