/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client;

import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomStringWidget;
import dev.ftb.mods.ftbfiltersystem.registry.FilterRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class SelectionPanel {
    private static final int BUTTON_HEIGHT = 16;
    private boolean visible;
    private GridLayout layout;
    private static final Component COMPOUND = Component.m_237115_((String)"ftbfiltersystem.gui.compound");
    private static final Component BASIC = Component.m_237115_((String)"ftbfiltersystem.gui.basic");
    private final Font font;
    private Rect2i bounds;
    private final List<Button> compoundButtons = new ArrayList<Button>();
    private final List<Button> basicButtons = new ArrayList<Button>();

    public SelectionPanel(Font font, Consumer<ResourceLocation> onClicked, int availableHeight) {
        this.font = font;
        this.createButtons(font, onClicked);
        int maxPerColumn = Math.max(1, availableHeight / 18) - 1;
        this.arrangeButtons(maxPerColumn);
    }

    public void resize(int newAvailableHeight) {
        int maxPerColumn = Math.max(1, newAvailableHeight / 18) - 1;
        this.arrangeButtons(maxPerColumn);
    }

    private void createButtons(Font font, Consumer<ResourceLocation> onClicked) {
        int widestButton = Math.max(font.m_92852_((FormattedText)BASIC), font.m_92852_((FormattedText)COMPOUND));
        for (SmartFilter filter2 : FilterRegistry.INSTANCE.defaultFilterInstances()) {
            widestButton = Math.max(widestButton, font.m_92852_((FormattedText)filter2.getDisplayName()) + 10);
        }
        for (SmartFilter filter2 : FilterRegistry.INSTANCE.defaultFilterInstances().stream().sorted(Comparator.comparing(filter -> filter.getDisplayName().getString())).toList()) {
            ResourceLocation id = filter2.getId();
            Button button = Button.m_253074_((Component)filter2.getDisplayName(), b -> onClicked.accept(id)).m_253046_(widestButton, 16).m_257505_(Tooltip.m_257550_((Component)AbstractSmartFilter.getTooltip(id))).m_253136_();
            button.f_93624_ = false;
            (filter2 instanceof SmartFilter.Compound ? this.compoundButtons : this.basicButtons).add(button);
        }
    }

    private void arrangeButtons(int maxPerColumn) {
        ArrayList<List<Object>> buttons = new ArrayList<List<Object>>();
        buttons.add(this.compoundButtons);
        int nBasic = this.basicButtons.size();
        if (nBasic > maxPerColumn) {
            int div = nBasic / (nBasic / maxPerColumn + 1) + 1;
            ArrayList<Button> l = new ArrayList<Button>();
            for (int i = 0; i < nBasic; ++i) {
                l.add(this.basicButtons.get(i));
                if (i % div != div - 1 && i != nBasic - 1) continue;
                buttons.add(new ArrayList(l));
                l.clear();
            }
        } else {
            buttons.add(this.basicButtons);
        }
        this.layout = new GridLayout();
        LayoutSettings padding = LayoutSettings.m_264214_().m_264174_(1);
        LayoutSettings paddingR = LayoutSettings.m_264214_().m_264174_(1).m_264398_(10);
        this.layout.m_264075_((LayoutElement)new CustomStringWidget(COMPOUND, this.font).m_267729_().m_269033_(-14671744), 0, 0, paddingR);
        this.layout.m_264075_((LayoutElement)new CustomStringWidget(BASIC, this.font).m_267729_().m_269033_(-14671744), 0, 1, padding);
        for (int col = 0; col < buttons.size(); ++col) {
            for (int row = 0; row < ((List)buttons.get(col)).size(); ++row) {
                this.layout.m_264075_((LayoutElement)((Button)((List)buttons.get(col)).get(row)), row + 1, col, col == 0 ? paddingR : padding);
            }
        }
        this.layout.m_264036_();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.layout.m_264134_(w -> {
            w.f_93624_ = visible;
        });
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        this.layout.m_264134_(consumer);
    }

    public void positionAndRender(GuiGraphics guiGraphics, int topEdge, int rightEdge, int mouseX, int mouseY, float partialTick) {
        int xBase = Math.max(5, rightEdge - this.layout.m_5711_());
        this.bounds = new Rect2i(xBase, topEdge, this.layout.m_5711_(), this.layout.m_93694_());
        this.layout.m_264152_(this.bounds.m_110085_(), this.bounds.m_110086_());
        GuiUtil.drawPanel(guiGraphics, GuiUtil.outsetRect(this.bounds, 3), -2697514, -12566464, GuiUtil.BorderStyle.PLAIN, 1);
        guiGraphics.m_280315_(xBase + this.compoundButtons.get(0).m_5711_() + 5, topEdge, topEdge + this.layout.m_93694_(), -6250336);
        this.visitWidgets(w -> w.m_88315_(guiGraphics, mouseX, mouseY, partialTick));
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.bounds != null && this.bounds.m_110087_((int)mouseX, (int)mouseY);
    }
}

