/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.NumericComparison;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractComparisonFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomCheckbox;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractComparisonConfigScreen<T extends AbstractComparisonFilter>
extends AbstractFilterConfigScreen<T> {
    private final BiFunction<SmartFilter.Compound, NumericComparison, T> comparisonFactory;
    protected CycleButton<NumericComparison.ComparisonOp> opBtn;
    protected EditBox numBox;
    protected CustomCheckbox pctCheckBox;

    public AbstractComparisonConfigScreen(T filter, AbstractFilterScreen parentScreen, BiFunction<SmartFilter.Compound, NumericComparison, T> comparisonFactory) {
        super(filter, parentScreen, 176, 55);
        this.comparisonFactory = comparisonFactory;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        GridLayout layout = new GridLayout(this.leftPos + 8, this.topPos + 20);
        GridLayout.RowHelper rowHelper = layout.m_264606_(5);
        CycleButton.Builder builder = CycleButton.m_168894_(NumericComparison.ComparisonOp::getDisplayName).m_168961_((Object[])NumericComparison.ComparisonOp.values()).m_168948_((Object)((AbstractComparisonFilter)this.filter).getComparison().getOp()).m_168929_();
        Objects.requireNonNull(this.f_96547_);
        this.opBtn = (CycleButton)rowHelper.m_264139_((LayoutElement)builder.m_168936_(0, 0, 20, 9 + 8, (Component)Component.m_237119_(), (btn, val) -> {}));
        rowHelper.m_264139_((LayoutElement)SpacerElement.m_264527_((int)10));
        rowHelper.m_264206_((LayoutElement)Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> this.adjustVal(-1)).m_253046_(12, 12).m_253136_(), LayoutSettings.m_264214_().m_264623_().m_264398_(2));
        Objects.requireNonNull(this.f_96547_);
        this.numBox = (EditBox)rowHelper.m_264139_((LayoutElement)new EditBox(this.f_96547_, 0, 0, 30, 9 + 8, (Component)Component.m_237119_()));
        rowHelper.m_264206_((LayoutElement)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> this.adjustVal(1)).m_253046_(12, 12).m_253136_(), LayoutSettings.m_264214_().m_264623_().m_264400_(2));
        this.numBox.m_94144_(Integer.toString(((AbstractComparisonFilter)this.filter).getComparison().getValue()));
        this.numBox.m_94151_(str -> this.adjustVal(0));
        this.numBox.m_94153_(str -> this.isValidNumber((String)str) || str.isEmpty());
        if (((AbstractComparisonFilter)this.filter).allowsPercentage()) {
            rowHelper.m_264108_((LayoutElement)SpacerElement.m_264252_((int)5), 5);
            MutableComponent txt = Component.m_237115_((String)"ftbfiltersystem.gui.percentage");
            this.pctCheckBox = (CustomCheckbox)rowHelper.m_264108_((LayoutElement)new CustomCheckbox(0, 0, this.f_96547_.m_92852_((FormattedText)txt), 20, (Component)txt, ((AbstractComparisonFilter)this.filter).getComparison().isPercentage()), 5);
        }
        layout.m_264036_();
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && this.numBox.m_94204_()) {
            this.applyChanges();
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double dir) {
        this.adjustVal(dir < 0.0 ? -1 : 1);
        return true;
    }

    private boolean isValidNumber(String str) {
        if (NumberUtils.isDigits((String)str)) {
            if (this.isPercent()) {
                int v = Integer.parseInt(str);
                return v >= 0 && v <= 100;
            }
            return true;
        }
        return false;
    }

    private void adjustVal(int amount) {
        try {
            String s = this.numBox.m_94155_();
            int value = (s.isEmpty() ? 0 : Integer.parseInt(s)) + amount;
            this.numBox.m_94151_(str -> {});
            this.numBox.m_94144_(String.valueOf(value));
            this.numBox.m_94151_(str -> this.adjustVal(0));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    protected T makeNewFilter() {
        try {
            int value = Integer.parseInt(this.numBox.m_94155_());
            NumericComparison comparison = new NumericComparison((NumericComparison.ComparisonOp)((Object)this.opBtn.m_168883_()), value, this.isPercent());
            return (T)((AbstractComparisonFilter)this.comparisonFactory.apply(((AbstractComparisonFilter)this.filter).getParent(), comparison));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected boolean isPercent() {
        return this.pctCheckBox != null && this.pctCheckBox.selected();
    }
}

