/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.registry;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemRegistry;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public enum FilterRegistry implements FTBFilterSystemRegistry
{
    INSTANCE;

    private final Map<ResourceLocation, FilterDetails<?>> filterMap = new ConcurrentHashMap();
    private final Map<ResourceLocation, SmartFilter> defaultInstances = new ConcurrentHashMap<ResourceLocation, SmartFilter>();
    private boolean frozen = false;

    @Override
    public <T extends SmartFilter> void register(ResourceLocation id, SmartFilter.Factory<T> factory, SmartFilter.DefaultFactory<T> defaultFactory) {
        if (this.frozen) {
            throw new IllegalStateException("filter registry is now frozen!");
        }
        this.filterMap.put(id, new FilterDetails<T>(id, factory, defaultFactory));
    }

    @Override
    public Collection<ResourceLocation> allFilterKeys() {
        return Collections.unmodifiableCollection(this.filterMap.keySet());
    }

    @Override
    public Collection<SmartFilter> defaultFilterInstances() {
        return this.defaultInstances.values();
    }

    public Optional<FilterDetails<?>> getDetails(ResourceLocation type) {
        return Optional.ofNullable(this.filterMap.get(type));
    }

    public void freeze() {
        this.frozen = true;
        this.filterMap.forEach((id, entry) -> this.defaultInstances.put((ResourceLocation)id, (SmartFilter)entry.defaultSupplier().create(null)));
    }

    public Optional<SmartFilter> createDefaultFilter(SmartFilter.Compound parent, ResourceLocation filterId) {
        if (this.filterMap.containsKey(filterId)) {
            return Optional.of(this.filterMap.get(filterId).defaultSupplier().create(parent));
        }
        return Optional.empty();
    }

    public record FilterDetails<T extends SmartFilter>(ResourceLocation id, SmartFilter.Factory<T> factory, SmartFilter.DefaultFactory<T> defaultSupplier) {
    }
}

