/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod;

import dev.architectury.platform.Platform;
import io.github.thatpreston.mermod.MermodPlatform;
import io.github.thatpreston.mermod.client.render.TailStyle;
import io.github.thatpreston.mermod.config.MermodConfig;
import io.github.thatpreston.mermod.registry.RegistryHandler;
import java.util.Map;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Mermod {
    public static boolean originsLoaded;
    public static boolean figuraLoaded;
    public static final String MOD_ID = "mermod";

    public static void init() {
        RegistryHandler.register();
        originsLoaded = Platform.isModLoaded((String)"origins");
        figuraLoaded = Platform.isModLoaded((String)"figura");
    }

    public static void registerCauldronInteractions() {
        Map map = CauldronInteraction.f_175607_;
        map.put((Item)RegistryHandler.SEA_NECKLACE.get(), CauldronInteraction.f_175615_);
        map.put((Item)RegistryHandler.MERMAID_BRA_MODIFIER.get(), CauldronInteraction.f_175615_);
        map.put((Item)RegistryHandler.TAIL_GRADIENT_MODIFIER.get(), CauldronInteraction.f_175615_);
    }

    public static ItemStack getNecklace(Player player) {
        ItemStack necklace = player.m_6844_(EquipmentSlot.CHEST);
        if (necklace.m_150930_((Item)RegistryHandler.SEA_NECKLACE.get())) {
            return necklace;
        }
        return MermodPlatform.getNecklaceFromAccessorySlot(player);
    }

    public static TailStyle getTailStyle(Player player) {
        ItemStack necklace = Mermod.getNecklace(player);
        if (!necklace.m_41619_()) {
            return TailStyle.fromNecklace(necklace);
        }
        return MermodPlatform.getTailStyle(player);
    }

    public static boolean hasTailStyle(Player player) {
        ItemStack necklace = Mermod.getNecklace(player);
        return !necklace.m_41619_() || MermodPlatform.hasTailStyle(player);
    }

    public static int getItemColor(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("display");
        return tag != null && tag.m_128425_("color", 99) ? tag.m_128451_("color") : 0xFFFFFF;
    }

    public static void addEffects(LivingEntity entity) {
        if (entity.m_20069_()) {
            if (MermodConfig.getWaterBreathing() && !entity.m_21023_(MobEffects.f_19608_)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200, 0, true, false));
            }
            if (MermodConfig.getNightVision() && !entity.m_21023_(MobEffects.f_19611_)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 200, 0, true, false));
            }
        }
    }
}

