/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.compat;

import io.github.thatpreston.mermod.Mermod;
import io.github.thatpreston.mermod.client.render.TailStyle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.entries.FiguraAPI;
import org.figuramc.figura.entries.annotations.FiguraAPIPlugin;
import org.figuramc.figura.lua.LuaWhitelist;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@FiguraAPIPlugin
@LuaWhitelist
public class MermodFiguraAPI
implements FiguraAPI {
    public static final Map<UUID, Boolean> TAIL_VISIBLE = new HashMap<UUID, Boolean>();
    private Avatar avatar;

    public MermodFiguraAPI() {
    }

    public MermodFiguraAPI(Avatar avatar) {
        this.avatar = avatar;
    }

    public FiguraAPI build(Avatar avatar) {
        return new MermodFiguraAPI(avatar);
    }

    public String getName() {
        return "mermod_tail";
    }

    public Collection<Class<?>> getWhitelistedClasses() {
        return List.of(MermodFiguraAPI.class);
    }

    public Collection<Class<?>> getDocsClasses() {
        return List.of();
    }

    @LuaWhitelist
    public void setVisible(boolean value) {
        TAIL_VISIBLE.put(this.avatar.owner, value);
    }

    @LuaWhitelist
    public LuaValue getTailStyle() {
        Player player;
        TailStyle style;
        Entity entity = this.avatar.luaRuntime.getUser();
        if (entity instanceof Player && (style = Mermod.getTailStyle(player = (Player)entity)) != null) {
            LuaTable table = new LuaTable();
            table.set("texture", (LuaValue)LuaValue.valueOf((String)style.texture().toString()));
            table.set("model", (LuaValue)LuaValue.valueOf((int)style.model()));
            this.setRGB(table, "tailColor", style.tailColor());
            table.set("hasBra", (LuaValue)LuaValue.valueOf((boolean)style.hasBra()));
            this.setRGB(table, "braColor", style.braColor());
            table.set("hasGradient", (LuaValue)LuaValue.valueOf((boolean)style.hasGradient()));
            this.setRGB(table, "gradientColor", style.gradientColor());
            table.set("hasGlint", (LuaValue)LuaValue.valueOf((boolean)style.hasGlint()));
            return table;
        }
        return LuaValue.NIL;
    }

    private void setRGB(LuaTable table, String name, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        table.set(name + "R", (double)red);
        table.set(name + "G", (double)green);
        table.set(name + "B", (double)blue);
    }

    public static boolean isTailVisible(UUID uuid) {
        return TAIL_VISIBLE.getOrDefault(uuid, true);
    }
}

