/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.thatpreston.mermod.MermodClient;
import io.github.thatpreston.mermod.client.render.model.TailModel;
import io.github.thatpreston.mermod.config.MermodConfig;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Inject(method={"setupRotations(Lnet/minecraft/client/player/AbstractClientPlayer;Lcom/mojang/blaze3d/vertex/PoseStack;FFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;setupRotations(Lnet/minecraft/world/entity/LivingEntity;Lcom/mojang/blaze3d/vertex/PoseStack;FFF)V", shift=At.Shift.AFTER, ordinal=1)}, cancellable=true)
    private void onSetupRotations(AbstractClientPlayer player, PoseStack stack, float age, float yaw, float partialTicks, CallbackInfo info) {
        if (MermodConfig.getReplaceSwimAnimation() && MermodClient.shouldRenderTail((Player)player)) {
            float swimAngle;
            float swimAmount = player.m_20998_(partialTicks);
            float f = swimAngle = player.m_20069_() ? -90.0f - player.m_5686_(partialTicks) : -90.0f;
            if (player.m_20069_()) {
                swimAngle += TailModel.getAngleWithOffset(age, -0.1f, 0.035f, 10.0f) + 6.0f;
            }
            stack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)swimAmount, (float)0.0f, (float)swimAngle)));
            if (player.m_6067_()) {
                stack.m_252880_(0.0f, -1.0f, 0.3f);
            }
            info.cancel();
        }
    }

    @Inject(method={"setModelProperties(Lnet/minecraft/client/player/AbstractClientPlayer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;isCrouching()Z", shift=At.Shift.AFTER)})
    private void onSetModelProperties(AbstractClientPlayer player, CallbackInfo info) {
        if (MermodClient.shouldRenderTail((Player)player)) {
            PlayerModel model = (PlayerModel)this.m_7200_();
            model.f_102813_.f_104207_ = false;
            model.f_103377_.f_104207_ = false;
            model.f_102814_.f_104207_ = false;
            model.f_103376_.f_104207_ = false;
        }
    }
}

