/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.github.thatpreston.mermod.item.SeaNecklaceItem;
import io.github.thatpreston.mermod.item.modifier.DyeableNecklaceModifierItem;
import io.github.thatpreston.mermod.item.modifier.NecklaceModifier;
import io.github.thatpreston.mermod.item.modifier.NecklaceModifierItem;
import io.github.thatpreston.mermod.item.modifier.TailModifier;
import io.github.thatpreston.mermod.recipe.NecklaceModifierRecipe;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;

public class RegistryHandler {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"mermod", (ResourceKey)Registries.f_256913_);
    public static final RegistrySupplier<Item> SEA_NECKLACE = ITEMS.register("sea_necklace", SeaNecklaceItem::new);
    public static final RegistrySupplier<Item> SEA_CRYSTAL = ITEMS.register("sea_crystal", () -> new Item(new Item.Properties().arch$tab(CreativeModeTabs.f_256968_)));
    public static final RegistrySupplier<Item> MERMAID_BRA_MODIFIER = RegistryHandler.registerModifier(new NecklaceModifier("mermaid_bra", "bra", 0, false));
    public static final RegistrySupplier<Item> GLOWING_PEARL_MODIFIER = RegistryHandler.registerModifier(new NecklaceModifier("glowing_pearl", "glint", 0xFFFF64, true));
    public static final RegistrySupplier<Item> TAIL_GRADIENT_MODIFIER = RegistryHandler.registerModifier(new NecklaceModifier("tail_gradient", "gradient", 0, false));
    public static final RegistrySupplier<Item> TAIL_MOISTURIZER_MODIFIER = RegistryHandler.registerModifier(new NecklaceModifier("tail_moisturizer", "permanent", 0xEFEBFF, true));
    public static final RegistrySupplier<Item> MOON_ROCK_MODIFIER = RegistryHandler.registerModifier(new TailModifier("moon_rock", 16755968, "h2o", 1));
    public static final RegistrySupplier<Item> URSULA_SHELL_MODIFIER = RegistryHandler.registerModifier(new TailModifier("ursula_shell", 16768000, "ariel", 0));
    public static final RegistrySupplier<Item> DEEP_SEA_CRYSTAL_MODIFIER = RegistryHandler.registerModifier(new TailModifier("deep_sea_crystal", 4608611, "siren", 2));
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((String)"mermod", (ResourceKey)Registries.f_256764_);
    public static final RegistrySupplier<RecipeSerializer<NecklaceModifierRecipe>> NECKLACE_MODIFIER_SERIALIZER = RECIPES.register("crafting_special_necklace_modifier", () -> new SimpleCraftingRecipeSerializer(NecklaceModifierRecipe::new));

    public static void register() {
        ITEMS.register();
        RECIPES.register();
    }

    private static RegistrySupplier<Item> registerModifier(NecklaceModifier modifier) {
        Supplier<Item> supplier = modifier.getTooltipColor() == 0 ? () -> new DyeableNecklaceModifierItem(modifier) : () -> new NecklaceModifierItem(modifier);
        return ITEMS.register(modifier.getId() + "_modifier", supplier);
    }
}

