/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java;

import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import com.probejs.util.Util;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

public class FieldInfo {
    private final String name;
    private final int modifiers;
    private final boolean shouldHide;
    private final Object value;
    private ITypeInfo info;
    private final List<Annotation> annotations;

    public FieldInfo(JavaMembers.FieldInfo fieldInfo) {
        Field field = fieldInfo.field;
        this.name = fieldInfo.name.isEmpty() ? field.getName() : fieldInfo.name;
        this.modifiers = field.getModifiers();
        this.shouldHide = field.getAnnotation(HideFromJS.class) != null;
        this.info = InfoTypeResolver.resolveType(field.getGenericType());
        this.value = Util.tryOrDefault(() -> this.isStatic() ? field.get(null) : null, null);
        this.annotations = List.of(field.getAnnotations());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldHide() {
        return this.shouldHide;
    }

    public ITypeInfo getType() {
        return this.info;
    }

    public Object getStaticValue() {
        return this.value;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setTypeInfo(ITypeInfo info) {
        this.info = info;
    }
}

