/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.GearSetRegistry;
import dev.shadowsoffire.placebo.json.WeightedItemStack;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public record GearSet(int weight, float quality, List<WeightedItemStack> mainhands, List<WeightedItemStack> offhands, List<WeightedItemStack> boots, List<WeightedItemStack> leggings, List<WeightedItemStack> chestplates, List<WeightedItemStack> helmets, List<String> tags) implements CodecProvider<GearSet>,
WeightedDynamicRegistry.ILuckyWeighted
{
    public static final Codec<GearSet> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField(Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), "quality", Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "mainhands", Collections.emptyList()).forGetter(g -> g.mainhands), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "offhands", Collections.emptyList()).forGetter(g -> g.offhands), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "boots", Collections.emptyList()).forGetter(g -> g.boots), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "leggings", Collections.emptyList()).forGetter(g -> g.leggings), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "chestplates", Collections.emptyList()).forGetter(g -> g.chestplates), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "helmets", Collections.emptyList()).forGetter(g -> g.helmets), (App)Codec.STRING.listOf().fieldOf("tags").forGetter(g -> g.tags)).apply((Applicative)inst, GearSet::new));

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public float getQuality() {
        return this.quality;
    }

    public LivingEntity apply(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            WeightedRandom.m_216822_((RandomSource)entity.m_217043_(), this.getPotentials(slot)).ifPresent(s -> s.apply(entity, slot));
        }
        return entity;
    }

    public List<WeightedItemStack> getPotentials(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.MAINHAND -> this.mainhands;
            case EquipmentSlot.OFFHAND -> this.offhands;
            case EquipmentSlot.FEET -> this.boots;
            case EquipmentSlot.LEGS -> this.leggings;
            case EquipmentSlot.CHEST -> this.chestplates;
            case EquipmentSlot.HEAD -> this.helmets;
        };
    }

    @Override
    public Codec<? extends GearSet> getCodec() {
        return CODEC;
    }

    public static class SetPredicate
    implements Predicate<GearSet> {
        public static final Codec<SetPredicate> CODEC = ExtraCodecs.m_184405_(s -> s.key, SetPredicate::new);
        protected final String key;
        protected final Predicate<GearSet> internal;

        public SetPredicate(String key) {
            this.key = key;
            if (key.startsWith("#")) {
                String tag = key.substring(1);
                this.internal = t -> t.tags.contains(tag);
            } else {
                ResourceLocation id = new ResourceLocation(key);
                this.internal = t -> GearSetRegistry.INSTANCE.getKey(t).equals((Object)id);
            }
        }

        @Override
        public boolean test(GearSet t) {
            return this.internal.test(t);
        }

        public String toString() {
            return "SetPredicate[" + this.key + "]";
        }
    }
}

