/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfy.meadow.client.gui.handler.WoodcutterGuiHandler;
import net.satisfy.meadow.recipes.WoodcuttingRecipe;
import net.satisfy.meadow.util.MeadowIdentifier;

public class WoodcutterGui
extends AbstractContainerScreen<WoodcutterGuiHandler> {
    private static final ResourceLocation TEXTURE = new MeadowIdentifier("textures/gui/woodcutter.png");
    private final int recipeIconPosX = 58;
    private final int recipeIconPosY = 15;
    private final int maxRecipeIcons = 12;
    private final int recipeIconWidth = 16;
    private final int recipeIconHeight = 18;
    private final int recipeIconPerLine = 4;
    private boolean canCraft;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;

    public WoodcutterGui(WoodcutterGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280072_(context, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        this.m_280273_(context);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int posX = this.f_97735_;
        int posY = this.f_97736_;
        context.m_280218_(TEXTURE, posX, posY, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollAmount);
        if (this.shouldScroll()) {
            context.m_280218_(TEXTURE, posX + 124, posY + 14 + k, 176, 0, 11, 15);
        }
        int recipeX = posX + 58;
        int recipeY = posY + 15;
        int scrollOffsetOFF = this.scrollOffset + 12;
        this.renderRecipeBackground(context, mouseX, mouseY, recipeX, recipeY, scrollOffsetOFF);
        this.renderRecipeIcons(context, recipeX, recipeY, scrollOffsetOFF);
    }

    private void renderRecipeBackground(GuiGraphics context, int mouseX, int mouseY, int x, int y, int scrollOffsetOFF) {
        for (int i = this.scrollOffset; i < scrollOffsetOFF && i < ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount(); ++i) {
            int offsetedI = i - this.scrollOffset;
            int posX = x + 16 * (offsetedI % 4);
            int l = offsetedI / 4;
            int posY = y + 18 * l;
            int offsetY = this.f_97727_;
            if (i == ((WoodcutterGuiHandler)this.f_97732_).getSelectedRecipe()) {
                offsetY += 18;
            } else if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 18) {
                offsetY += 36;
            }
            context.m_280218_(TEXTURE, posX, posY, 0, offsetY, 16, 18);
        }
    }

    private void renderRecipeIcons(GuiGraphics context, int x, int y, int scrollOffsetOFF) {
        List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipes();
        for (int i = this.scrollOffset; i < scrollOffsetOFF && i < ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount(); ++i) {
            int offsetedI = i - this.scrollOffset;
            int k = x + 16 * (offsetedI % 4);
            int l = offsetedI / 4;
            int m = y + 18 * l + 1;
            context.m_280480_(list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_()), k, m);
        }
    }

    protected void m_280072_(GuiGraphics context, int x, int y) {
        super.m_280072_(context, x, y);
        if (this.canCraft) {
            int i = this.f_97735_ + 58;
            int j = this.f_97736_ + 15;
            int scrollOffsetOFF = this.scrollOffset + 12;
            List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipes();
            for (int l = this.scrollOffset; l < scrollOffsetOFF && l < ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount(); ++l) {
                int offsetedL = l - this.scrollOffset;
                int n = i + offsetedL % 4 * 16;
                int o = j + offsetedL / 4 * 18;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                context.m_280153_(this.f_96547_, list.get(l).m_8043_(this.f_96541_.f_91073_.m_9598_()), x, y);
            }
        }
    }

    private void onInventoryChange() {
        this.canCraft = ((WoodcutterGuiHandler)this.f_97732_).canCraft();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int i = this.f_97735_ + 58;
            int j = this.f_97736_ + 15;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int offsetedL = l - this.scrollOffset;
                double d = mouseX - (double)(i + offsetedL % 4 * 16);
                double e = mouseY - (double)(j + offsetedL / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WoodcutterGuiHandler)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l))) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((WoodcutterGuiHandler)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 124;
            j = this.f_97736_ + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 11) && mouseY >= (double)j && mouseY < (double)(j + 58)) {
                this.mouseClicked = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.f_97736_ + 15;
            int j = i + 58;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = Mth.m_14036_((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            float f = (float)amount / (float)i;
            this.scrollAmount = Mth.m_14036_((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean shouldScroll() {
        return this.canCraft && ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }
}

