/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui.handler;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.recipes.WoodcuttingRecipe;
import net.satisfy.meadow.registry.ObjectRegistry;
import net.satisfy.meadow.registry.RecipeRegistry;
import net.satisfy.meadow.registry.ScreenHandlerRegistry;
import net.satisfy.meadow.registry.SoundRegistry;

public class WoodcutterGuiHandler
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final Level world;
    private List<WoodcuttingRecipe> availableRecipes = Lists.newArrayList();
    private ItemStack inputStack = ItemStack.f_41583_;
    private long lastTakeTime;
    private Slot inputSlot;
    private Slot outputSlot;
    Runnable contentsChangedListener = () -> {};
    public final Container input = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            WoodcutterGuiHandler.this.m_6199_((Container)this);
            WoodcutterGuiHandler.this.contentsChangedListener.run();
        }
    };
    final ResultContainer output = new ResultContainer();

    public WoodcutterGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public WoodcutterGuiHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super((MenuType)ScreenHandlerRegistry.WOODCUTTER_SCREEN_HANDLER.get(), syncId);
        this.context = context;
        this.world = playerInventory.f_35978_.m_9236_();
        this.buildBlockEntityContainer(playerInventory);
        this.buildPlayerContainer(playerInventory);
        this.m_38895_(this.selectedRecipe);
    }

    private void buildBlockEntityContainer(Inventory playerInventory) {
        this.inputSlot = this.m_38897_(new Slot(this.input, 0, 33, 24));
        this.outputSlot = this.m_38897_((Slot)new FurnaceResultSlot(playerInventory.f_35978_, (Container)this.output, 1, 144, 34){

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                WoodcutterGuiHandler.this.output.m_58395_(player, this.getInputStacks());
                ItemStack itemStack = WoodcutterGuiHandler.this.inputSlot.m_6201_(1);
                if (!itemStack.m_41619_()) {
                    WoodcutterGuiHandler.this.populateResult();
                }
                WoodcutterGuiHandler.this.context.m_39292_((world, pos) -> {
                    long l = world.m_46467_();
                    if (WoodcutterGuiHandler.this.lastTakeTime != l) {
                        world.m_5594_(null, pos, (SoundEvent)SoundRegistry.WOODCUTTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        WoodcutterGuiHandler.this.lastTakeTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getInputStacks() {
                return List.of(WoodcutterGuiHandler.this.inputSlot.m_7993_());
            }
        });
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<WoodcuttingRecipe> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public boolean canCraft() {
        return this.inputSlot.m_6657_() && !this.availableRecipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return WoodcutterGuiHandler.m_38889_((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)ObjectRegistry.WOODCUTTER.get()));
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isInBounds(id)) {
            this.selectedRecipe.m_6422_(id);
            this.populateResult();
        }
        return true;
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.availableRecipes.size();
    }

    public void m_6199_(Container inventory) {
        ItemStack itemStack = this.inputSlot.m_7993_();
        if (!itemStack.m_150930_(this.inputStack.m_41720_())) {
            this.inputStack = itemStack.m_41777_();
            this.updateInput(inventory, itemStack);
        }
    }

    private void updateInput(Container input, ItemStack stack) {
        this.availableRecipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputSlot.m_269060_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.availableRecipes = this.world.m_7465_().m_44056_((RecipeType)RecipeRegistry.WOODCUTTING.get(), input, this.world);
        }
    }

    void populateResult() {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.selectedRecipe.m_6501_())) {
            WoodcuttingRecipe woodcuttingRecipe = this.availableRecipes.get(this.selectedRecipe.m_6501_());
            ItemStack itemStack = woodcuttingRecipe.m_5874_(this.input, this.world.m_9598_());
            if (itemStack.m_246617_(this.world.m_246046_())) {
                this.output.m_6029_((Recipe)woodcuttingRecipe);
                this.outputSlot.m_5852_(itemStack);
            } else {
                this.outputSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ScreenHandlerRegistry.WOODCUTTER_SCREEN_HANDLER.get();
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.output && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (index == 1) {
                item.m_7836_(itemStack2, player.m_9236_(), player);
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (index == 0 ? !this.m_38903_(itemStack2, 2, 38, false) : (this.world.m_7465_().m_44015_((RecipeType)RecipeRegistry.WOODCUTTING.get(), (Container)new SimpleContainer(new ItemStack[]{itemStack2}), this.world).isPresent() ? !this.m_38903_(itemStack2, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemStack2, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemStack2, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.output.m_8016_(1);
        this.context.m_39292_((world, pos) -> this.m_150411_(player, this.input));
    }
}

