/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.meadow.entity.var.ShearableCowVar;
import net.satisfy.meadow.registry.EntityRegistry;
import net.satisfy.meadow.registry.ObjectRegistry;
import net.satisfy.meadow.util.MeadowIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShearableVarCow
extends Animal
implements Shearable,
VariantHolder<ShearableCowVar> {
    private static final EntityDataAccessor<Boolean> IS_SHEARED = SynchedEntityData.m_135353_(ShearableVarCow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(ShearableVarCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ResourceLocation COW_LOOT_TABLE = new ResourceLocation("entities/cow");
    private int eatGrassTimer;
    private EatBlockGoal eatGrassGoal;

    public ShearableVarCow(EntityType<ShearableVarCow> entityType, Level world) {
        super(entityType, world);
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        if (this.isSheared()) {
            return COW_LOOT_TABLE;
        }
        ResourceLocation location = BuiltInRegistries.f_257033_.m_7981_((Object)this.getVariant().getWool());
        String s = location.m_135815_().replace("_wool", "");
        return new MeadowIdentifier("entities/wooly_cow/" + s);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_)) {
            if (!this.m_9236_().f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                itemStack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_150930_((Item)ObjectRegistry.WOODEN_BUCKET.get()) && !this.m_6162_()) {
            player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)this.getVariant().getBucket().m_7968_());
            player.m_21008_(hand, itemStack2);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(@NotNull SoundSource shearedSoundCategory) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)this.getVariant().getWool(), 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Sheared", this.isSheared());
        nbt.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSheared(nbt.m_128471_("Sheared"));
        this.setTypeVariant(nbt.m_128451_("Variant"));
    }

    public void m_8035_() {
        super.m_8035_();
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    protected void m_8024_() {
        this.eatGrassTimer = this.eatGrassGoal.m_25213_();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        super.m_8107_();
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(IS_SHEARED, (Object)sheared);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SHEARED, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHEARED);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public void m_7822_(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.m_7822_(status);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        if (this.eatGrassTimer < 4) {
            return ((float)this.eatGrassTimer - delta) / 4.0f;
        }
        return -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        if (this.eatGrassTimer > 0) {
            return 0.62831855f;
        }
        return this.m_146909_() * ((float)Math.PI / 180);
    }

    @Nullable
    public ShearableVarCow getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        ShearableVarCow cow = (ShearableVarCow)((EntityType)EntityRegistry.SHEARABLE_MEADOW_VAR_COW.get()).m_20615_((Level)serverLevel);
        if (cow == null) {
            return null;
        }
        RandomSource random = serverLevel.m_213780_();
        ShearableCowVar var = this.getVariant();
        if (random.m_188499_() && ageableMob instanceof ShearableVarCow) {
            ShearableVarCow varCow = (ShearableVarCow)ageableMob;
            var = varCow.getVariant();
        }
        cow.setVariant(var);
        return cow;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor serverLevelAccessor, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        ShearableCowVar variant;
        if (spawnGroupData instanceof ShearableVarCowGroupData) {
            ShearableVarCowGroupData data = (ShearableVarCowGroupData)((Object)spawnGroupData);
            variant = data.variant;
        } else {
            variant = ShearableCowVar.getRandomVariant((LevelAccessor)serverLevelAccessor, this.m_20183_(), mobSpawnType.equals((Object)MobSpawnType.SPAWN_EGG));
            spawnGroupData = new ShearableVarCowGroupData(variant);
        }
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void setVariant(ShearableCowVar variant) {
        this.setTypeVariant(variant.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @NotNull
    public ShearableCowVar getVariant() {
        return ShearableCowVar.byId(this.getTypeVariant() & 0xFF);
    }

    private void setTypeVariant(int i) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(5, (Goal)this.eatGrassGoal);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11830_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_11832_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11831_;
    }

    protected void m_7355_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions entityDimensions) {
        return this.m_6162_() ? entityDimensions.f_20378_ * 0.95f : 1.3f;
    }

    public static class ShearableVarCowGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final ShearableCowVar variant;

        public ShearableVarCowGroupData(ShearableCowVar variant) {
            super(true);
            this.variant = variant;
        }
    }
}

