/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.entity.var;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.MeadowExpectPlatform;
import net.satisfy.meadow.registry.ObjectRegistry;
import net.satisfy.meadow.registry.TagRegistry;
import net.satisfy.meadow.world.CommonSpawnUtil;
import org.jetbrains.annotations.NotNull;

public enum SheepVar implements StringRepresentable
{
    DEFAULT(0, "sheep", Items.f_41870_),
    FLECKED(1, "flecked", ((Block)ObjectRegistry.FLECKED_WOOL.get()).m_5456_()),
    FUZZY(2, "fuzzy", ((Block)ObjectRegistry.ROCKY_WOOL.get()).m_5456_()),
    INKY(3, "inky", ((Block)ObjectRegistry.INKY_WOOL.get()).m_5456_()),
    LONG_NOSED(4, "long_nosed", ((Block)ObjectRegistry.HIGHLAND_WOOL.get()).m_5456_()),
    PATCHED(5, "patched", ((Block)ObjectRegistry.PATCHED_WOOL.get()).m_5456_()),
    ROCKY(6, "rocky", ((Block)ObjectRegistry.ROCKY_WOOL.get()).m_5456_()),
    HORNED(7, "horned", Items.f_41870_);

    public static final Codec<SheepVar> CODEC;
    private static final IntFunction<SheepVar> BY_ID;
    private final int id;
    private final String name;
    private final Item wool;
    private static final Map<SheepVar, TagKey<Biome>> SPAWNS;

    private SheepVar(int id, String name, Item wool) {
        this.id = id;
        this.name = name;
        this.wool = wool;
    }

    public Item getWool() {
        return this.wool;
    }

    public int getId() {
        return this.id;
    }

    public static SheepVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public static void setVariant(Sheep sheep, SheepVar variant) {
        SheepVar.setTypeVariant(sheep, variant.getId() & 0xFF | SheepVar.getTypeVariant(sheep) & 0xFFFFFF00);
    }

    public static SheepVar getVariant(Sheep sheep) {
        return SheepVar.byId(SheepVar.getTypeVariant(sheep) & 0xFF);
    }

    public static void setTypeVariant(Sheep sheep, int i) {
        MeadowExpectPlatform.setTypeVariant((Entity)sheep, i);
    }

    public static int getTypeVariant(Sheep sheep) {
        return MeadowExpectPlatform.getTypeVariant((Entity)sheep);
    }

    public static SheepVar getRandomVariant(LevelAccessor levelAccessor, BlockPos blockPos, boolean spawnEgg) {
        Holder holder = levelAccessor.m_204166_(blockPos);
        List<SheepVar> possibleVars = SheepVar.getSheepVariantsInBiome((Holder<Biome>)holder);
        int size = possibleVars.size();
        RandomSource random = levelAccessor.m_213780_();
        if (size == 0 || spawnEgg) {
            return (SheepVar)((Object)Util.m_214670_((Object[])SheepVar.values(), (RandomSource)random));
        }
        return possibleVars.get(random.m_188503_(size));
    }

    private static List<SheepVar> getSheepVariantsInBiome(Holder<Biome> biome) {
        return SPAWNS.keySet().stream().filter(sheepVar -> {
            TagKey<Biome> biomeTag = SPAWNS.get(sheepVar);
            if (biomeTag == null) {
                return CommonSpawnUtil.spawnsInBiome(biome, true, EntityType.f_20520_);
            }
            return biome.m_203656_(biomeTag);
        }).collect(Collectors.toList());
    }

    static {
        CODEC = StringRepresentable.m_216439_(SheepVar::values);
        BY_ID = ByIdMap.m_262839_(SheepVar::getId, (Object[])SheepVar.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        SPAWNS = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(DEFAULT, null);
            map.put(FLECKED, TagRegistry.SPAWNS_SUNSET_COW);
            map.put(FUZZY, TagRegistry.IS_MEADOW);
            map.put(INKY, null);
            map.put(LONG_NOSED, TagRegistry.SPAWNS_ROCKY_SHEEP);
            map.put(PATCHED, null);
            map.put(ROCKY, TagRegistry.SPAWNS_ROCKY_SHEEP);
            map.put(HORNED, TagRegistry.SPAWNS_ROCKY_SHEEP);
        });
    }
}

