/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions;

import com.github.eterdelta.crittersandcompanions.client.model.BubbleModel;
import com.github.eterdelta.crittersandcompanions.client.model.GrapplingHookModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.DragonflyModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.DumboOctopusModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.FerretModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.JumpingSpiderModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.KoiFishModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.LeafInsectModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.RedPandaModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.SeaBunnyModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.ShimaEnagaModel;
import com.github.eterdelta.crittersandcompanions.client.renderer.BubbleLayer;
import com.github.eterdelta.crittersandcompanions.client.renderer.GrapplingHookRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.SilkLeashRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.OtterRenderer;
import com.github.eterdelta.crittersandcompanions.entity.DragonflyEntity;
import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.FerretEntity;
import com.github.eterdelta.crittersandcompanions.entity.JumpingSpiderEntity;
import com.github.eterdelta.crittersandcompanions.entity.KoiFishEntity;
import com.github.eterdelta.crittersandcompanions.entity.LeafInsectEntity;
import com.github.eterdelta.crittersandcompanions.entity.OtterEntity;
import com.github.eterdelta.crittersandcompanions.entity.RedPandaEntity;
import com.github.eterdelta.crittersandcompanions.entity.SeaBunnyEntity;
import com.github.eterdelta.crittersandcompanions.entity.ShimaEnagaEntity;
import com.github.eterdelta.crittersandcompanions.handler.SpawnHandler;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.registry.CACBlocks;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.resource.PathPackResources;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@Mod(value="crittersandcompanions")
public class CrittersAndCompanions {
    public static final String MODID = "crittersandcompanions";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"crittersandcompanions");
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("main", () -> ((CreativeModeTab.Builder)CreativeModeTab.builder().m_257737_(() -> ((Item)CACItems.PEARL_NECKLACE_1.get()).m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.crittersandcompanions"))).m_257652_());

    public CrittersAndCompanions() {
        GeckoLib.initialize();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.register((Object)this);
        CACBlocks.BLOCKS.register(eventBus);
        CACEntities.ENTITIES.register(eventBus);
        CACItems.ITEMS.register(eventBus);
        CREATIVE_TABS.register(eventBus);
        CACSounds.SOUNDS.register(eventBus);
        if (FMLEnvironment.dist.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(SilkLeashRenderer::renderSilkLeash);
        }
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        SpawnHandler.datagenBiomeModifiers(event);
    }

    @SubscribeEvent
    public void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFile modFile = ModList.get().getModFileById(MODID).getFile();
            Path resourcePath = modFile.findResource(new String[]{"builtin/friendlyart"});
            try (PathPackResources pack = new PathPackResources(modFile.getFileName() + ":" + resourcePath, true, resourcePath);){
                event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"builtin/crittersandcompanions", (Component)Component.m_237113_((String)"Friendly Critter Art"), (boolean)false, ignored -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_)));
            }
        }
    }

    @SubscribeEvent
    public void onSetup(FMLCommonSetupEvent event) {
        CACPacketHandler.registerPackets();
        event.enqueueWork(SpawnHandler::registerSpawnPlacements);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)CACItems.DUMBO_OCTOPUS_BUCKET.get()), (ResourceLocation)new ResourceLocation("variant"), (stack, clientLevel, entity, seed) -> {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BucketVariant")) {
                    return stack.m_41783_().m_128451_("BucketVariant");
                }
                return 0.0f;
            });
            ItemProperties.register((Item)((Item)CACItems.SEA_BUNNY_BUCKET.get()), (ResourceLocation)new ResourceLocation("variant"), (stack, clientLevel, entity, seed) -> {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BucketVariant")) {
                    return stack.m_41783_().m_128451_("BucketVariant");
                }
                return 0.0f;
            });
        });
    }

    @SubscribeEvent
    public void onAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)CACEntities.OTTER.get(), OtterEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.JUMPING_SPIDER.get(), JumpingSpiderEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.KOI_FISH.get(), KoiFishEntity.m_27495_().m_22265_());
        event.put((EntityType)CACEntities.DRAGONFLY.get(), DragonflyEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.SEA_BUNNY.get(), SeaBunnyEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.SHIMA_ENAGA.get(), ShimaEnagaEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.FERRET.get(), FerretEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.DUMBO_OCTOPUS.get(), DumboOctopusEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.LEAF_INSECT.get(), LeafInsectEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.RED_PANDA.get(), RedPandaEntity.createAttributes().m_22265_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CACEntities.OTTER.get(), OtterRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.JUMPING_SPIDER.get(), context -> new GeoEntityRenderer(context, (GeoModel)new JumpingSpiderModel()));
        event.registerEntityRenderer((EntityType)CACEntities.KOI_FISH.get(), context -> new GeoEntityRenderer(context, (GeoModel)new KoiFishModel()));
        event.registerEntityRenderer((EntityType)CACEntities.DRAGONFLY.get(), context -> new GeoEntityRenderer(context, (GeoModel)new DragonflyModel()));
        event.registerEntityRenderer((EntityType)CACEntities.SEA_BUNNY.get(), context -> new GeoEntityRenderer(context, (GeoModel)new SeaBunnyModel()));
        event.registerEntityRenderer((EntityType)CACEntities.SHIMA_ENAGA.get(), context -> new GeoEntityRenderer(context, (GeoModel)new ShimaEnagaModel()));
        event.registerEntityRenderer((EntityType)CACEntities.FERRET.get(), context -> new GeoEntityRenderer(context, (GeoModel)new FerretModel()));
        event.registerEntityRenderer((EntityType)CACEntities.GRAPPLING_HOOK.get(), GrapplingHookRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.DUMBO_OCTOPUS.get(), context -> new GeoEntityRenderer(context, (GeoModel)new DumboOctopusModel()));
        event.registerEntityRenderer((EntityType)CACEntities.LEAF_INSECT.get(), context -> new GeoEntityRenderer(context, (GeoModel)new LeafInsectModel()));
        event.registerEntityRenderer((EntityType)CACEntities.RED_PANDA.get(), context -> new GeoEntityRenderer(context, (GeoModel)new RedPandaModel()));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BubbleLayer.LAYER_LOCATION, BubbleModel::createLayer);
        event.registerLayerDefinition(GrapplingHookRenderer.LAYER_LOCATION, GrapplingHookModel::createLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void addEntityLayers(EntityRenderersEvent.AddLayers event) {
        if (FMLEnvironment.dist.isClient()) {
            for (String skinName : event.getSkins()) {
                LivingEntityRenderer skinRenderer = event.getSkin(skinName);
                skinRenderer.m_115326_((RenderLayer)new BubbleLayer((RenderLayerParent<Player, PlayerModel<Player>>)skinRenderer, event.getEntityModels()));
            }
        }
    }

    @SubscribeEvent
    public void addItemsToTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CREATIVE_TAB.get()) {
            CACItems.ITEMS.getEntries().stream().map(Supplier::get).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
    }
}

