/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LeafInsectEntity
extends PathfinderMob
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(LeafInsectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected BlockPos activeJukebox;
    protected boolean dancing;

    public LeafInsectEntity(EntityType<? extends LeafInsectEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public static boolean checkLeafInsectSpawnRules(EntityType<LeafInsectEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        BlockState blockState = levelAccessor.m_8055_(blockPos.m_7495_());
        return blockPos.m_123342_() > levelAccessor.m_5736_() - 16 && (blockState.m_204336_(BlockTags.f_144274_) || blockState.m_204336_(BlockTags.f_13035_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public void m_8107_() {
        if (this.activeJukebox == null || !this.activeJukebox.m_203195_((Position)this.m_20182_(), 5.0) || !this.m_9236_().m_8055_(this.activeJukebox).m_60713_(Blocks.f_50131_)) {
            this.activeJukebox = null;
            this.dancing = false;
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos blockPos, boolean sounding) {
        this.activeJukebox = blockPos;
        this.dancing = sounding;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CACSounds.LEAF_INSECT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CACSounds.LEAF_INSECT_DEATH.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag p_146750_) {
        this.setVariant(this.f_19796_.m_216339_(0, 3));
        return spawnGroupData;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isDancing()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("leaf_insect_dance"));
        } else if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("leaf_insect_walk"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("leaf_insect_idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)Mth.m_14045_((int)variant, (int)0, (int)2));
    }

    public boolean isDancing() {
        return this.dancing;
    }

    static class WaterAvoidingRandomStrollGoal
    extends net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal {
        private final LeafInsectEntity leafInsect;

        public WaterAvoidingRandomStrollGoal(LeafInsectEntity leafInsect, double speedModifier) {
            super((PathfinderMob)leafInsect, speedModifier);
            this.leafInsect = leafInsect;
        }

        public boolean m_8036_() {
            return !this.leafInsect.isDancing() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.leafInsect.isDancing() && super.m_8045_();
        }
    }
}

