/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.handler;

import com.github.eterdelta.crittersandcompanions.capability.BubbleState;
import com.github.eterdelta.crittersandcompanions.capability.CACCapabilities;
import com.github.eterdelta.crittersandcompanions.capability.GrapplingState;
import com.github.eterdelta.crittersandcompanions.capability.SilkLeashState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crittersandcompanions")
public class CapabilityHandler {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            final LazyOptional bubbleState = LazyOptional.of(BubbleState::new);
            ICapabilityProvider bubbleStateProvider = new ICapabilityProvider(){

                public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
                    if (capability == CACCapabilities.BUBBLE_STATE) {
                        return bubbleState.cast();
                    }
                    return LazyOptional.empty();
                }
            };
            event.addCapability(new ResourceLocation("crittersandcompanions", "bubble_state"), bubbleStateProvider);
            final LazyOptional grapplingState = LazyOptional.of(GrapplingState::new);
            ICapabilityProvider grapplingStateProvider = new ICapabilityProvider(){

                public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
                    if (capability == CACCapabilities.GRAPPLING_STATE) {
                        return grapplingState.cast();
                    }
                    return LazyOptional.empty();
                }
            };
            event.addCapability(new ResourceLocation("crittersandcompanions", "grappling_state"), grapplingStateProvider);
        }
        if (event.getObject() instanceof LivingEntity) {
            final LazyOptional optionalSilkLeashState = LazyOptional.of(SilkLeashState::new);
            ICapabilityProvider silkLeashStateProvider = new ICapabilityProvider(){

                public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
                    if (capability == CACCapabilities.SILK_LEASH_STATE) {
                        return optionalSilkLeashState.cast();
                    }
                    return LazyOptional.empty();
                }
            };
            event.addCapability(new ResourceLocation("crittersandcompanions", "silk_leash_state"), silkLeashStateProvider);
        }
    }
}

