/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.network;

import com.github.eterdelta.crittersandcompanions.capability.CACCapabilities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundBubbleStatePacket {
    private final boolean state;
    private final int player;

    public ClientboundBubbleStatePacket(boolean state, int player) {
        this.state = state;
        this.player = player;
    }

    public ClientboundBubbleStatePacket(FriendlyByteBuf byteBuf) {
        this(byteBuf.readBoolean(), byteBuf.readInt());
    }

    public void write(FriendlyByteBuf byteBuf) {
        byteBuf.writeBoolean(this.state);
        byteBuf.writeInt(this.player);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Player player = (Player)Minecraft.m_91087_().f_91073_.m_6815_(this.player);
            if (player != null) {
                LazyOptional capability = player.getCapability(CACCapabilities.BUBBLE_STATE);
                capability.ifPresent(bubbleState -> bubbleState.setActive(this.state));
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

