/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.CapsuleMod;
import capsule.config.SimpleCommentedConfig;
import capsule.helpers.Files;
import capsule.helpers.Serialization;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    protected static final Logger LOGGER = LogManager.getLogger(Config.class);
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static final String CATEGORY_BALANCE = "balance";
    public static final String CATEGORY_LOOT = "loot";
    public static final String CATEGORY_ENCHANTS = "enchants";
    public static Map<String, LootPathData> lootTemplatesData;
    public static List<String> starterTemplatesList;
    public static List<String> prefabsTemplatesList;
    public static HashMap<String, JsonObject> blueprintWhitelist;
    public static List<Block> excludedBlocks;
    public static List<Block> opExcludedBlocks;
    public static String starterTemplatesPath;
    public static String prefabsTemplatesPath;
    public static String rewardTemplatesPath;
    public static List<? extends String> lootTablesList;
    public static int upgradeLimit;
    public static boolean allowBlueprintReward;
    public static String starterMode;
    public static boolean allowMirror;
    public static int previewDisplayDuration;
    public static ForgeConfigSpec.ConfigValue<String> enchantRarity;
    public static ForgeConfigSpec.ConfigValue<String> recallEnchantType;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> excludedBlocksIdsCfg;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> opExcludedBlocksIdsCfg;
    private static ForgeConfigSpec.ConfigValue<List<CommentedConfig>> lootTemplatesPathsCfg;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> lootTablesListCfg;
    private static ForgeConfigSpec.ConfigValue<String> starterTemplatesPathCfg;
    private static ForgeConfigSpec.ConfigValue<String> prefabsTemplatesPathCfg;
    private static ForgeConfigSpec.ConfigValue<String> rewardTemplatesPathCfg;
    private static ForgeConfigSpec.IntValue upgradeLimitCfg;
    private static ForgeConfigSpec.BooleanValue allowBlueprintRewardCfg;
    private static ForgeConfigSpec.BooleanValue allowMirrorCfg;
    private static ForgeConfigSpec.ConfigValue<String> starterModeCfg;
    private static ForgeConfigSpec.IntValue previewDisplayDurationCfg;

    public static Path getCapsuleConfigDir() {
        return FMLPaths.CONFIGDIR.get().resolve("capsule");
    }

    public static void bakeConfig(ModConfig config) {
        List templatesPaths = (List)lootTemplatesPathsCfg.get();
        for (CommentedConfig rawData : templatesPaths) {
            LootPathData data = new LootPathData((String)rawData.get("path"), (Integer)rawData.get("weight"));
            if (lootTemplatesData.containsKey(data.path)) continue;
            lootTemplatesData.put(data.path, data);
        }
        opExcludedBlocks = Serialization.deserializeBlockList((List)opExcludedBlocksIdsCfg.get());
        excludedBlocks = Serialization.deserializeBlockList((List)excludedBlocksIdsCfg.get());
        lootTablesList = (List)lootTablesListCfg.get();
        starterTemplatesPath = (String)starterTemplatesPathCfg.get();
        prefabsTemplatesPath = (String)prefabsTemplatesPathCfg.get();
        rewardTemplatesPath = (String)rewardTemplatesPathCfg.get();
        upgradeLimit = (Integer)upgradeLimitCfg.get();
        allowBlueprintReward = (Boolean)allowBlueprintRewardCfg.get();
        starterMode = (String)starterModeCfg.get();
        allowMirror = (Boolean)allowMirrorCfg.get();
        previewDisplayDuration = (Integer)previewDisplayDurationCfg.get();
        if (CapsuleMod.server != null) {
            Config.populateConfigFolders(CapsuleMod.server);
        }
    }

    public static void populateConfigFolders(MinecraftServer server) {
        ResourceManager ressourceManager = server.m_177941_();
        Files.populateAndLoadLootList(Config.getCapsuleConfigDir().toFile(), lootTemplatesData, ressourceManager);
        blueprintWhitelist = Files.populateWhitelistConfig(Config.getCapsuleConfigDir().toFile(), ressourceManager);
        starterTemplatesList = Files.populateStarters(Config.getCapsuleConfigDir().toFile(), starterTemplatesPath, ressourceManager);
        prefabsTemplatesList = Files.populatePrefabs(Config.getCapsuleConfigDir().toFile(), prefabsTemplatesPath, ressourceManager);
    }

    public static void configureCapture(ForgeConfigSpec.Builder configBuild) {
        previewDisplayDurationCfg = configBuild.comment("Duration in ticks for an undeployed capsule to remain activated (preview displayed) when right clicking. 20 ticks = 1 second.\nDefault value: 120.").defineInRange("previewDisplayDuration", 120, 0, Integer.MAX_VALUE);
        upgradeLimitCfg = configBuild.comment("Number of upgrades an empty capsule can get to improve capacity. If <= 0, the capsule won't be able to upgrade.").worldRestart().defineInRange("capsuleUpgradesLimit", 10, 0, Integer.MAX_VALUE);
        Block[] defaultExcludedBlocksOP = new Block[]{Blocks.f_50016_, Blocks.f_50454_, Blocks.f_50752_};
        Block[] defaultExcludedBlocks = new Block[]{Blocks.f_50085_, Blocks.f_50257_, Blocks.f_50258_};
        Object[] excludedBlocksOPArray = (String[])ArrayUtils.addAll((Object[])Serialization.serializeBlockArray(defaultExcludedBlocksOP), (Object[])new String[]{"ic2:", "refinedstorage:", "superfactorymanager:", "gregtech:machine", "gtadditions:", "bloodmagic:alchemy_table", "mekanism:machineblock", "mekanism:boundingblock", "tombstone:player_graves"});
        String[] excludedBlocksStandardArray = (String[])ArrayUtils.addAll((Object[])Serialization.serializeBlockArray(defaultExcludedBlocks), (Object[])excludedBlocksOPArray);
        excludedBlocksIdsCfg = configBuild.comment("List of block ids or tags that will never be captured by a non overpowered capsule. While capturing, the blocks will stay in place.\n Ex block: minecraft:spawner\n Ex tag: minecraft:beds").worldRestart().defineList("excludedBlocks", Arrays.asList(excludedBlocksStandardArray), item -> item instanceof String);
        opExcludedBlocksIdsCfg = configBuild.comment("List of block ids or tags that will never be captured even with an overpowered capsule. While capturing, the blocks will stay in place.\nMod prefix usually indicate an incompatibility, remove at your own risk. See https://github.com/Lythom/capsule/wiki/Known-incompatibilities. \n Ex: minecraft:spawner").worldRestart().defineList("opExcludedBlocks", Arrays.asList(excludedBlocksOPArray), item -> item instanceof String);
    }

    public static void configureLoot(ForgeConfigSpec.Builder configBuild) {
        List<String> defaultLootTablesList = Arrays.asList(BuiltInLootTables.f_78759_.toString(), BuiltInLootTables.f_78699_.toString(), BuiltInLootTables.f_78700_.toString(), BuiltInLootTables.f_78698_.toString(), BuiltInLootTables.f_78697_.toString(), BuiltInLootTables.f_78695_.toString(), BuiltInLootTables.f_78764_.toString(), BuiltInLootTables.f_78741_.toString(), BuiltInLootTables.f_78688_.toString(), BuiltInLootTables.f_78686_.toString(), BuiltInLootTables.f_78742_.toString(), BuiltInLootTables.f_78763_.toString(), BuiltInLootTables.f_78762_.toString(), BuiltInLootTables.f_78761_.toString(), BuiltInLootTables.f_78744_.toString(), BuiltInLootTables.f_78745_.toString(), BuiltInLootTables.f_78753_.toString(), BuiltInLootTables.f_78743_.toString(), BuiltInLootTables.f_78692_.toString(), BuiltInLootTables.f_78687_.toString(), BuiltInLootTables.f_78696_.toString(), BuiltInLootTables.f_78695_.toString(), BuiltInLootTables.f_78691_.toString(), BuiltInLootTables.f_78690_.toString(), BuiltInLootTables.f_78689_.toString());
        lootTablesListCfg = configBuild.comment("List of loot tables that will eventually reward a capsule.\n Example of valid loot tables : gameplay/fishing/treasure, chests/spawn_bonus_chest, entities/villager (killing a villager).\nAlso see https://minecraft.gamepedia.com/Loot_table#List_of_loot_tables.").worldRestart().defineList("lootTablesList", defaultLootTablesList, item -> item instanceof String);
        SimpleCommentedConfig common = new SimpleCommentedConfig(null);
        common.add("path", "config/capsule/loot/common");
        common.add("weight", 10);
        SimpleCommentedConfig uncommon = new SimpleCommentedConfig(null);
        uncommon.add("path", "config/capsule/loot/uncommon");
        uncommon.add("weight", 6);
        SimpleCommentedConfig rare = new SimpleCommentedConfig(null);
        rare.add("path", "config/capsule/loot/rare");
        rare.add("weight", 2);
        ArrayList<SimpleCommentedConfig> list = new ArrayList<SimpleCommentedConfig>();
        list.add(common);
        list.add(uncommon);
        list.add(rare);
        lootTemplatesPathsCfg = configBuild.comment("List of paths and weights where the mod will look for structureBlock files. Each .nbt or .schematic in those folders have a chance to appear as a reward capsule in a dungeon chest.\nHigher weight means more common. Default weights : 2 (rare), 6 (uncommon) or 10 (common)\nTo Lower the chance of getting a capsule at all, insert an empty folder here and configure its weight accordingly.").worldRestart().define("lootTemplatesPaths", list, o -> o instanceof ArrayList);
        starterModeCfg = configBuild.comment("Players can be given one or several starter structures on their first arrival.\nThose structures nbt files can be placed in the folder defined at starterTemplatesPath below.\nPossible values : \"all\", \"random\", or \"none\".\nDefault value: \"random\"").worldRestart().define("starterMode", (Object)"random");
        starterTemplatesPathCfg = configBuild.comment("Each structure in this folder will be given to the player as standard reusable capsule on game start.\nEmpty the folder or the value to disable starter capsules.\nDefault value: \"config/capsule/starters\"").worldRestart().define("starterTemplatesPath", (Object)"config/capsule/starters");
        prefabsTemplatesPathCfg = configBuild.comment("Each structure in this folder will auto-generate a blueprint recipe that player will be able to craft.\nRemove/Add structure in the folder to disable/enable the recipe.\nDefault value: \"config/capsule/prefabs\"").worldRestart().define("prefabsTemplatesPath", (Object)"config/capsule/prefabs");
        rewardTemplatesPathCfg = configBuild.comment("Paths where the mod will look for structureBlock files when invoking command /capsule fromExistingRewards <structureName> [playerName].").worldRestart().define("rewardTemplatesPath", (Object)"config/capsule/rewards");
        allowBlueprintRewardCfg = configBuild.comment("If true, loot rewards will be pre-charged blueprint when possible (if the content contains no entity).\nIf false loot reward will always be one-use capsules.\nDefault value: true").define("allowBlueprintReward", true);
        allowMirrorCfg = configBuild.comment("If true, sneak+left click in air allow mirroring of the capsule content. Can be disabled for multiblock compatibility. \nDefault value: true").define("allowMirror", true);
    }

    public static void configureEnchants(ForgeConfigSpec.Builder configBuild) {
        enchantRarity = configBuild.comment("Rarity of the enchantmant. Possible values : COMMON, UNCOMMON, RARE, VERY_RARE. Default: RARE.").worldRestart().define("recallEnchantRarity", (Object)"RARE");
        recallEnchantType = configBuild.comment("Possible targets for the enchantment. By default : null.\nPossible values are ALL, ARMOR, ARMOR_FEET, ARMOR_LEGS, ARMOR_TORSO, ARMOR_HEAD, WEAPON, DIGGER, FISHING_ROD, BREAKABLE, BOW, null.\nIf null or empty, Capsules will be the only items to be able to get this Enchantment.").worldRestart().define("recallEnchantType", (Object)"null");
    }

    public static String getRewardPathFromName(String structureName) {
        return rewardTemplatesPath + "/" + structureName;
    }

    public static JsonObject getBlueprintAllowedNBT(Block b) {
        return blueprintWhitelist.get(ForgeRegistries.BLOCKS.getKey((Object)b).toString());
    }

    public static List<String> getBlueprintIdentityNBT(Block b) {
        JsonObject allowedNBT = Config.getBlueprintAllowedNBT(b);
        if (allowedNBT == null) {
            return null;
        }
        return allowedNBT.entrySet().stream().filter(ks -> !((JsonElement)ks.getValue()).isJsonNull()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static {
        COMMON_BUILDER.comment(" Check out the wiki pages at https://github.com/Lythom/capsule/wiki for full documentation.\n\nLoot settings").push(CATEGORY_LOOT);
        Config.configureLoot(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("enchants settings").push(CATEGORY_ENCHANTS);
        Config.configureEnchants(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Balancing settings").push(CATEGORY_BALANCE);
        Config.configureCapture(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        lootTemplatesData = new HashMap<String, LootPathData>();
        starterTemplatesList = new ArrayList<String>();
        prefabsTemplatesList = new ArrayList<String>();
        blueprintWhitelist = new HashMap();
    }

    public static class LootPathData {
        public String path;
        public int weight;
        public List<String> files;

        public LootPathData(String path, int weight) {
            this.path = path;
            this.weight = weight;
        }
    }
}

