/*
 * Decompiled with CFR 0.152.
 */
package capsule.client.render.vbo;

import capsule.client.render.vbo.CustomBufferBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.joml.Matrix4f;

public class CustomVertexBuffer
implements AutoCloseable {
    private int glBufferId;
    private final VertexFormat vertexFormat;
    private int count;

    public CustomVertexBuffer(VertexFormat vertexFormatIn) {
        this.vertexFormat = vertexFormatIn;
        RenderSystem.glGenBuffers(p_227876_1_ -> {
            this.glBufferId = p_227876_1_;
        });
    }

    public void bindBuffer() {
        RenderSystem.glBindBuffer((int)34962, () -> this.glBufferId);
    }

    public void upload(CustomBufferBuilder bufferIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.uploadRaw(bufferIn));
        } else {
            this.uploadRaw(bufferIn);
        }
    }

    public CompletableFuture<Void> uploadLater(CustomBufferBuilder bufferIn) {
        if (!RenderSystem.isOnRenderThread()) {
            return CompletableFuture.runAsync(() -> this.uploadRaw(bufferIn), p_227877_0_ -> RenderSystem.recordRenderCall(p_227877_0_::run));
        }
        this.uploadRaw(bufferIn);
        return CompletableFuture.completedFuture(null);
    }

    private void uploadRaw(CustomBufferBuilder bufferIn) {
        Pair<CustomBufferBuilder.DrawState, ByteBuffer> pair = bufferIn.getNextBuffer();
        if (this.glBufferId != -1) {
            ByteBuffer bytebuffer = (ByteBuffer)pair.getSecond();
            this.count = bytebuffer.remaining() / this.vertexFormat.m_86020_();
            this.bindBuffer();
            RenderSystem.glBufferData((int)34962, (ByteBuffer)bytebuffer, (int)35044);
            CustomVertexBuffer.unbindBuffer();
        }
    }

    public void draw(Matrix4f matrixIn, int modeIn) {
    }

    public static void unbindBuffer() {
        RenderSystem.glBindBuffer((int)34962, () -> 0);
    }

    @Override
    public void close() {
        if (this.glBufferId >= 0) {
            RenderSystem.glDeleteBuffers((int)this.glBufferId);
            this.glBufferId = -1;
        }
    }
}

