/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleContentPreviewQueryToServer;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleLeftClickQueryToServer {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewQueryToServer.class);

    public CapsuleLeftClickQueryToServer() {
    }

    public CapsuleLeftClickQueryToServer(FriendlyByteBuf buf) {
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when " + this.getClass().getName() + " was received");
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack stack = sendingPlayer.m_21205_();
            if (stack.m_41720_() instanceof CapsuleItem && CapsuleItem.isBlueprint(stack) && CapsuleItem.hasState(stack, CapsuleItem.CapsuleState.DEPLOYED)) {
                Map<StructureSaver.ItemStackKey, Integer> missing = Capsule.reloadBlueprint(stack, sendingPlayer.m_284548_(), (Player)sendingPlayer);
                if (missing != null && missing.size() > 0) {
                    MutableComponent message = Component.m_237113_((String)"Missing :");
                    for (Map.Entry<StructureSaver.ItemStackKey, Integer> entry : missing.entrySet()) {
                        message.m_130946_("\n* " + entry.getValue() + " ");
                        message.m_7220_(entry.getKey().itemStack.m_41720_().m_7626_(entry.getKey().itemStack));
                    }
                    sendingPlayer.m_213846_((Component)message);
                }
            } else if (stack.m_41720_() instanceof CapsuleItem && CapsuleItem.canRotate(stack)) {
                StructurePlaceSettings placement = CapsuleItem.getPlacement(stack);
                if (sendingPlayer.m_6144_()) {
                    if (Config.allowMirror) {
                        switch (placement.m_74401_()) {
                            case FRONT_BACK: {
                                placement.m_74377_(Mirror.LEFT_RIGHT);
                                break;
                            }
                            case LEFT_RIGHT: {
                                placement.m_74377_(Mirror.NONE);
                                break;
                            }
                            case NONE: {
                                placement.m_74377_(Mirror.FRONT_BACK);
                            }
                        }
                        sendingPlayer.m_213846_((Component)Component.m_237115_((String)("[ ]: " + Capsule.getMirrorLabel(placement))));
                    } else {
                        sendingPlayer.m_213846_((Component)Component.m_237115_((String)"Mirroring disabled by config"));
                    }
                } else {
                    placement.m_74379_(placement.m_74404_().m_55952_(Rotation.CLOCKWISE_90));
                    sendingPlayer.m_213846_((Component)Component.m_237115_((String)("\u27f3: " + Capsule.getRotationLabel(placement))));
                }
                CapsuleItem.setPlacement(stack, placement);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public String toString() {
        return this.getClass().toString();
    }
}

