/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.client.CapsulePreviewHandler;
import capsule.helpers.Capsule;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleNetwork;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.StringUtil;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleUndeployNotifToClient {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleUndeployNotifToClient.class);
    public String templateName = null;
    public BlockPos posFrom = null;
    public BlockPos posTo = null;
    public int size = 0;

    public CapsuleUndeployNotifToClient(BlockPos posFrom, BlockPos posTo, int size, String templateName) {
        this.posFrom = posFrom;
        this.posTo = posTo;
        this.size = size;
        this.templateName = templateName;
    }

    public void onClient(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Capsule.showUndeployParticules(Minecraft.m_91087_().f_91073_, this.posFrom, this.posTo, this.size);
            if (!StringUtil.m_14408_((String)this.templateName)) {
                CapsulePreviewHandler.currentPreview.remove(this.templateName);
                CapsulePreviewHandler.currentFullPreview.remove(this.templateName);
                CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleContentPreviewQueryToServer(this.templateName));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public CapsuleUndeployNotifToClient(FriendlyByteBuf buf) {
        try {
            this.posFrom = buf.m_130135_();
            this.posTo = buf.m_130135_();
            this.size = buf.readShort();
            this.templateName = buf.m_130277_();
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleUndeployNotifToClient: " + ioe);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.posFrom);
        buf.m_130064_(this.posTo);
        buf.writeShort(this.size);
        buf.m_130070_(this.templateName == null ? "" : this.templateName);
    }

    public String toString() {
        return this.getClass().toString();
    }
}

