/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import capsule.Config;
import capsule.tags.CapsuleTags;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleTemplate {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleTemplate.class);
    public final List<Palette> palettes = Lists.newArrayList();
    public final List<StructureTemplate.StructureEntityInfo> entities = Lists.newArrayList();
    public Map<BlockPos, Block> occupiedPositions = null;
    public BlockPos size = BlockPos.f_121853_;
    private String author = "?";

    public BlockPos getSize() {
        return this.size;
    }

    public void setAuthor(String authorIn) {
        this.author = authorIn;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<StructureTemplate.StructureBlockInfo> getPalette() {
        if (this.palettes.size() <= 0 || this.palettes.get((int)0).blocks == null) {
            return Lists.newArrayList();
        }
        return this.palettes.get((int)0).blocks;
    }

    private static void addToLists(StructureTemplate.StructureBlockInfo p_237149_0_, List<StructureTemplate.StructureBlockInfo> p_237149_1_, List<StructureTemplate.StructureBlockInfo> p_237149_2_, List<StructureTemplate.StructureBlockInfo> p_237149_3_) {
        if (p_237149_0_.f_74677_() != null) {
            p_237149_2_.add(p_237149_0_);
        } else if (!p_237149_0_.f_74676_().m_60734_().m_49967_() && p_237149_0_.f_74676_().m_60838_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
            p_237149_1_.add(p_237149_0_);
        } else {
            p_237149_3_.add(p_237149_0_);
        }
    }

    private static List<StructureTemplate.StructureBlockInfo> buildInfoList(List<StructureTemplate.StructureBlockInfo> p_237151_0_, List<StructureTemplate.StructureBlockInfo> p_237151_1_, List<StructureTemplate.StructureBlockInfo> p_237151_2_) {
        Comparator<StructureTemplate.StructureBlockInfo> comparator = Comparator.comparingInt(p_237154_0_ -> p_237154_0_.f_74675_().m_123342_()).thenComparingInt(p_237153_0_ -> p_237153_0_.f_74675_().m_123341_()).thenComparingInt(p_237148_0_ -> p_237148_0_.f_74675_().m_123343_());
        p_237151_0_.sort(comparator);
        p_237151_2_.sort(comparator);
        p_237151_1_.sort(comparator);
        ArrayList list = Lists.newArrayList();
        list.addAll(p_237151_0_);
        list.addAll(p_237151_2_);
        list.addAll(p_237151_1_);
        return list;
    }

    public static BlockPos calculateRelativePosition(StructurePlaceSettings placementIn, BlockPos pos) {
        return CapsuleTemplate.getTransformedPos(pos, placementIn.m_74401_(), placementIn.m_74404_(), placementIn.m_74407_());
    }

    public static Vec3 transformedVec3d(StructurePlaceSettings placementIn, Vec3 pos) {
        return CapsuleTemplate.getTransformedPos(pos, placementIn.m_74401_(), placementIn.m_74404_(), placementIn.m_74407_());
    }

    public static List<StructureTemplate.StructureBlockInfo> processBlockInfos(@Nullable CapsuleTemplate template, LevelAccessor worldIn, BlockPos offsetPos, StructurePlaceSettings placementSettingsIn, List<StructureTemplate.StructureBlockInfo> blockInfos) {
        ArrayList list = Lists.newArrayList();
        for (StructureTemplate.StructureBlockInfo template$blockinfo : blockInfos) {
            BlockPos blockpos = CapsuleTemplate.calculateRelativePosition(placementSettingsIn, template$blockinfo.f_74675_()).m_121955_((Vec3i)offsetPos);
            StructureTemplate.StructureBlockInfo template$blockinfo1 = new StructureTemplate.StructureBlockInfo(blockpos, template$blockinfo.f_74676_(), template$blockinfo.f_74677_());
            list.add(template$blockinfo1);
        }
        return list;
    }

    public static List<StructureTemplate.StructureEntityInfo> processEntityInfos(@Nullable CapsuleTemplate template, LevelAccessor p_215387_0_, BlockPos offsetPos, StructurePlaceSettings placementSettingsIn, List<StructureTemplate.StructureEntityInfo> blockInfos) {
        ArrayList list = Lists.newArrayList();
        BlockPos recenterOffset = template == null ? BlockPos.f_121853_ : CapsuleTemplate.recenterRotation((template.size.m_123341_() - 1) / 2, placementSettingsIn);
        for (StructureTemplate.StructureEntityInfo entityInfo : blockInfos) {
            Vec3 pos = CapsuleTemplate.transformedVec3d(placementSettingsIn, entityInfo.f_74683_).m_82549_(Vec3.m_82528_((Vec3i)offsetPos)).m_82549_(Vec3.m_82528_((Vec3i)recenterOffset));
            BlockPos blockpos = CapsuleTemplate.calculateRelativePosition(placementSettingsIn, entityInfo.f_74684_).m_121955_((Vec3i)offsetPos);
            StructureTemplate.StructureEntityInfo info = new StructureTemplate.StructureEntityInfo(pos, blockpos, entityInfo.f_74685_);
            list.add(info);
        }
        return list;
    }

    private void addEntitiesToWorld(ServerLevelAccessor worldIn, BlockPos offsetPos, StructurePlaceSettings placementIn, Mirror mirrorIn, Rotation rotationIn, BlockPos centerOffset, @Nullable BoundingBox boundsIn, List<Entity> spawnedEntities) {
        for (StructureTemplate.StructureEntityInfo template$entityinfo : CapsuleTemplate.processEntityInfos(this, (LevelAccessor)worldIn, offsetPos, placementIn, this.entities)) {
            BlockPos blockpos = template$entityinfo.f_74684_;
            if (boundsIn != null && !boundsIn.m_71051_((Vec3i)blockpos)) continue;
            CompoundTag compoundnbt = template$entityinfo.f_74685_;
            Vec3 vector3d1 = template$entityinfo.f_74683_;
            ListTag listnbt = new ListTag();
            listnbt.add((Object)DoubleTag.m_128500_((double)vector3d1.f_82479_));
            listnbt.add((Object)DoubleTag.m_128500_((double)vector3d1.f_82480_));
            listnbt.add((Object)DoubleTag.m_128500_((double)vector3d1.f_82481_));
            compoundnbt.m_128365_("Pos", (Tag)listnbt);
            compoundnbt.m_128473_("UUID");
            CapsuleTemplate.createEntityIgnoreException(worldIn, compoundnbt).ifPresent(p_242927_6_ -> {
                float f = p_242927_6_.m_6961_(placementIn.m_74401_());
                p_242927_6_.m_7678_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, f += p_242927_6_.m_146908_() - p_242927_6_.m_7890_(placementIn.m_74404_()), p_242927_6_.m_146909_());
                if (placementIn.m_74414_() && p_242927_6_ instanceof Mob) {
                    ((Mob)p_242927_6_).m_6518_(worldIn, worldIn.m_6436_(BlockPos.m_274446_((Position)vector3d1)), MobSpawnType.STRUCTURE, (SpawnGroupData)null, compoundnbt);
                }
                worldIn.m_47205_(p_242927_6_);
                if (spawnedEntities != null) {
                    spawnedEntities.add((Entity)p_242927_6_);
                }
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ServerLevelAccessor worldIn, CompoundTag nbt) {
        try {
            return EntityType.m_20642_((CompoundTag)nbt, (Level)worldIn.m_6018_());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static BlockPos getTransformedPos(BlockPos targetPos, Mirror mirrorIn, Rotation rotationIn, BlockPos offset) {
        int i = targetPos.m_123341_();
        int j = targetPos.m_123342_();
        int k = targetPos.m_123343_();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = offset.m_123341_();
        int i1 = offset.m_123343_();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(l - i1 + k, j, l + i1 - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(l + i1 - k, j, i1 - l + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(l + l - i, j, i1 + i1 - k);
            }
        }
        return flag ? new BlockPos(i, j, k) : targetPos;
    }

    public static Vec3 getTransformedPos(Vec3 target, Mirror mirrorIn, Rotation rotationIn, BlockPos centerOffset) {
        double d0 = target.f_82479_;
        double d1 = target.f_82480_;
        double d2 = target.f_82481_;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i = centerOffset.m_123341_();
        int j = centerOffset.m_123343_();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3((double)(i - j) + d2, d1, (double)(i + j + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3((double)(i + j + 1) - d2, d1, (double)(j - i) + d0);
            }
            case CLOCKWISE_180: {
                return new Vec3((double)(i + i + 1) - d0, d1, (double)(j + j + 1) - d2);
            }
        }
        return flag ? new Vec3(d0, d1, d2) : target;
    }

    public CompoundTag save(CompoundTag nbt) {
        if (this.palettes.isEmpty()) {
            nbt.m_128365_("blocks", (Tag)new ListTag());
            nbt.m_128365_("palette", (Tag)new ListTag());
        } else {
            ArrayList list = Lists.newArrayList();
            BasicPalette template$basicpalette = new BasicPalette();
            list.add(template$basicpalette);
            for (int i = 1; i < this.palettes.size(); ++i) {
                list.add(new BasicPalette());
            }
            ListTag listnbt1 = new ListTag();
            List<StructureTemplate.StructureBlockInfo> list1 = this.palettes.get((int)0).blocks;
            for (int j = 0; j < list1.size(); ++j) {
                StructureTemplate.StructureBlockInfo template$blockinfo = list1.get(j);
                CompoundTag compoundnbt = new CompoundTag();
                compoundnbt.m_128365_("pos", (Tag)this.newIntegerList(template$blockinfo.f_74675_().m_123341_(), template$blockinfo.f_74675_().m_123342_(), template$blockinfo.f_74675_().m_123343_()));
                int k = template$basicpalette.idFor(template$blockinfo.f_74676_());
                compoundnbt.m_128405_("state", k);
                if (template$blockinfo.f_74677_() != null) {
                    compoundnbt.m_128365_("nbt", (Tag)template$blockinfo.f_74677_());
                }
                listnbt1.add((Object)compoundnbt);
                for (int l = 1; l < this.palettes.size(); ++l) {
                    BasicPalette template$basicpalette1 = (BasicPalette)list.get(l);
                    template$basicpalette1.addMapping(this.palettes.get(l).blocks().get(j).f_74676_(), k);
                }
            }
            nbt.m_128365_("blocks", (Tag)listnbt1);
            if (list.size() == 1) {
                ListTag listnbt2 = new ListTag();
                Iterator<Object> iterator = template$basicpalette.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate = (BlockState)iterator.next();
                    listnbt2.add((Object)NbtUtils.m_129202_((BlockState)blockstate));
                }
                nbt.m_128365_("palette", (Tag)listnbt2);
            } else {
                ListTag listnbt3 = new ListTag();
                for (BasicPalette template$basicpalette2 : list) {
                    ListTag listnbt4 = new ListTag();
                    for (BlockState blockstate1 : template$basicpalette2) {
                        listnbt4.add((Object)NbtUtils.m_129202_((BlockState)blockstate1));
                    }
                    listnbt3.add((Object)listnbt4);
                }
                nbt.m_128365_("palettes", (Tag)listnbt3);
            }
        }
        ListTag listnbt = new ListTag();
        for (StructureTemplate.StructureEntityInfo template$entityinfo : this.entities) {
            CompoundTag compoundnbt1 = new CompoundTag();
            compoundnbt1.m_128365_("pos", (Tag)this.newDoubleList(template$entityinfo.f_74683_.f_82479_, template$entityinfo.f_74683_.f_82480_, template$entityinfo.f_74683_.f_82481_));
            compoundnbt1.m_128365_("blockPos", (Tag)this.newIntegerList(template$entityinfo.f_74684_.m_123341_(), template$entityinfo.f_74684_.m_123342_(), template$entityinfo.f_74684_.m_123343_()));
            if (template$entityinfo.f_74685_ != null) {
                compoundnbt1.m_128365_("nbt", (Tag)template$entityinfo.f_74685_);
            }
            listnbt.add((Object)compoundnbt1);
        }
        nbt.m_128365_("entities", (Tag)listnbt);
        nbt.m_128365_("size", (Tag)this.newIntegerList(this.size.m_123341_(), this.size.m_123342_(), this.size.m_123343_()));
        nbt.m_128405_("DataVersion", SharedConstants.m_183709_().m_183476_().m_193006_());
        ListTag occupiedSpawnPositionstaglist = new ListTag();
        if (this.occupiedPositions != null) {
            for (Map.Entry<BlockPos, Block> entry : this.occupiedPositions.entrySet()) {
                CompoundTag nbtEntry = new CompoundTag();
                nbtEntry.m_128356_("pos", entry.getKey().m_121878_());
                nbtEntry.m_128405_("blockId", Block.m_49956_((BlockState)entry.getValue().m_49966_()));
                occupiedSpawnPositionstaglist.add((Object)nbtEntry);
            }
            nbt.m_128365_("capsule_occupiedSources", (Tag)occupiedSpawnPositionstaglist);
        }
        nbt.m_128359_("author", this.getAuthor());
        return nbt;
    }

    public void load(CompoundTag compound, String location) {
        this.palettes.clear();
        this.entities.clear();
        ListTag listnbt = compound.m_128437_("size", 3);
        this.size = new BlockPos(listnbt.m_128763_(0), listnbt.m_128763_(1), listnbt.m_128763_(2));
        ListTag listnbt1 = compound.m_128437_("blocks", 10);
        if (compound.m_128425_("palettes", 9)) {
            ListTag listnbt2 = compound.m_128437_("palettes", 9);
            for (int i = 0; i < listnbt2.size(); ++i) {
                this.loadPalette(listnbt2.m_128744_(i), listnbt1);
            }
        } else {
            this.loadPalette(compound.m_128437_("palette", 10), listnbt1);
        }
        ListTag listnbt5 = compound.m_128437_("entities", 10);
        for (int j = 0; j < listnbt5.size(); ++j) {
            CompoundTag compoundnbt = listnbt5.m_128728_(j);
            ListTag listnbt3 = compoundnbt.m_128437_("pos", 6);
            Vec3 vector3d = new Vec3(listnbt3.m_128772_(0), listnbt3.m_128772_(1), listnbt3.m_128772_(2));
            ListTag listnbt4 = compoundnbt.m_128437_("blockPos", 3);
            BlockPos blockpos = new BlockPos(listnbt4.m_128763_(0), listnbt4.m_128763_(1), listnbt4.m_128763_(2));
            if (!compoundnbt.m_128441_("nbt")) continue;
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("nbt");
            this.entities.add(new StructureTemplate.StructureEntityInfo(vector3d, blockpos, compoundnbt1));
        }
        if (compound.m_128441_("capsule_occupiedSources")) {
            HashMap<BlockPos, Block> occupiedSources = new HashMap<BlockPos, Block>();
            ListTag list = compound.m_128437_("capsule_occupiedSources", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                occupiedSources.put(BlockPos.m_122022_((long)entry.m_128454_("pos")), Block.m_49803_((int)entry.m_128451_("blockId")).m_60734_());
            }
            this.occupiedPositions = occupiedSources;
        }
        if (this.palettes.size() == 0) {
            LOGGER.error("Template located at " + location + " might be missing or corrupted: it should have a palette tag.");
        }
    }

    private void loadPalette(ListTag palettesNBT, ListTag blocksNBT) {
        BasicPalette template$basicpalette = new BasicPalette();
        for (int i = 0; i < palettesNBT.size(); ++i) {
            template$basicpalette.addMapping(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)palettesNBT.m_128728_(i)), i);
        }
        ArrayList list2 = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (int j = 0; j < blocksNBT.size(); ++j) {
            CompoundTag compoundnbt = blocksNBT.m_128728_(j);
            ListTag listnbt = compoundnbt.m_128437_("pos", 3);
            BlockPos blockpos = new BlockPos(listnbt.m_128763_(0), listnbt.m_128763_(1), listnbt.m_128763_(2));
            BlockState blockstate = template$basicpalette.stateFor(compoundnbt.m_128451_("state"));
            CompoundTag compoundnbt1 = compoundnbt.m_128441_("nbt") ? compoundnbt.m_128469_("nbt") : null;
            StructureTemplate.StructureBlockInfo template$blockinfo = new StructureTemplate.StructureBlockInfo(blockpos, blockstate, compoundnbt1);
            CapsuleTemplate.addToLists(template$blockinfo, list2, list, list1);
        }
        List<StructureTemplate.StructureBlockInfo> list3 = CapsuleTemplate.buildInfoList(list2, list, list1);
        this.palettes.add(new Palette(list3));
    }

    private ListTag newIntegerList(int ... values) {
        ListTag listnbt = new ListTag();
        for (int i : values) {
            listnbt.add((Object)IntTag.m_128679_((int)i));
        }
        return listnbt;
    }

    private ListTag newDoubleList(double ... values) {
        ListTag listnbt = new ListTag();
        for (double d0 : values) {
            listnbt.add((Object)DoubleTag.m_128500_((double)d0));
        }
        return listnbt;
    }

    public void filterFromWhitelist(List<String> outExcluded) {
        List newBlockList = this.getPalette().stream().filter(b -> {
            boolean included;
            ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)b.f_74676_().m_60734_());
            boolean bl = included = b.f_74677_() == null || registryName != null && Config.blueprintWhitelist.containsKey(registryName.toString());
            if (!included && outExcluded != null) {
                outExcluded.add(b.f_74676_().toString());
            }
            return included;
        }).map(b -> {
            if (b.f_74677_() == null) {
                return b;
            }
            CompoundTag nbt = null;
            JsonObject allowedNBT = Config.getBlueprintAllowedNBT(b.f_74676_().m_60734_());
            if (allowedNBT != null) {
                nbt = b.f_74677_().m_6426_();
                nbt.m_128431_().removeIf(key -> !allowedNBT.has(key));
            } else {
                nbt = new CompoundTag();
            }
            return new StructureTemplate.StructureBlockInfo(b.f_74675_(), b.f_74676_(), nbt);
        }).collect(Collectors.toList());
        this.getPalette().clear();
        this.getPalette().addAll(newBlockList);
        this.entities.clear();
    }

    public void removeOccupiedPositions() {
        this.occupiedPositions = null;
    }

    public void saveOccupiedPositions(Map<BlockPos, Block> occupiedPositions) {
        this.occupiedPositions = occupiedPositions;
    }

    public List<BlockPos> snapshotBlocksFromWorld(Level worldIn, BlockPos startPos, BlockPos endPos, Map<BlockPos, Block> occupiedPositionsToIgnore, List<Block> excluded, List<Entity> outCapturedEntities) {
        ArrayList<BlockPos> transferedBlocks = new ArrayList<BlockPos>();
        if (endPos.m_123341_() >= 1 && endPos.m_123342_() >= 1 && endPos.m_123343_() >= 1) {
            BlockPos blockpos = startPos.m_121955_((Vec3i)endPos).m_7918_(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.m_123341_(), blockpos.m_123341_()), Math.min(startPos.m_123342_(), blockpos.m_123342_()), Math.min(startPos.m_123343_(), blockpos.m_123343_()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.m_123341_(), blockpos.m_123341_()), Math.max(startPos.m_123342_(), blockpos.m_123342_()), Math.max(startPos.m_123343_(), blockpos.m_123343_()));
            this.size = endPos;
            for (BlockPos blockpos3 : BlockPos.m_121940_((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                StructureTemplate.StructureBlockInfo template$blockinfo;
                BlockPos blockpos4 = blockpos3.m_121996_((Vec3i)blockpos1);
                BlockState blockstate = worldIn.m_8055_(blockpos3);
                if (excluded.contains(blockstate.m_60734_()) || blockstate.m_204336_(CapsuleTags.excludedBlocks) || occupiedPositionsToIgnore != null && occupiedPositionsToIgnore.containsKey(blockpos3) && occupiedPositionsToIgnore.get(blockpos3).equals(blockstate.m_60734_())) continue;
                BlockEntity blockentity = worldIn.m_7702_(blockpos3);
                if (blockentity != null) {
                    CompoundTag compoundnbt = blockentity.m_187481_();
                    compoundnbt.m_128473_("x");
                    compoundnbt.m_128473_("y");
                    compoundnbt.m_128473_("z");
                    template$blockinfo = new StructureTemplate.StructureBlockInfo(blockpos4, blockstate, compoundnbt);
                } else {
                    template$blockinfo = new StructureTemplate.StructureBlockInfo(blockpos4, blockstate, (CompoundTag)null);
                }
                CapsuleTemplate.addToLists(template$blockinfo, list, list1, list2);
                transferedBlocks.add(new BlockPos(blockpos3.m_123341_(), blockpos3.m_123342_(), blockpos3.m_123343_()));
            }
            List<StructureTemplate.StructureBlockInfo> list3 = CapsuleTemplate.buildInfoList(list, list1, list2);
            this.palettes.clear();
            this.palettes.add(new Palette(list3));
            List<Entity> capturedEntities = this.snapshotNonLivingEntitiesFromWorld(worldIn, blockpos1, blockpos2.m_7918_(1, 1, 1));
            if (outCapturedEntities != null && capturedEntities != null) {
                outCapturedEntities.addAll(capturedEntities);
            }
        }
        return transferedBlocks;
    }

    public List<Entity> snapshotNonLivingEntitiesFromWorld(Level worldIn, BlockPos startPos, BlockPos endPos) {
        List list = worldIn.m_6443_(Entity.class, new AABB(startPos, endPos), entity -> !(entity instanceof ItemEntity) && (!(entity instanceof LivingEntity) || entity instanceof ArmorStand));
        this.entities.clear();
        for (Entity entity2 : list) {
            Vec3 vec3d = new Vec3(entity2.m_20185_() - (double)startPos.m_123341_(), entity2.m_20186_() - (double)startPos.m_123342_(), entity2.m_20189_() - (double)startPos.m_123343_());
            CompoundTag compoundnbt = new CompoundTag();
            entity2.m_20223_(compoundnbt);
            BlockPos blockpos = entity2 instanceof Painting ? ((Painting)entity2).m_31748_().m_121996_((Vec3i)startPos) : BlockPos.m_274446_((Position)vec3d);
            this.entities.add(new StructureTemplate.StructureEntityInfo(vec3d, blockpos, compoundnbt.m_6426_()));
        }
        return list;
    }

    public static AABB transformedAxisAlignedBB(StructurePlaceSettings placementIn, AABB bb) {
        return new AABB(CapsuleTemplate.calculateRelativePosition(placementIn, BlockPos.m_274561_((double)bb.f_82288_, (double)bb.f_82289_, (double)bb.f_82290_)), CapsuleTemplate.calculateRelativePosition(placementIn, BlockPos.m_274561_((double)bb.f_82291_, (double)bb.f_82292_, (double)bb.f_82293_)));
    }

    public boolean spawnBlocksAndEntities(ServerLevelAccessor worldIn, BlockPos pos, StructurePlaceSettings placementIn, Map<BlockPos, Block> occupiedPositions, List<BlockPos> outSpawnedBlocks, List<Entity> outSpawnedEntities) {
        int flags = 2;
        if (this.palettes.isEmpty()) {
            return false;
        }
        List<StructureTemplate.StructureBlockInfo> list = null;
        try {
            list = Palette.getRandomPalette(placementIn, this.palettes, pos).blocks();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            list = new ArrayList<StructureTemplate.StructureBlockInfo>();
        }
        if (!(list.isEmpty() && (placementIn.m_74408_() || this.entities.isEmpty()) || this.size.m_123341_() < 1 || this.size.m_123342_() < 1 || this.size.m_123343_() < 1)) {
            BoundingBox mutableboundingbox = placementIn.m_74409_();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementIn.m_74413_() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (StructureTemplate.StructureBlockInfo template$blockinfo : CapsuleTemplate.processBlockInfos(this, (LevelAccessor)worldIn, pos, placementIn, list)) {
                BlockPos blockpos = template$blockinfo.f_74675_().m_121955_((Vec3i)CapsuleTemplate.recenterRotation((this.size.m_123341_() - 1) / 2, placementIn));
                if (mutableboundingbox != null && !mutableboundingbox.m_71051_((Vec3i)blockpos) || occupiedPositions.containsKey(blockpos) && !occupiedPositions.get(blockpos).m_49966_().m_204336_(CapsuleTags.overridable)) continue;
                if (outSpawnedBlocks != null) {
                    outSpawnedBlocks.add(blockpos);
                }
                FluidState ifluidstate = placementIn.m_74413_() ? worldIn.m_6425_(blockpos) : null;
                BlockState blockstate = template$blockinfo.f_74676_().m_60715_(placementIn.m_74401_()).rotate((LevelAccessor)worldIn, blockpos, placementIn.m_74404_());
                BlockEntity blockentity = worldIn.m_7702_(blockpos);
                Clearable.m_18908_((Object)blockentity);
                worldIn.m_7731_(blockpos, Blocks.f_50375_.m_49966_(), 20);
                if (!worldIn.m_7731_(blockpos, blockstate, flags)) continue;
                i = Math.min(i, blockpos.m_123341_());
                j = Math.min(j, blockpos.m_123342_());
                k = Math.min(k, blockpos.m_123343_());
                l = Math.max(l, blockpos.m_123341_());
                i1 = Math.max(i1, blockpos.m_123342_());
                j1 = Math.max(j1, blockpos.m_123343_());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.f_74677_()));
                BlockEntity blockentity1 = worldIn.m_7702_(blockpos);
                if (blockentity1 != null) {
                    CompoundTag templateTag = template$blockinfo.f_74677_() == null ? new CompoundTag() : template$blockinfo.f_74677_();
                    templateTag.m_128405_("x", blockpos.m_123341_());
                    templateTag.m_128405_("y", blockpos.m_123342_());
                    templateTag.m_128405_("z", blockpos.m_123343_());
                    blockentity1.m_142466_(templateTag);
                    blockentity1.m_58900_().m_60715_(placementIn.m_74401_());
                    blockentity1.m_58900_().rotate((LevelAccessor)worldIn, placementIn.m_74407_(), placementIn.m_74404_());
                }
                if (ifluidstate == null || !(blockstate.m_60734_() instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)blockstate.m_60734_()).m_7361_((LevelAccessor)worldIn, blockpos, blockstate, ifluidstate);
                if (ifluidstate.m_76170_()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    FluidState ifluidstate2 = worldIn.m_6425_(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !ifluidstate2.m_76170_(); ++k1) {
                        BlockPos blockpos1 = blockpos3.m_121945_(adirection[k1]);
                        FluidState ifluidstate1 = worldIn.m_6425_(blockpos1);
                        if (!(ifluidstate1.m_76155_((BlockGetter)worldIn, blockpos1) > ifluidstate2.m_76155_((BlockGetter)worldIn, blockpos3)) && (!ifluidstate1.m_76170_() || ifluidstate2.m_76170_())) continue;
                        ifluidstate2 = ifluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!ifluidstate2.m_76170_() || !((block = (blockstate2 = worldIn.m_8055_(blockpos2)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)block).m_7361_((LevelAccessor)worldIn, blockpos2, blockstate2, ifluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!placementIn.m_74410_()) {
                    BitSetDiscreteVoxelShape voxelshapepart = new BitSetDiscreteVoxelShape(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int l1 = i;
                    int i2 = j;
                    int j2 = k;
                    for (Pair pair1 : list2) {
                        BlockPos blockpos5 = (BlockPos)pair1.getFirst();
                        voxelshapepart.m_142703_(blockpos5.m_123341_() - l1, blockpos5.m_123342_() - i2, blockpos5.m_123343_() - j2);
                    }
                    StructureTemplate.m_74510_((LevelAccessor)worldIn, (int)flags, (DiscreteVoxelShape)voxelshapepart, (int)l1, (int)i2, (int)j2);
                }
                for (Pair pair : list2) {
                    BlockState blockstate3;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (placementIn.m_74410_()) continue;
                    BlockState blockstate1 = worldIn.m_8055_(blockpos4);
                    if (blockstate1 != (blockstate3 = Block.m_49931_((BlockState)blockstate1, (LevelAccessor)worldIn, (BlockPos)blockpos4))) {
                        worldIn.m_7731_(blockpos4, blockstate3, flags & 0xFFFFFFFE | 0x10);
                    }
                    worldIn.m_6289_(blockpos4, blockstate3.m_60734_());
                }
            }
            if (!placementIn.m_74408_()) {
                this.addEntitiesToWorld(worldIn, pos, placementIn, placementIn.m_74401_(), placementIn.m_74404_(), placementIn.m_74407_(), placementIn.m_74409_(), outSpawnedEntities);
            }
            return true;
        }
        return false;
    }

    public void removeBlocks(List<BlockPos> couldNotBeRemoved, BlockPos startPos) {
        for (BlockPos blockPos : couldNotBeRemoved) {
            for (Palette palette : this.palettes) {
                palette.blocks.removeIf(blockInfo -> blockPos.m_121996_((Vec3i)startPos).equals((Object)blockInfo.f_74675_()));
            }
        }
    }

    public List<BlockPos> calculateDeployPositions(Level level, BlockPos deployPos, StructurePlaceSettings placementSettings) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        if (this.size == null) {
            return out;
        }
        List<StructureTemplate.StructureBlockInfo> list = null;
        try {
            list = Palette.getRandomPalette(placementSettings, this.palettes, deployPos).blocks();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            list = new ArrayList<StructureTemplate.StructureBlockInfo>();
        }
        if (!list.isEmpty() && this.size.m_123341_() >= 1 && this.size.m_123342_() >= 1 && this.size.m_123343_() >= 1) {
            BoundingBox structureboundingbox = placementSettings.m_74409_();
            for (StructureTemplate.StructureBlockInfo template$blockinfo : CapsuleTemplate.processBlockInfos(this, (LevelAccessor)level, deployPos, placementSettings, list)) {
                BlockPos blockpos = template$blockinfo.f_74675_().m_121955_((Vec3i)CapsuleTemplate.recenterRotation((this.size.m_123341_() - 1) / 2, placementSettings));
                if (template$blockinfo.f_74676_().m_60734_() == Blocks.f_50677_ || structureboundingbox != null && !structureboundingbox.m_71051_((Vec3i)blockpos)) continue;
                out.add(blockpos);
            }
        }
        return out;
    }

    public static BlockPos recenterRotation(int extendSize, StructurePlaceSettings placement) {
        return CapsuleTemplate.calculateRelativePosition(placement, new BlockPos(-extendSize, 0, -extendSize)).m_121955_((Vec3i)new BlockPos(extendSize, 0, extendSize));
    }

    public boolean canRotate() {
        if (this.palettes.isEmpty()) {
            return false;
        }
        try {
            for (StructureTemplate.StructureBlockInfo block : this.getPalette()) {
                if (block.f_74677_() == null || Config.blueprintWhitelist.containsKey(ForgeRegistries.BLOCKS.getKey((Object)block.f_74676_().m_60734_()).toString())) continue;
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public void readSchematic(CompoundTag nbt) throws Exception {
        int version = 1;
        if (nbt.m_128425_("Version", 3)) {
            version = nbt.m_128451_("Version");
        }
        if (version > 3) {
            throw new Exception("Schematic version >3 not supported");
        }
        if (!(version != 1 || nbt.m_128425_("Blocks", 7) && nbt.m_128425_("Data", 7))) {
            throw new Exception("Schematic: Missing data in the schematic");
        }
        if (!nbt.m_128425_("DataVersion", 99)) {
            nbt.m_128405_("DataVersion", 500);
        }
        this.palettes.clear();
        this.palettes.add(new Palette(new ArrayList<StructureTemplate.StructureBlockInfo>()));
        this.entities.clear();
        int width = nbt.m_128448_("Width");
        int height = nbt.m_128448_("Height");
        int length = nbt.m_128448_("Length");
        int paletteSize = switch (version) {
            case 2 -> nbt.m_128451_("PaletteMax");
            case 3 -> nbt.m_128469_("Blocks").m_128469_("PaletteMax").m_128440_();
            default -> 4095;
        };
        this.author = "?";
        try {
            this.author = nbt.m_128469_("Metadata").m_128461_("Author");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BlockState[] palette = this.readSchematicPalette(nbt, version, paletteSize);
        if (palette == null || palette.length == 0) {
            throw new Exception("Schematic: Failed to read the block palette, see logs");
        }
        BlockState[] blocksById = this.getSchematicBlocks(nbt, version, palette, width, height, length);
        if (blocksById == null) {
            throw new Exception("Schematic: Failed to read the block stats, see logs");
        }
        Map<BlockPos, CompoundTag> tiles = this.getSchematicBlockEntities(nbt, version);
        this.entities.clear();
        ListTag tagList = nbt.m_128437_("Entities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag entityNBT = tagList.m_128728_(i).m_6426_();
            ListTag posList = entityNBT.m_128437_("Pos", 6);
            Vec3 vec3d = new Vec3(posList.m_128772_(0), posList.m_128772_(1), posList.m_128772_(2));
            entityNBT.m_128473_("Pos");
            this.entities.add(new StructureTemplate.StructureEntityInfo(vec3d, BlockPos.m_274446_((Position)vec3d), entityNBT));
        }
        int index = 0;
        int sizeX = 1;
        int sizeY = 1;
        int sizeZ = 1;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                int x = 0;
                while (x < width) {
                    BlockState state = blocksById[index];
                    if (state.m_60734_() != Blocks.f_50016_) {
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundTag teNBT = tiles.get(pos);
                        this.getPalette().add(new StructureTemplate.StructureBlockInfo(pos, state, teNBT));
                        if (pos.m_123341_() > sizeX) {
                            sizeX = pos.m_123341_();
                        }
                        if (pos.m_123342_() > sizeY) {
                            sizeY = pos.m_123342_();
                        }
                        if (pos.m_123343_() > sizeZ) {
                            sizeZ = pos.m_123343_();
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
        int size = Math.max(sizeX, Math.max(sizeY, sizeZ));
        if (size % 2 == 0) {
            ++size;
        }
        this.size = new BlockPos(size, size, size);
    }

    private Map<BlockPos, CompoundTag> getSchematicBlockEntities(CompoundTag nbt, int version) {
        HashMap<BlockPos, CompoundTag> blockEntities;
        block3: {
            block2: {
                blockEntities = new HashMap<BlockPos, CompoundTag>();
                if (version != 1) break block2;
                ListTag tagList = nbt.m_128437_("TileEntities", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag tag = tagList.m_128728_(i);
                    BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
                    blockEntities.put(pos, tag);
                }
                break block3;
            }
            if (version != 2 && version != 3) break block3;
            ListTag tagList = version == 2 ? nbt.m_128437_("BlockEntities", 10) : nbt.m_128469_("Blocks").m_128437_("BlockEntities", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tag = tagList.m_128728_(i).m_6426_();
                int[] positions = tag.m_128465_("Pos");
                BlockPos pos = new BlockPos(positions[0], positions[1], positions[2]);
                tag.m_128473_("Pos");
                blockEntities.put(pos, tag);
            }
        }
        return blockEntities;
    }

    @Nullable
    private BlockState[] getSchematicBlocks(CompoundTag nbt, int version, BlockState[] palette, int width, int height, int length) throws Exception {
        BlockState[] blocksById;
        block14: {
            int numBlocks;
            byte[] blockIdsByte;
            block15: {
                BlockState block;
                int byteId;
                int addValue;
                int expectedAddLength;
                block13: {
                    blockIdsByte = switch (version) {
                        case 1 -> nbt.m_128463_("Blocks");
                        case 2 -> nbt.m_128463_("BlockData");
                        case 3 -> nbt.m_128469_("Blocks").m_128463_("Data");
                        default -> null;
                    };
                    numBlocks = blockIdsByte.length;
                    blocksById = new BlockState[numBlocks];
                    if (version != 2 && version != 3) break block13;
                    int index = 0;
                    int i = 0;
                    int value = 0;
                    int varint_length = 0;
                    while (i < numBlocks) {
                        BlockState state;
                        value = 0;
                        varint_length = 0;
                        while (true) {
                            value |= (blockIdsByte[i] & 0x7F) << varint_length++ * 7;
                            if (varint_length > 5) {
                                throw new RuntimeException("VarInt too big (probably corrupted data)");
                            }
                            if ((blockIdsByte[i] & 0x80) != 128) {
                                ++i;
                                break;
                            }
                            ++i;
                        }
                        int y = index / (width * length);
                        int z = index % (width * length) / width;
                        int x = index % (width * length) % width;
                        blocksById[index] = state = palette[value];
                        ++index;
                    }
                    break block14;
                }
                if (!nbt.m_128425_("AddBlocks", 7)) break block15;
                byte[] add = nbt.m_128463_("AddBlocks");
                if (add.length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
                    LOGGER.error("Schematic: Add array size mismatch, blocks: {}, add: {}, expected add: {}", (Object)numBlocks, (Object)add.length, (Object)expectedAddLength);
                    return null;
                }
                int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
                int bi = 0;
                int ai = 0;
                while (bi < loopMax) {
                    addValue = add[ai] & 0xFF;
                    byteId = blockIdsByte[bi] & 0xFF;
                    blocksById[bi] = block = palette[(addValue & 0xF0) << 4 | byteId];
                    byteId = blockIdsByte[bi + 1] & 0xFF;
                    blocksById[bi + 1] = block = palette[(addValue & 0xF) << 8 | byteId];
                    bi += 2;
                    ++ai;
                }
                if (numBlocks % 2 == 0) break block14;
                addValue = add[ai] & 0xFF;
                byteId = blockIdsByte[bi] & 0xFF;
                blocksById[bi] = block = palette[(addValue & 0xF0) << 4 | byteId];
                break block14;
            }
            if (nbt.m_128425_("Add", 7)) {
                LOGGER.error("Schematic: Old Schematica format detected, not implemented");
                return null;
            }
            for (int i = 0; i < numBlocks; ++i) {
                BlockState block;
                blocksById[i] = block = palette[blockIdsByte[i] & 0xFF];
            }
        }
        return blocksById;
    }

    @Nullable
    private BlockState[] readSchematicPalette(CompoundTag nbt, int version, int paletteSize) throws Exception {
        BlockState air = Blocks.f_50016_.m_49966_();
        Object[] palette = new BlockState[paletteSize];
        Arrays.fill(palette, air);
        if (nbt.m_128425_("BlockIDs", 10)) {
            CompoundTag tag = nbt.m_128469_("BlockIDs");
            Set keys = tag.m_128431_();
            for (String idStr : keys) {
                int id;
                String key = tag.m_128461_(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Schematic: Invalid ID '{}' (not a number) in MCEdit2 palette for block '{}'", (Object)idStr, (Object)key);
                    continue;
                }
                if (id >= palette.length) {
                    LOGGER.error("Schematic: Invalid ID '{}' in MCEdit2 palette for block '{}', max = 4095", (Object)id, (Object)key);
                    return null;
                }
                BlockState block = this.parseBlockState(key);
                if (block != null) {
                    palette[id] = block;
                    continue;
                }
                LOGGER.error("Schematic: Missing/non-existing block '{}' in MCEdit2 palette", (Object)key);
            }
        } else {
            CompoundTag tag = null;
            if (version == 2) {
                tag = nbt.m_128469_("Palette");
            } else if (version == 3) {
                tag = nbt.m_128469_("Blocks").m_128469_("Palette");
            } else if (nbt.m_128425_("SchematicaMapping", 10)) {
                tag = nbt.m_128469_("SchematicaMapping");
            }
            Set keys = tag.m_128431_();
            for (String key : keys) {
                short idx = tag.m_128448_(key);
                if (idx >= palette.length) {
                    LOGGER.error("Schematic: Invalid ID '{}' in MCEdit2 palette for block '{}', max = {}", (Object)idx, (Object)key, (Object)paletteSize);
                    return null;
                }
                palette[idx] = this.parseBlockState(key);
            }
        }
        return palette;
    }

    private BlockState parseBlockState(String key) {
        try {
            BlockState state = BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)key, (boolean)true).f_234748_();
            return state;
        }
        catch (CommandSyntaxException exception) {
            LOGGER.error("Could not parse {}. {}", (Object)key, (Object)exception);
            return Blocks.f_50016_.m_49966_();
        }
    }

    public static final class Palette {
        private final List<StructureTemplate.StructureBlockInfo> blocks;
        private final Map<Block, List<StructureTemplate.StructureBlockInfo>> cache = Maps.newHashMap();

        private Palette(List<StructureTemplate.StructureBlockInfo> p_i232120_1_) {
            this.blocks = p_i232120_1_;
            this.blocks.sort(Comparator.comparingInt(b -> b.f_74675_().m_123342_()));
        }

        public List<StructureTemplate.StructureBlockInfo> blocks() {
            return this.blocks;
        }

        public static Palette getRandomPalette(StructurePlaceSettings placementSettings, List<Palette> p_237132_1_, @Nullable BlockPos p_237132_2_) {
            int i = p_237132_1_.size();
            if (i == 0) {
                throw new IllegalStateException("No palettes");
            }
            return p_237132_1_.get(placementSettings.m_230326_(p_237132_2_).m_188503_(i));
        }
    }

    static class BasicPalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.f_50016_.m_49966_();
        private final IdMapper<BlockState> ids = new IdMapper(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(BlockState state) {
            int i = this.ids.m_7447_((Object)state);
            if (i == -1) {
                i = this.lastId++;
                this.ids.m_122664_((Object)state, i);
            }
            return i;
        }

        @Nullable
        public BlockState stateFor(int id) {
            BlockState blockstate = (BlockState)this.ids.m_7942_(id);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState p_189956_1_, int p_189956_2_) {
            this.ids.m_122664_((Object)p_189956_1_, p_189956_2_);
        }
    }
}

