/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootJSPlatform;
import com.almostreliable.lootjs.LootModificationsAPI;
import com.almostreliable.lootjs.core.LootContextType;
import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.filters.Resolver;
import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.kube.LootEntryWrapper;
import com.almostreliable.lootjs.kube.LootJSEvent;
import com.almostreliable.lootjs.kube.wrapper.IntervalJS;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.saveddata.maps.MapDecoration;

public class LootJSPlugin
extends KubeJSPlugin {
    public static boolean eventsAreDisabled() {
        return Boolean.getBoolean("lootjs.disable_events");
    }

    @Nullable
    public static <T extends Enum<T>> T valueOf(Class<T> clazz, Object o) {
        String s = o.toString();
        for (Enum constant : (Enum[])clazz.getEnumConstants()) {
            if (!s.equalsIgnoreCase(constant.name())) continue;
            return (T)constant;
        }
        return null;
    }

    private static ItemFilter ofItemFilter(@Nullable Object o) {
        if (o instanceof ItemFilter) {
            ItemFilter i = (ItemFilter)o;
            return i;
        }
        Ingredient ingredient = IngredientJS.of((Object)o);
        if (ingredient.m_43947_()) {
            ConsoleJS.SERVER.warn((Object)("LootJS: Invalid ingredient for filter: " + o));
            return ItemFilter.ALWAYS_FALSE;
        }
        return ItemFilter.custom((Predicate<ItemStack>)ingredient);
    }

    public void initStartup() {
        LootModificationsAPI.DEBUG_ACTION = s -> ConsoleJS.SERVER.info(s);
    }

    public void registerEvents() {
        LootJSEvent.GROUP.register();
    }

    public void registerBindings(BindingsEvent event) {
        event.add("LootType", LootContextType.class);
        event.add("Interval", (Object)new IntervalJS());
        event.add("ItemFilter", ItemFilter.class);
        event.add("LootEntry", LootEntryWrapper.class);
        LootJSPlatform.INSTANCE.registerBindings(event);
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.registerSimple(LootEntry.class, LootEntryWrapper::of);
        typeWrappers.registerSimple(MinMaxBounds.Doubles.class, IntervalJS::ofDoubles);
        typeWrappers.registerSimple(MinMaxBounds.Ints.class, IntervalJS::ofInt);
        typeWrappers.registerSimple(ItemFilter.class, o -> {
            if (o instanceof List) {
                List list = (List)o;
                Map<Boolean, List<Object>> split = list.stream().collect(Collectors.partitioningBy(unknown -> unknown instanceof ItemFilter));
                ArrayList<ItemFilter> itemFilters = new ArrayList<ItemFilter>(split.get(true).stream().map(LootJSPlugin::ofItemFilter).toList());
                if (!split.get(false).isEmpty()) {
                    Ingredient ingredientFilter = IngredientJS.of(split.get(false));
                    itemFilters.add(ItemFilter.custom((Predicate<ItemStack>)ingredientFilter));
                }
                return ItemFilter.or((ItemFilter[])itemFilters.toArray(ItemFilter[]::new));
            }
            return LootJSPlugin.ofItemFilter(o);
        });
        typeWrappers.registerSimple(ResourceLocationFilter.class, this::ofResourceLocationFilter);
        typeWrappers.registerSimple(MapDecoration.Type.class, o -> LootJSPlugin.valueOf(MapDecoration.Type.class, o));
        typeWrappers.registerSimple(AttributeModifier.Operation.class, o -> LootJSPlugin.valueOf(AttributeModifier.Operation.class, o));
        typeWrappers.registerSimple(Resolver.class, o -> Resolver.of(o.toString()));
    }

    private ResourceLocationFilter ofResourceLocationFilter(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            return new ResourceLocationFilter.Or(list.stream().map(this::ofResourceLocationFilter).toList());
        }
        Pattern pattern = UtilsJS.parseRegex((Object)o);
        if (pattern == null) {
            return new ResourceLocationFilter.ByLocation(new ResourceLocation(o.toString()));
        }
        return new ResourceLocationFilter.ByPattern(pattern);
    }
}

