/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei;

import com.cyanogen.experienceobelisk.gui.MolecularMetamorpherScreen;
import com.cyanogen.experienceobelisk.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.experienceobelisk.recipe.jei.MolecularMetamorpherCategory;
import com.cyanogen.experienceobelisk.recipe.jei.MolecularMetamorpherTransferHandler;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.cyanogen.experienceobelisk.utils.RecipeUtils;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CognitionJeiPlugin
implements IModPlugin {
    public static final RecipeType<MolecularMetamorpherRecipe> metamorpherType = RecipeType.create((String)"molecular_metamorphosis", (String)"experienceobelisk", MolecularMetamorpherRecipe.class);

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MolecularMetamorpherCategory(registration)});
        super.registerCategories(registration);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<MolecularMetamorpherRecipe> metamorpherRecipes = new ArrayList<MolecularMetamorpherRecipe>();
        for (Recipe recipe : Minecraft.m_91087_().f_91073_.m_7465_().m_44051_()) {
            if (!(recipe instanceof MolecularMetamorpherRecipe)) continue;
            MolecularMetamorpherRecipe metamorpherRecipe = (MolecularMetamorpherRecipe)recipe;
            metamorpherRecipes.add(metamorpherRecipe);
        }
        metamorpherRecipes.addAll(RecipeUtils.getNameFormattingRecipesForJEI());
        registration.addRecipes(metamorpherType, metamorpherRecipes);
        ItemStack FORGOTTEN_DUST = new ItemStack((ItemLike)RegisterItems.FORGOTTEN_DUST.get());
        ArrayList<ItemStack> EXPERIENCE_VESSELS = new ArrayList<ItemStack>();
        EXPERIENCE_VESSELS.add(new ItemStack((ItemLike)Items.f_42612_));
        EXPERIENCE_VESSELS.add(new ItemStack((ItemLike)RegisterItems.COGNITIUM_BUCKET.get()));
        registration.addIngredientInfo((Object)FORGOTTEN_DUST, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.experienceobelisk.description.forgotten_dust")});
        registration.addIngredientInfo(EXPERIENCE_VESSELS, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.experienceobelisk.description.experience_vessels")});
        ArrayList<ItemStack> hidden = new ArrayList<ItemStack>();
        hidden.add(new ItemStack((ItemLike)RegisterItems.DUMMY_SWORD.get(), 1));
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hidden);
        super.registerRecipes(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack stack = new ItemStack((ItemLike)RegisterItems.MOLECULAR_METAMORPHER_ITEM.get());
        registration.addRecipeCatalyst(stack, new RecipeType[]{metamorpherType});
        super.registerRecipeCatalysts(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MolecularMetamorpherTransferHandler(registration), metamorpherType);
        super.registerRecipeTransferHandlers(registration);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MolecularMetamorpherScreen.class, 107, 45, 32, 10, new RecipeType[]{metamorpherType});
        super.registerGuiHandlers(registration);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("experienceobelisk", "jei_plugin");
    }
}

