/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.client.model;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.model.GeoModel;

public class RibbitModel
extends GeoModel<RibbitEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ribbits", "textures/entity/ribbit.png");
    private static final ResourceLocation ANIMATIONS = new ResourceLocation("ribbits", "animations/ribbit.animation.json");
    private static final ResourceLocation PRIDE_MODEL = new ResourceLocation("ribbits", "geo/pride_ribbit.geo.json");

    public ResourceLocation getModelResource(RibbitEntity ribbitEntity) {
        if (ribbitEntity.getPlayingInstrument() && ribbitEntity.getRibbitData().getInstrument() != RibbitInstrumentModule.NONE) {
            return ribbitEntity.getRibbitData().getInstrument().getModelId();
        }
        if (ribbitEntity.getUmbrellaFalling() || ribbitEntity.m_20285_()) {
            return RibbitsCommon.id("geo/umbrella/" + ribbitEntity.getRibbitData().getProfession().getId().m_135815_() + "/" + ribbitEntity.getRibbitData().getUmbrellaType().getModelLocationSuffix());
        }
        if (ribbitEntity.isPrideRibbit()) {
            return PRIDE_MODEL;
        }
        return ribbitEntity.getRibbitData().getProfession().getModelLocation();
    }

    public ResourceLocation getTextureResource(RibbitEntity object) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(RibbitEntity animatable) {
        return ANIMATIONS;
    }
}

