/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.services;

import com.yungnickyoung.minecraft.ribbits.block.GiantLilyPadBlockForge;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.item.RibbitSpawnEggItemForge;
import com.yungnickyoung.minecraft.ribbits.module.EntityTypeModule;
import com.yungnickyoung.minecraft.ribbits.module.NetworkModuleForge;
import com.yungnickyoung.minecraft.ribbits.network.PlayerMusicStartS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.PlayerMusicStopS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStartAllS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStartSingleS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStopSingleS2CPacket;
import com.yungnickyoung.minecraft.ribbits.services.IPlatformHelper;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void onRibbitStartMusicGoal(ServerLevel serverLevel, RibbitEntity newRibbit, RibbitEntity masterRibbit) {
        int tickOffset = newRibbit.equals((Object)masterRibbit) ? masterRibbit.getTicksPlayingMusic() : -1;
        NetworkModuleForge.sendToAllClients(new RibbitMusicStartSingleS2CPacket(newRibbit.m_20148_(), newRibbit.getRibbitData().getInstrument().getId(), tickOffset));
    }

    @Override
    public void onPlayerEnterBandRange(ServerPlayer player, ServerLevel serverLevel, RibbitEntity masterRibbit) {
        NetworkModuleForge.sendToClient(new RibbitMusicStartAllS2CPacket(masterRibbit, masterRibbit.getTicksPlayingMusic()), player);
    }

    @Override
    public void onPlayerExitBandRange(ServerPlayer player, ServerLevel serverLevel, RibbitEntity masterRibbit) {
        NetworkModuleForge.sendToClient(new RibbitMusicStopSingleS2CPacket(masterRibbit.m_20148_()), player);
        for (RibbitEntity ribbit : masterRibbit.getRibbitsPlayingMusic()) {
            NetworkModuleForge.sendToClient(new RibbitMusicStopSingleS2CPacket(ribbit.m_20148_()), player);
        }
    }

    @Override
    public void startHearingMaraca(ServerPlayer performer, ServerPlayer audienceMember) {
        NetworkModuleForge.sendToClient(new PlayerMusicStartS2CPacket(performer.m_20148_()), audienceMember);
    }

    @Override
    public void stopHearingMaraca(ServerPlayer performer, ServerPlayer audienceMember) {
        NetworkModuleForge.sendToClient(new PlayerMusicStopS2CPacket(performer.m_20148_()), audienceMember);
    }

    @Override
    public Supplier<Block> getGiantLilyPadBlock() {
        return () -> new GiantLilyPadBlockForge(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60966_().m_60918_(SoundType.f_56741_).m_60955_().m_278166_(PushReaction.DESTROY));
    }

    @Override
    public Supplier<Item> getRibbitSpawnEggItem(RibbitProfession profession, int backgroundColor, int highlightColor) {
        return () -> new RibbitSpawnEggItemForge((EntityType<RibbitEntity>)((EntityType)EntityTypeModule.RIBBIT.get()), profession, backgroundColor, highlightColor, new Item.Properties());
    }
}

