/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block;

import de.markusbordihn.easymobfarm.block.CapturedMobCompatible;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.config.MobTypeManager;
import de.markusbordihn.easymobfarm.data.FarmTier;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import de.markusbordihn.easymobfarm.text.TranslatableText;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlock
extends BaseEntityBlock
implements CapturedMobCompatible {
    public static final String NAME = "mob_farm";
    public static final String SUPPORTED_MOBS_TEXT = "supported_mobs";
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final BooleanProperty WORKING = BooleanProperty.m_61465_((String)"working");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final Set<String> ACCEPTED_MOB_TYPES = Collections.emptySet();
    public static final Set<String> DENIED_MOB_TYPES = Collections.emptySet();
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public MobFarmBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getLightLevel(BlockState blockState) {
        return Boolean.TRUE.equals(blockState.m_61143_((Property)WORKING)) ? 15 : 8;
    }

    public static void logAcceptedMobTypes(String name, Set<String> acceptedMobTypes) {
        if (acceptedMobTypes == null || acceptedMobTypes.isEmpty()) {
            log.info("The {} will accept all mobs.", (Object)name);
        } else {
            log.info("The {} will accept only the following mobs: {}", (Object)name, acceptedMobTypes);
        }
    }

    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity mobFarm = (MobFarmBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)mobFarm);
        }
    }

    public Set<String> getGeneralAllowedMobTypes() {
        return MobTypeManager.getGeneralAllowedMobTypes();
    }

    public Set<String> getGeneralDeniedMobTypes() {
        return MobTypeManager.getGeneralDeniedMobTypes();
    }

    public Set<String> getAcceptedMobTypes() {
        return MobTypeManager.getAcceptedMobTypes(this.getFarmName());
    }

    public Set<String> getDeniedMobTypes() {
        return MobTypeManager.getDeniedMobTypes(this.getFarmName());
    }

    public boolean isAcceptedMobType(String mobType) {
        if (mobType == null || mobType.isBlank()) {
            return false;
        }
        if (this.getGeneralDeniedMobTypes().contains(mobType)) {
            return false;
        }
        if (this.getGeneralAllowedMobTypes().contains(mobType)) {
            return true;
        }
        if (this.getDeniedMobTypes().contains(mobType)) {
            return false;
        }
        return this.getAcceptedMobTypes().isEmpty() || this.getAcceptedMobTypes().contains(mobType);
    }

    public boolean isDeniedMobType(String mobType) {
        return !this.isAcceptedMobType(mobType);
    }

    public String getFarmDescriptionId() {
        return SUPPORTED_MOBS_TEXT;
    }

    public String getFarmName() {
        return NAME;
    }

    public FarmTier getFarmTier() {
        return FarmTier.DEFAULT;
    }

    public void appendHoverTextAcceptedMobs(List<Component> tooltipList) {
        Set<String> acceptedMobTypes = this.getAcceptedMobTypes();
        if (acceptedMobTypes != null && !acceptedMobTypes.isEmpty()) {
            MutableComponent mobTypeOverview = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GREEN);
            for (String acceptedMob : acceptedMobTypes) {
                Component acceptedMobName = TranslatableText.getEntityName(acceptedMob);
                if (acceptedMobName.getString().isBlank()) continue;
                mobTypeOverview.m_7220_(acceptedMobName).m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (!mobTypeOverview.getString().isBlank()) {
                MutableComponent supportedMobsOverview = Component.m_237115_((String)("text.easy_mob_farm." + this.getFarmDescriptionId())).m_130946_(" ").m_130940_(ChatFormatting.GREEN);
                supportedMobsOverview.m_7220_((Component)mobTypeOverview).m_130946_("...");
                tooltipList.add((Component)supportedMobsOverview);
            }
        } else {
            tooltipList.add((Component)Component.m_237115_((String)"text.easy_mob_farm.supported_all").m_130940_(ChatFormatting.GREEN));
        }
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState formerBlockState, boolean notify) {
        super.m_6807_(blockState, level, blockPos, formerBlockState, notify);
        if (!level.m_5776_()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(blockPos))), 2);
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighborBlockPos, boolean isMoving) {
        super.onNeighborChange(blockState, (LevelReader)level, blockPos, neighborBlockPos);
        if (!level.m_5776_()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(blockPos))), 2);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean canConnectRedstone(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, @Nullable Direction direction) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.m_61104_(new Property[]{FACING, WORKING, POWERED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return null;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        MobFarmBlockEntity mobFarmBlockEntity;
        ItemStack itemStack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (itemStack.m_41720_() instanceof CapturedMob && blockEntity instanceof MobFarmBlockEntity && !(mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity).hasItem(0)) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (CapturedMobVirtual.hasCapturedMob(itemStack) && blockEntity instanceof MobFarmBlockEntity && !(mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity).hasItem(0) && this.isAcceptedMobType(CapturedMobVirtual.getCapturedMobType(itemStack))) {
            mobFarmBlockEntity.takePlayerItem(0, player, hand);
            return InteractionResult.CONSUME;
        }
        if (player.m_6144_() && blockEntity instanceof MobFarmBlockEntity && (mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity).hasItem(0)) {
            mobFarmBlockEntity.givePlayerItem(0, level, player, hand, blockPos);
            return InteractionResult.CONSUME;
        }
        this.openContainer(level, blockPos, player);
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity blockEntityInstance = (MobFarmBlockEntity)blockEntity;
            blockEntityInstance.updateLevel(level);
            blockEntityInstance.setOwner(livingEntity);
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean flag) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof MobFarmBlockEntity) {
                MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)mobFarmBlockEntity);
                }
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(blockState, level, blockPos, blockState2, flag);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return null;
    }

    @Override
    public boolean canConsumeCapturedMob(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof CapturedMob) {
            String capturedMobType = CapturedMob.getCapturedMobType(itemStack);
            return this.isAcceptedMobType(capturedMobType);
        }
        if (CapturedMobVirtual.isSupported(itemStack)) {
            String capturedMobType = CapturedMobVirtual.getCapturedMobType(itemStack);
            return this.isAcceptedMobType(capturedMobType);
        }
        return false;
    }

    @Override
    public InteractionResult consumeCapturedMob(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack, UseOnContext context) {
        return null;
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, blockGetter, tooltipList, tooltipFlag);
        this.appendHoverTextAcceptedMobs(tooltipList);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

