/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntityData;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.data.RedstoneMode;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import de.markusbordihn.easymobfarm.loot.LootManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class MobFarmBlockEntity
extends MobFarmBlockEntityData
implements WorldlyContainer {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final int DEFAULT_FARM_PROCESSING_TIME = 6000;
    protected final Random random = new Random();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN, Direction.SOUTH});

    public MobFarmBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(null, blockPos, blockState);
    }

    public MobFarmBlockEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, MobFarmBlockEntity blockEntity) {
        ItemStack capturedMob = (ItemStack)blockEntity.items.get(0);
        if (capturedMob.m_41619_() || !blockEntity.hasItem(0)) {
            blockEntity.farmProgress = 0;
            blockEntity.farmStatus = 2;
            return;
        }
        if (blockEntity.getRedstoneMode() == RedstoneMode.ON && !((Boolean)blockState.m_61143_((Property)MobFarmBlock.POWERED)).booleanValue() || blockEntity.getRedstoneMode() == RedstoneMode.OFF && ((Boolean)blockState.m_61143_((Property)MobFarmBlock.POWERED)).booleanValue()) {
            blockEntity.farmProgress = 0;
            blockEntity.farmStatus = 4;
            return;
        }
        ItemStack resultItem1 = (ItemStack)blockEntity.items.get(1);
        ItemStack resultItem2 = (ItemStack)blockEntity.items.get(2);
        ItemStack resultItem3 = (ItemStack)blockEntity.items.get(3);
        ItemStack resultItem4 = (ItemStack)blockEntity.items.get(4);
        ItemStack resultItem5 = (ItemStack)blockEntity.items.get(5);
        if (resultItem1.m_41613_() >= resultItem1.m_41741_() && resultItem2.m_41613_() >= resultItem2.m_41741_() && resultItem3.m_41613_() >= resultItem3.m_41741_() && resultItem4.m_41613_() >= resultItem4.m_41741_() && resultItem5.m_41613_() >= resultItem5.m_41741_()) {
            if (blockEntity.farmStatus != 1) {
                blockEntity.farmStatus = 1;
            }
            return;
        }
        if (blockEntity.farmProgress >= blockEntity.farmTotalTime) {
            if (capturedMob.m_41720_() instanceof CapturedMob || CapturedMobVirtual.isSupported(capturedMob)) {
                ItemStack weaponItem = (ItemStack)blockEntity.items.get(6);
                ItemStack experienceItem = (ItemStack)blockEntity.items.get(7);
                blockEntity.processResult(capturedMob, weaponItem, experienceItem, blockEntity);
                blockEntity.processAdditionalEffects(level, blockPos, blockEntity, capturedMob);
            }
            blockEntity.farmProgress = 0;
            blockEntity.farmStatus = 0;
        } else {
            ++blockEntity.farmProgress;
            blockEntity.farmStatus = 3;
        }
    }

    public void updateLevel(Level level) {
        if (this.f_58857_ == null && this.f_58857_ != level && !level.m_5776_()) {
            this.f_58857_ = level;
        }
    }

    public boolean allowLootDropItem(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_();
    }

    public void givePlayerItem(int index, Level level, Player player, InteractionHand hand, BlockPos blockPos) {
        ItemStack itemStack = this.takeItem(index);
        if (itemStack.m_41619_() || itemStack.m_41763_() && itemStack.m_41773_() >= itemStack.m_41776_()) {
            return;
        }
        ItemStack handItemStack = player.m_21120_(hand);
        if (handItemStack.m_41619_()) {
            player.m_21008_(hand, itemStack);
        } else if (!player.m_150109_().m_36054_(itemStack) && level != null) {
            level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack));
        }
        this.syncData();
    }

    public void takePlayerItem(int index, Player player, InteractionHand hand) {
        ItemStack handItemStack = player.m_21120_(hand);
        if (handItemStack.m_41619_() || handItemStack.m_41763_() && handItemStack.m_41773_() >= handItemStack.m_41776_()) {
            return;
        }
        if (CapturedMob.hasCapturedMob(handItemStack) || CapturedMobVirtual.hasCapturedMob(handItemStack)) {
            ItemStack itemStack = handItemStack.m_41777_();
            itemStack.m_41764_(1);
            this.m_6836_(index, itemStack);
            handItemStack.m_41774_(1);
            this.syncData();
        }
    }

    protected List<ItemStack> processLootDrop(ItemStack capturedMob, ItemStack weaponItem, Level level) {
        return LootManager.getFilteredRandomLootDrop(capturedMob, weaponItem, level);
    }

    private void processResult(ItemStack capturedMob, ItemStack weaponItem, ItemStack experienceItem, MobFarmBlockEntity blockEntity) {
        boolean hasExperienceItem;
        boolean hasWeaponItem;
        List<ItemStack> lootDrops = this.processLootDrop(capturedMob, weaponItem, blockEntity.m_58904_());
        ArrayList<ItemStack> unstoredLootDrops = new ArrayList<ItemStack>();
        boolean bl = hasWeaponItem = weaponItem != null && !weaponItem.m_41619_();
        if (hasWeaponItem && weaponItem.m_41763_() && Boolean.TRUE.equals(MobFarmBlockEntity.COMMON.damageWeaponItem.get())) {
            int unbreakingLevel = weaponItem.getEnchantmentLevel(Enchantments.f_44986_);
            int randomDamageValue = this.random.nextInt(11);
            int damageValue = Math.max(randomDamageValue - unbreakingLevel * 2, 0);
            if (damageValue > 0) {
                if (weaponItem.m_41773_() + damageValue < weaponItem.m_41776_()) {
                    weaponItem.m_41721_(weaponItem.m_41773_() + damageValue);
                } else {
                    blockEntity.items.set(6, (Object)ItemStack.f_41583_);
                }
            }
        }
        int experienceDropChance = 0;
        experienceDropChance = hasWeaponItem ? (weaponItem.getEnchantmentLevel(Enchantments.f_44977_) > 0 || weaponItem.getEnchantmentLevel(Enchantments.f_44982_) > 0 ? this.random.nextInt((Integer)MobFarmBlockEntity.COMMON.experienceDropChanceWithEnchantedWeapon.get()) : this.random.nextInt((Integer)MobFarmBlockEntity.COMMON.experienceDropChanceWithWeapon.get())) : this.random.nextInt((Integer)MobFarmBlockEntity.COMMON.experienceDropChanceNoWeapon.get());
        boolean bl2 = hasExperienceItem = experienceItem != null && !experienceItem.m_41619_();
        if ((hasWeaponItem || hasExperienceItem) && experienceDropChance == 0) {
            if (hasWeaponItem && weaponItem.m_41763_() && weaponItem.m_41773_() > 0 && weaponItem.getEnchantmentLevel(Enchantments.f_44962_) > 0) {
                int repairAmount = this.random.nextInt((Integer)MobFarmBlockEntity.COMMON.experienceDropMendingRepairAmount.get());
                if (repairAmount > 0) {
                    weaponItem.m_41721_(weaponItem.m_41773_() - repairAmount);
                }
            } else if (hasExperienceItem && experienceItem.m_150930_(Items.f_42590_)) {
                blockEntity.items.set(7, (Object)new ItemStack((ItemLike)Items.f_42612_));
            } else if (hasExperienceItem && experienceItem.m_41720_() instanceof ExperienceBottleItem && experienceItem.m_41613_() < experienceItem.m_41741_()) {
                experienceItem.m_41764_(experienceItem.m_41613_() + 1);
                blockEntity.items.set(7, (Object)experienceItem);
            }
        }
        for (ItemStack lootDrop : lootDrops) {
            if (lootDrop.m_41619_() || !this.allowLootDropItem(lootDrop)) continue;
            ItemStack resultItem1 = (ItemStack)blockEntity.items.get(1);
            if (!resultItem1.m_41619_() && resultItem1.m_150930_(lootDrop.m_41720_()) && resultItem1.m_41613_() + lootDrop.m_41613_() <= resultItem1.m_41741_()) {
                resultItem1.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem2 = (ItemStack)blockEntity.items.get(2);
            if (!resultItem2.m_41619_() && resultItem2.m_150930_(lootDrop.m_41720_()) && resultItem2.m_41613_() + lootDrop.m_41613_() <= resultItem2.m_41741_()) {
                resultItem2.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem3 = (ItemStack)blockEntity.items.get(3);
            if (!resultItem3.m_41619_() && resultItem3.m_150930_(lootDrop.m_41720_()) && resultItem3.m_41613_() + lootDrop.m_41613_() <= resultItem3.m_41741_()) {
                resultItem3.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem4 = (ItemStack)blockEntity.items.get(4);
            if (!resultItem4.m_41619_() && resultItem4.m_150930_(lootDrop.m_41720_()) && resultItem4.m_41613_() + lootDrop.m_41613_() <= resultItem4.m_41741_()) {
                resultItem4.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem5 = (ItemStack)blockEntity.items.get(5);
            if (!resultItem5.m_41619_() && resultItem5.m_150930_(lootDrop.m_41720_()) && resultItem5.m_41613_() + lootDrop.m_41613_() <= resultItem5.m_41741_()) {
                resultItem5.m_41769_(lootDrop.m_41613_());
                continue;
            }
            if (resultItem1.m_41619_()) {
                blockEntity.m_6836_(1, lootDrop);
                continue;
            }
            if (resultItem2.m_41619_()) {
                blockEntity.m_6836_(2, lootDrop);
                continue;
            }
            if (resultItem3.m_41619_()) {
                blockEntity.m_6836_(3, lootDrop);
                continue;
            }
            if (resultItem4.m_41619_()) {
                blockEntity.m_6836_(4, lootDrop);
                continue;
            }
            if (resultItem5.m_41619_()) {
                blockEntity.m_6836_(5, lootDrop);
                continue;
            }
            unstoredLootDrops.add(lootDrop);
        }
        if (!unstoredLootDrops.isEmpty()) {
            this.processFullStorage(blockEntity, unstoredLootDrops);
        }
        this.syncData();
    }

    public void processAdditionalEffects(Level level, BlockPos blockPos, MobFarmBlockEntity blockEntity, ItemStack capturedMob) {
        SoundEvent farmDropSound = this.getFarmDropSound();
        if (Boolean.TRUE.equals(MobFarmBlockEntity.COMMON.playDropSound.get()) && farmDropSound != null && farmDropSound.m_11660_() != null && level != null && blockPos != null) {
            level.m_5594_(null, blockPos, farmDropSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void processFullStorage(MobFarmBlockEntity blockEntity, List<ItemStack> lootDrop) {
        Player owner;
        if (Boolean.TRUE.equals((Boolean)MobFarmBlockEntity.COMMON.informOwnerAboutFullStorage.get() == false) && Boolean.TRUE.equals((Boolean)MobFarmBlockEntity.COMMON.logFullStorage.get() == false)) {
            return;
        }
        UUID ownerUUID = blockEntity.getOwner();
        BlockPos blockPos = blockEntity.m_58899_();
        if (Boolean.TRUE.equals(MobFarmBlockEntity.COMMON.logFullStorage.get())) {
            log.warn("Unable to store loot drop {} for mob farm {} at {} for owner {}!", lootDrop, (Object)this.farmMobName, (Object)blockPos, (Object)ownerUUID);
        }
        Level level = blockEntity.f_58857_;
        if (Boolean.TRUE.equals(MobFarmBlockEntity.COMMON.informOwnerAboutFullStorage.get()) && ownerUUID != null && blockEntity.f_58857_ != null && level != null && (owner = level.m_46003_(ownerUUID)) != null && owner.m_6084_()) {
            MutableComponent message = Component.m_237110_((String)"message.easy_mob_farm.warning_full", (Object[])new Object[]{this.farmMobName, blockPos, lootDrop}).m_130940_(ChatFormatting.YELLOW);
            owner.m_213846_((Component)message);
        }
    }

    @Override
    public void m_6836_(int index, ItemStack itemStack) {
        super.m_6836_(index, itemStack);
        if (index == 0) {
            if (itemStack.m_41720_() instanceof CapturedMob) {
                this.farmMobColor = CapturedMob.getCapturedMobColor(itemStack);
                this.farmMobEntityType = CapturedMob.getCapturedMobEntityType(itemStack);
                this.farmMobName = CapturedMob.getCapturedMob(itemStack);
                this.farmMobShearedStatus = CapturedMob.getCapturedMobShearedStatus(itemStack);
                this.farmMobSize = CapturedMob.getCapturedMobSize(itemStack);
                this.farmMobSubType = CapturedMob.getCapturedMobSubType(itemStack);
                this.farmMobType = CapturedMob.getCapturedMobType(itemStack);
            } else if (CapturedMobVirtual.isSupported(itemStack)) {
                this.farmMobColor = CapturedMobVirtual.getCapturedMobColor(itemStack);
                this.farmMobEntityType = CapturedMobVirtual.getCapturedMobEntityType(itemStack);
                this.farmMobName = CapturedMobVirtual.getCapturedMob(itemStack);
                this.farmMobShearedStatus = CapturedMobVirtual.getCapturedMobShearedStatus(itemStack);
                this.farmMobSize = CapturedMobVirtual.getCapturedMobSize(itemStack);
                this.farmMobSubType = CapturedMobVirtual.getCapturedMobSubType(itemStack);
                this.farmMobType = CapturedMobVirtual.getCapturedMobType(itemStack);
            } else {
                this.farmMobColor = null;
                this.farmMobEntityType = null;
                this.farmMobName = "";
                this.farmMobShearedStatus = false;
                this.farmMobSize = 1;
                this.farmMobSubType = "";
                this.farmMobType = "";
            }
            if (this.farmMobType != null && !this.farmMobType.isBlank()) {
                this.farmTotalTime = this.getFarmProcessingTime() > 0 ? this.getFarmProcessingTime() : 6000;
            }
            BlockState blockState = this.m_58900_();
            BlockPos blockPos = this.m_58899_();
            Level level = this.f_58857_;
            if (blockState != null && blockPos != null && level != null) {
                BlockState newBlockState = (BlockState)blockState.m_61124_((Property)MobFarmBlock.WORKING, (Comparable)Boolean.valueOf(!itemStack.m_41619_()));
                level.m_7731_(blockPos, newBlockState, 3);
                MobFarmBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)newBlockState);
            }
            this.syncData();
        }
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = super.m_7407_(index, count);
        if (index == 0) {
            this.syncData();
        }
        return itemStack;
    }

    public int[] m_7071_(Direction direction) {
        switch (direction) {
            case DOWN: {
                return new int[]{1, 2, 3, 4, 5, 7};
            }
            case SOUTH: {
                return new int[]{0, 6, 7};
            }
        }
        return new int[0];
    }

    public boolean m_7155_(int slotIndex, ItemStack itemStack, @Nullable Direction direction) {
        switch (slotIndex) {
            case 0: {
                return !this.hasItem(0) && (CapturedMob.hasCapturedMob(itemStack) || CapturedMobVirtual.hasCapturedMob(itemStack));
            }
            case 6: {
                return !this.hasItem(6) && itemStack.m_41763_();
            }
            case 7: {
                return !this.hasItem(7) && itemStack.m_150930_(Items.f_42590_);
            }
        }
        return false;
    }

    public boolean m_7157_(int slotIndex, ItemStack itemStack, Direction direction) {
        if (direction != Direction.DOWN) {
            return false;
        }
        switch (slotIndex) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 7: {
                return itemStack.m_150930_(Items.f_42612_);
            }
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            Direction blockFacing = (Direction)this.m_58900_().m_61143_((Property)MobFarmBlock.FACING);
            if (facing == Direction.DOWN) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.NORTH && blockFacing == Direction.SOUTH || facing == Direction.SOUTH && blockFacing == Direction.NORTH || facing == Direction.EAST && blockFacing == Direction.WEST || facing == Direction.WEST && blockFacing == Direction.EAST) {
                return this.handlers[1].cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }
}

