/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity.farm.copper;

import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.FarmTier;
import de.markusbordihn.easymobfarm.menu.farm.copper.CopperBeeHiveFarmMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class CopperBeeHiveFarmEntity
extends MobFarmBlockEntity {
    private static int farmProcessingTime = 1200;
    private static SoundEvent farmDropSound;

    public CopperBeeHiveFarmEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModBlocks.COPPER_BEE_HIVE_FARM_ENTITY.get(), blockPos, blockState);
    }

    public CopperBeeHiveFarmEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        farmProcessingTime = (Integer)CopperBeeHiveFarmEntity.COMMON.copperBeeHiveFarmProcessTime.get() * 20;
        log.info("{}: Copper Bee Hive Farm Entity with drops every {}s", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", CopperBeeHiveFarmEntity.COMMON.copperBeeHiveFarmProcessTime.get());
        String farmDropSoundName = (String)CopperBeeHiveFarmEntity.COMMON.copperBeeHiveFarmDropSound.get();
        if (Boolean.TRUE.equals(CopperBeeHiveFarmEntity.COMMON.playDropSound.get()) && farmDropSoundName != null && !farmDropSoundName.isEmpty() && (farmDropSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(farmDropSoundName))) != null) {
            log.info("{}: Copper Bee Hive Farm Entity will play drop sound: {}", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", (Object)farmDropSound.m_11660_());
        }
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.easy_mob_farm.bee_hive_farm");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new CopperBeeHiveFarmMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    @Override
    public int getFarmProcessingTime() {
        return farmProcessingTime;
    }

    @Override
    public SoundEvent getFarmDropSound() {
        return farmDropSound;
    }

    @Override
    public FarmTier getFarmTier() {
        return FarmTier.COPPER;
    }
}

