/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity.farm.gold;

import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.FarmTier;
import de.markusbordihn.easymobfarm.menu.farm.gold.GoldNetherFortressFarmMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GoldNetherFortressFarmEntity
extends MobFarmBlockEntity {
    private static int farmProcessingTime = 1200;
    private static SoundEvent farmDropSound;

    public GoldNetherFortressFarmEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModBlocks.GOLD_NETHER_FORTRESS_FARM_ENTITY.get(), blockPos, blockState);
    }

    public GoldNetherFortressFarmEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        farmProcessingTime = (Integer)GoldNetherFortressFarmEntity.COMMON.goldNetherFortressFarmProcessTime.get() * 20;
        log.info("{}: Gold Nether Fortress Farm Entity with drops every {}s", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", GoldNetherFortressFarmEntity.COMMON.goldNetherFortressFarmProcessTime.get());
        String farmDropSoundName = (String)GoldNetherFortressFarmEntity.COMMON.goldNetherFortressFarmDropSound.get();
        if (Boolean.TRUE.equals(GoldNetherFortressFarmEntity.COMMON.playDropSound.get()) && farmDropSoundName != null && !farmDropSoundName.isEmpty() && (farmDropSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(farmDropSoundName))) != null) {
            log.info("{}: Gold Nether Fortress Farm Entity will play drop sound: {}", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", (Object)farmDropSound.m_11660_());
        }
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.easy_mob_farm.nether_fortress_farm");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new GoldNetherFortressFarmMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    @Override
    public int getFarmProcessingTime() {
        return farmProcessingTime;
    }

    @Override
    public SoundEvent getFarmDropSound() {
        return farmDropSound;
    }

    @Override
    public FarmTier getFarmTier() {
        return FarmTier.GOLD;
    }
}

