/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity.farm.iron;

import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.FarmTier;
import de.markusbordihn.easymobfarm.menu.farm.iron.IronAnimalPlainsFarmMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class IronAnimalPlainsFarmEntity
extends MobFarmBlockEntity {
    private static int farmProcessingTime = 1200;
    private static SoundEvent farmDropSound;

    public IronAnimalPlainsFarmEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModBlocks.IRON_ANIMAL_PLAINS_FARM_ENTITY.get(), blockPos, blockState);
    }

    public IronAnimalPlainsFarmEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        farmProcessingTime = (Integer)IronAnimalPlainsFarmEntity.COMMON.ironAnimalPlainsFarmProcessTime.get() * 20;
        log.info("{}: Iron Animal Plains Farm Entity with drops every {}s", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", IronAnimalPlainsFarmEntity.COMMON.ironAnimalPlainsFarmProcessTime.get());
        String farmDropSoundName = (String)IronAnimalPlainsFarmEntity.COMMON.ironAnimalPlainsFarmDropSound.get();
        if (Boolean.TRUE.equals(IronAnimalPlainsFarmEntity.COMMON.playDropSound.get()) && farmDropSoundName != null && !farmDropSoundName.isEmpty() && (farmDropSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(farmDropSoundName))) != null) {
            log.info("{}: Iron Animal Plains Farm Entity will play drop sound: {}", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", (Object)farmDropSound.m_11660_());
        }
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.easy_mob_farm.animal_plains_farm");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new IronAnimalPlainsFarmMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    @Override
    public int getFarmProcessingTime() {
        return farmProcessingTime;
    }

    @Override
    public SoundEvent getFarmDropSound() {
        return farmDropSound;
    }

    @Override
    public FarmTier getFarmTier() {
        return FarmTier.IRON;
    }
}

