/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity.farm.special;

import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.FarmTier;
import de.markusbordihn.easymobfarm.menu.farm.special.IronGolemFarmMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class IronGolemFarmEntity
extends MobFarmBlockEntity {
    private static int farmProcessingTime = 1200;
    private static SoundEvent farmDropSound;

    public IronGolemFarmEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModBlocks.IRON_GOLEM_FARM_ENTITY.get(), blockPos, blockState);
    }

    public IronGolemFarmEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        farmProcessingTime = (Integer)IronGolemFarmEntity.COMMON.ironGolemFarmProcessTime.get() * 20;
        log.info("{}: Iron Golem Plains Farm Entity with drops every {}s", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", IronGolemFarmEntity.COMMON.ironGolemFarmProcessTime.get());
        String farmDropSoundName = (String)IronGolemFarmEntity.COMMON.ironGolemFarmDropSound.get();
        if (Boolean.TRUE.equals(IronGolemFarmEntity.COMMON.playDropSound.get()) && farmDropSoundName != null && !farmDropSoundName.isEmpty() && (farmDropSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(farmDropSoundName))) != null) {
            log.info("{}: Iron Golem Plains Farm Entity will play drop sound: {}", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", (Object)farmDropSound.m_11660_());
        }
    }

    @Override
    protected List<ItemStack> processLootDrop(ItemStack capturedMob, ItemStack weaponItem, Level level) {
        List<ItemStack> lootDrops = super.processLootDrop(capturedMob, weaponItem, level);
        if (Boolean.TRUE.equals(IronGolemFarmEntity.COMMON.ironGolemFarmFilterPoppy.get())) {
            lootDrops.removeIf(itemStack -> itemStack.m_41720_().equals(Items.f_41940_));
        }
        return lootDrops;
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.easy_mob_farm.iron_golem_farm");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new IronGolemFarmMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    @Override
    public int getFarmProcessingTime() {
        return farmProcessingTime;
    }

    @Override
    public SoundEvent getFarmDropSound() {
        return farmDropSound;
    }

    @Override
    public FarmTier getFarmTier() {
        return FarmTier.IRON;
    }
}

