/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.farm.gold;

import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.block.entity.farm.gold.GoldBeeHiveFarmEntity;
import de.markusbordihn.easymobfarm.data.FarmTier;
import de.markusbordihn.easymobfarm.text.TranslatableText;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GoldBeeHiveFarm
extends MobFarmBlock {
    public static final String NAME = "gold_bee_hive_farm";

    public GoldBeeHiveFarm(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public String getFarmDescriptionId() {
        return "supported_animals";
    }

    @Override
    public FarmTier getFarmTier() {
        return FarmTier.GOLD;
    }

    @Override
    public String getFarmName() {
        return NAME;
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GoldBeeHiveFarmEntity((BlockEntityType)ModBlocks.GOLD_BEE_HIVE_FARM_ENTITY.get(), blockPos, blockState);
    }

    @Override
    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof GoldBeeHiveFarmEntity) {
            GoldBeeHiveFarmEntity beeHiveFarmEntity = (GoldBeeHiveFarmEntity)blockEntity;
            player.m_5893_((MenuProvider)beeHiveFarmEntity);
        }
    }

    @Override
    public InteractionResult consumeCapturedMob(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack, UseOnContext context) {
        GoldBeeHiveFarmEntity beeHiveMobFarmEntity = (GoldBeeHiveFarmEntity)blockEntity;
        beeHiveMobFarmEntity.updateLevel(level);
        if (!beeHiveMobFarmEntity.hasItem(0)) {
            beeHiveMobFarmEntity.m_6836_(0, itemStack);
            Player player = context.m_43723_();
            if (player != null) {
                player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : GoldBeeHiveFarm.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.GOLD_BEE_HIVE_FARM_ENTITY.get()), MobFarmBlockEntity::serverTick);
    }

    @Override
    public void appendHoverTextAcceptedMobs(List<Component> tooltipList) {
        Set<String> acceptedMobTypes = this.getAcceptedMobTypes();
        if (acceptedMobTypes != null && !acceptedMobTypes.isEmpty()) {
            MutableComponent mobTypeOverview = Component.m_237115_((String)"").m_130940_(ChatFormatting.DARK_GREEN);
            for (String acceptedMob : acceptedMobTypes) {
                Component acceptedMobName;
                if (!Constants.PRODUCTIVE_BEES_LOADED && acceptedMob.startsWith("productivebees:") || acceptedMobTypes.size() >= 16 && Constants.PRODUCTIVE_BEES_LOADED && acceptedMob.startsWith("productivebees:") || (acceptedMobName = TranslatableText.getEntityName(acceptedMob)).getString().isBlank()) continue;
                mobTypeOverview.m_7220_(acceptedMobName).m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (Constants.PRODUCTIVE_BEES_LOADED && acceptedMobTypes.size() >= 16) {
                mobTypeOverview.m_130946_("Productive Bees").m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (!mobTypeOverview.getString().isBlank()) {
                MutableComponent supportedMobsOverview = Component.m_237115_((String)("text.easy_mob_farm." + this.getFarmDescriptionId())).m_130946_(" ").m_130940_(ChatFormatting.GREEN);
                supportedMobsOverview.m_7220_((Component)mobTypeOverview).m_130946_("...");
                tooltipList.add((Component)supportedMobsOverview);
            }
        } else {
            tooltipList.add((Component)Component.m_237115_((String)"text.easy_mob_farm.supported_all").m_130940_(ChatFormatting.GREEN));
        }
    }
}

