/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.MobFarmRendererBase;
import de.markusbordihn.easymobfarm.client.renderer.helper.RenderHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AnimalFarmRenderer
extends MobFarmRendererBase<MobFarmBlockEntity> {
    public AnimalFarmRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(MobFarmBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(blockEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        int farmId = blockEntity.getFarmId();
        if (!blockEntity.hasItem(0)) {
            this.resetRenderHelper(farmId);
            return;
        }
        RenderHelper renderHelper = this.getRenderHelper(farmId, (BlockEntity)blockEntity);
        String farmMobType = blockEntity.getFarmMobType();
        String farmMobSubType = blockEntity.getFarmMobSubType();
        EntityType<?> farmMobEntityType = blockEntity.getFarmMobEntityType();
        if (renderHelper.renderAnimal(poseStack, buffer, combinedLight, farmMobType) || renderHelper.renderBee(poseStack, buffer, combinedLight, farmMobType, farmMobSubType, farmMobEntityType)) {
            return;
        }
        if (farmMobEntityType != null) {
            renderHelper.renderLivingEntity(poseStack, buffer, combinedLight, farmMobEntityType);
        }
    }
}

