/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.helper.RenderHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmRendererBase<T extends MobFarmBlockEntity>
implements BlockEntityRenderer<T> {
    public static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected Minecraft minecraft;
    protected Level level = null;
    protected BlockEntityRendererProvider.Context context = null;
    private LocalPlayer player;
    private Map<Integer, RenderHelper> renderHelperCache = new ConcurrentHashMap<Integer, RenderHelper>();

    public MobFarmRendererBase(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.minecraft = Minecraft.m_91087_();
    }

    public RenderHelper getRenderHelper(int renderId, BlockEntity blockEntity) {
        return this.renderHelperCache.computeIfAbsent(renderId, key -> new RenderHelper(renderId, this.minecraft, blockEntity));
    }

    public void resetRenderHelper(int renderId) {
        if (this.renderHelperCache.getOrDefault(renderId, null) != null) {
            this.renderHelperCache.remove(renderId);
        }
    }

    public LocalPlayer getPlayer() {
        if (this.player == null) {
            this.player = this.minecraft.f_91074_;
        }
        return this.player;
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
    }
}

