/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.client.renderer.helper.RenderModels;
import de.markusbordihn.easymobfarm.client.screen.MobFarmScreenHelper;
import de.markusbordihn.easymobfarm.client.screen.Snapshots;
import de.markusbordihn.easymobfarm.config.MobTypeManager;
import de.markusbordihn.easymobfarm.data.RedstoneMode;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import de.markusbordihn.easymobfarm.menu.slots.CapturedMobSlot;
import de.markusbordihn.easymobfarm.menu.slots.ExperienceSlot;
import de.markusbordihn.easymobfarm.menu.slots.WeaponSlot;
import de.markusbordihn.easymobfarm.network.NetworkMessage;
import de.markusbordihn.easymobfarm.text.TranslatableText;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmScreen<T extends MobFarmMenu>
extends AbstractContainerScreen<T> {
    public static final int SNAP_WITH = 34;
    public static final int SNAP_HEIGHT = 53;
    public static final int MAX_HELP_TEXT_WIDTH = 300;
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final ResourceLocation CUSTOM = new ResourceLocation("easy_mob_farm", "textures/container/custom.png");
    private static final ResourceLocation CUSTOM_SHADOW = new ResourceLocation("easy_mob_farm", "textures/container/custom_shadow.png");
    private final MutableComponent warningDisabledText;
    private final MutableComponent warningFullText;
    private final T mobFarmMenu;
    private RenderModels renderModels;
    private float dropTimeLabelScale = 0.75f;
    private float nextDropTimeLabelScale = 0.75f;
    private int animationTicker = 0;
    private int dropTimeLabelX;
    private int dropTimeLabelY;
    private int nextDropTimeLabelX;
    private int nextDropTimeLabelY;
    private int ticker = 0;
    private StringSplitter stringSplitter;
    private int redstoneButtonX = 154;
    private int redstoneButtonY;
    private int redstoneButtonModeOnY = this.redstoneButtonY = 44;
    private int redstoneButtonModeDisabledY = this.redstoneButtonModeOnY + 10;
    private int redstoneButtonModeOffY = this.redstoneButtonModeDisabledY + 9;
    private int redstoneButtonWidth = 12;
    private int redstoneButtonHeight = 29;

    public MobFarmScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.mobFarmMenu = menu;
        this.warningDisabledText = Component.m_237115_((String)"text.easy_mob_farm.warning_disabled");
        this.warningFullText = Component.m_237115_((String)"text.easy_mob_farm.warning_full");
    }

    protected void renderSnapshot(GuiGraphics guiGraphics, ResourceLocation mobFarmTypeSnapshot) {
        if (mobFarmTypeSnapshot != null) {
            guiGraphics.m_280163_(mobFarmTypeSnapshot, this.f_97735_ + 7, this.f_97736_ + 16, 0.0f, 0.0f, 49, 70, 49, 70);
        }
    }

    private void renderEntityType(GuiGraphics guiGraphics, int x, int y) {
        String mobFarmType = ((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmType();
        if (!mobFarmType.isBlank() && ((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmStatus() != 2) {
            ResourceLocation mobFarmTypeSnapshot = Snapshots.getSnapshot(mobFarmType);
            if (mobFarmTypeSnapshot != null) {
                this.renderSnapshot(guiGraphics, mobFarmTypeSnapshot);
            } else {
                LivingEntity livingEntity = this.renderModels.getEntityTypeModel(mobFarmType);
                if (livingEntity != null) {
                    this.renderSnapshot(guiGraphics, CUSTOM_SHADOW);
                    switch (mobFarmType) {
                        case "minecraft:rabbit": {
                            MobFarmScreenHelper.renderEntity(this.f_97735_ + 33, this.f_97736_ + 75, (float)this.f_97735_ + 33.0f - (float)x, (float)this.f_97736_ + 65.0f - (float)y, 45, livingEntity);
                            break;
                        }
                        case "minecraft:iron_golem": {
                            MobFarmScreenHelper.renderEntity(this.f_97735_ + 33, this.f_97736_ + 75, (float)this.f_97735_ + 33.0f - (float)x, (float)this.f_97736_ + 65.0f - (float)y, livingEntity);
                            break;
                        }
                        default: {
                            MobFarmScreenHelper.renderEntity(this.f_97735_ + 33, this.f_97736_ + 65, (float)this.f_97735_ + 33.0f - (float)x, (float)this.f_97736_ + 65.0f - (float)y, livingEntity);
                            break;
                        }
                    }
                } else {
                    this.renderSnapshot(guiGraphics, CUSTOM);
                }
            }
        }
    }

    protected void renderHelpText(GuiGraphics guiGraphics, int x, int y) {
        if (((MobFarmMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && !this.f_97734_.m_6657_() && this.f_96547_ != null && this.stringSplitter != null) {
            if (this.f_97734_ instanceof CapturedMobSlot) {
                Set<String> acceptedMobTypes = MobTypeManager.getAcceptedMobTypes(((MobFarmMenu)this.f_97732_).getAcceptedMobTypeName());
                if (acceptedMobTypes != null && !acceptedMobTypes.isEmpty()) {
                    MutableComponent mobTypeOverview = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GREEN);
                    for (String acceptedMob : acceptedMobTypes) {
                        Component acceptedMobName = TranslatableText.getEntityName(acceptedMob);
                        if (acceptedMobName.getString().isBlank()) continue;
                        mobTypeOverview.m_7220_(acceptedMobName).m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
                    }
                    mobTypeOverview.m_7220_((Component)Component.m_237113_((String)"..."));
                    guiGraphics.renderComponentTooltip(this.f_96547_, this.stringSplitter.m_92414_((FormattedText)Component.m_237110_((String)"help_text.easy_mob_farm.capture_slot", (Object[])new Object[]{mobTypeOverview}), 300, Style.f_131099_), x, y, ItemStack.f_41583_);
                } else {
                    guiGraphics.renderComponentTooltip(this.f_96547_, this.stringSplitter.m_92414_((FormattedText)Component.m_237115_((String)"help_text.easy_mob_farm.capture_slot_all"), 300, Style.f_131099_), x, y, ItemStack.f_41583_);
                }
            } else if (this.f_97734_ instanceof WeaponSlot) {
                guiGraphics.renderComponentTooltip(this.f_96547_, this.stringSplitter.m_92414_((FormattedText)Component.m_237115_((String)"help_text.easy_mob_farm.weapon_slot"), 300, Style.f_131099_), x, y, ItemStack.f_41583_);
            } else if (this.f_97734_ instanceof ExperienceSlot) {
                guiGraphics.renderComponentTooltip(this.f_96547_, this.stringSplitter.m_92414_((FormattedText)Component.m_237110_((String)"help_text.easy_mob_farm.experience_slot", (Object[])new Object[]{Items.f_42590_.m_41466_(), Items.f_42612_.m_41466_()}), 300, Style.f_131099_), x, y, ItemStack.f_41583_);
            }
        }
    }

    public void renderRedstoneButton(GuiGraphics guiGraphics) {
        int redstoneButtonModeX = ((MobFarmMenu)this.f_97732_).isMobFarmPowered() ? 145 : 131;
        int redstoneButtonModeY = 1;
        switch (((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmRedstoneMode()) {
            case ON: {
                redstoneButtonModeY += this.redstoneButtonHeight + 3;
                break;
            }
            case OFF: {
                redstoneButtonModeY += (this.redstoneButtonHeight + 3) * 2;
                break;
            }
            default: {
                redstoneButtonModeY = 1;
            }
        }
        guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + this.redstoneButtonX, this.f_97736_ + this.redstoneButtonY, redstoneButtonModeX, redstoneButtonModeY, this.redstoneButtonWidth, this.redstoneButtonHeight);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        int hoverPositionX = x - this.f_97735_;
        int hoverPositionY = y - this.f_97736_;
        if (hoverPositionX > this.redstoneButtonX && hoverPositionX < this.redstoneButtonX + this.redstoneButtonWidth && hoverPositionY > this.redstoneButtonY && hoverPositionY < this.redstoneButtonY + this.redstoneButtonHeight) {
            if (hoverPositionY > this.redstoneButtonModeOnY && hoverPositionY < this.redstoneButtonModeOnY + 10) {
                guiGraphics.renderComponentTooltip(this.f_96547_, this.stringSplitter.m_92414_((FormattedText)Component.m_237115_((String)"help_text.easy_mob_farm.redstone_button_on"), 300, Style.f_131099_), x, y, ItemStack.f_41583_);
            } else if (hoverPositionY > this.redstoneButtonModeDisabledY && hoverPositionY < this.redstoneButtonModeDisabledY + 9) {
                guiGraphics.renderComponentTooltip(this.f_96547_, this.stringSplitter.m_92414_((FormattedText)Component.m_237115_((String)"help_text.easy_mob_farm.redstone_button_disabled"), 300, Style.f_131099_), x, y, ItemStack.f_41583_);
            } else if (hoverPositionY > this.redstoneButtonModeOffY && hoverPositionY < this.redstoneButtonModeOffY + 10) {
                guiGraphics.renderComponentTooltip(this.f_96547_, this.stringSplitter.m_92414_((FormattedText)Component.m_237115_((String)"help_text.easy_mob_farm.redstone_button_off"), 300, Style.f_131099_), x, y, ItemStack.f_41583_);
            }
        } else {
            super.m_280072_(guiGraphics, x, y);
        }
    }

    public boolean m_6348_(double x, double y, int button) {
        double clickedPositionX = x - (double)this.f_97735_;
        double clickedPositionY = y - (double)this.f_97736_;
        if (button == 0 && clickedPositionX > (double)this.redstoneButtonX && clickedPositionX < (double)(this.redstoneButtonX + this.redstoneButtonWidth) && clickedPositionY > (double)this.redstoneButtonY && clickedPositionY < (double)(this.redstoneButtonY + this.redstoneButtonHeight)) {
            if (clickedPositionY > (double)this.redstoneButtonModeOnY && clickedPositionY < (double)(this.redstoneButtonModeOnY + 10)) {
                NetworkMessage.sendRedstoneModeChangeToServer(((MobFarmMenu)this.f_97732_).getMobFarmPosition(), RedstoneMode.ON);
            } else if (clickedPositionY > (double)this.redstoneButtonModeDisabledY && clickedPositionY < (double)(this.redstoneButtonModeDisabledY + 9)) {
                NetworkMessage.sendRedstoneModeChangeToServer(((MobFarmMenu)this.f_97732_).getMobFarmPosition(), RedstoneMode.DISABLED);
            } else if (clickedPositionY > (double)this.redstoneButtonModeOffY && clickedPositionY < (double)(this.redstoneButtonModeOffY + 10)) {
                NetworkMessage.sendRedstoneModeChangeToServer(((MobFarmMenu)this.f_97732_).getMobFarmPosition(), RedstoneMode.OFF);
            }
        }
        return super.m_6348_(x, y, button);
    }

    public void m_7856_() {
        super.m_7856_();
        this.animationTicker = 0;
        this.ticker = 0;
        this.f_97727_ = 221;
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97729_ = 5;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97731_ = this.f_97727_ - 92;
        this.dropTimeLabelX = Math.round(47.0f / this.dropTimeLabelScale);
        this.dropTimeLabelY = Math.round(119.0f / this.dropTimeLabelScale);
        this.nextDropTimeLabelX = Math.round(66.0f / this.nextDropTimeLabelScale);
        this.nextDropTimeLabelY = Math.round(91.0f / this.nextDropTimeLabelScale);
        this.renderModels = new RenderModels(this.f_96541_);
        this.stringSplitter = this.f_96547_.m_92865_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        if ((this.ticker++ & 0x27) == 0) {
            ((MobFarmMenu)((Object)this.mobFarmMenu)).updateMobFarmDataCache();
            if (this.ticker >= 40) {
                this.ticker = 0;
            }
        }
        if (this.animationTicker++ > 400) {
            this.animationTicker = 0;
        }
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.renderRedstoneButton(guiGraphics);
        this.renderEntityType(guiGraphics, x, y);
        this.m_280072_(guiGraphics, x, y);
        this.renderHelpText(guiGraphics, x, y);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280003_(guiGraphics, x, y);
        int mobFarmStatus = ((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmStatus();
        if (mobFarmStatus != 1 && mobFarmStatus != 4) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(this.dropTimeLabelScale, this.dropTimeLabelScale, this.dropTimeLabelScale);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"text.easy_mob_farm.drop_time_secs", (Object[])new Object[]{((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmTotalTime() / 20}), this.dropTimeLabelX, this.dropTimeLabelY, 0xAAAAAA, false);
            guiGraphics.m_280168_().m_85849_();
        }
        if (mobFarmStatus != 2) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280056_(this.f_96547_, ((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmName(), 61, 18, 43520, false);
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.65f, 0.65f, 0.65f);
            guiGraphics.m_280056_(this.f_96547_, ((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmType(), Math.round(93.84616f), Math.round(43.076923f), 0xAAAAAA, false);
            guiGraphics.m_280168_().m_85849_();
        }
        switch (mobFarmStatus) {
            case 0: 
            case 3: {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(this.nextDropTimeLabelScale, this.nextDropTimeLabelScale, this.nextDropTimeLabelScale);
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"text.easy_mob_farm.next_drop_secs", (Object[])new Object[]{((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmRemainingTime()}), this.nextDropTimeLabelX, this.nextDropTimeLabelY, 0, false);
                guiGraphics.m_280168_().m_85849_();
                break;
            }
            case 1: {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(this.dropTimeLabelScale, this.dropTimeLabelScale, this.dropTimeLabelScale);
                guiGraphics.m_280614_(this.f_96547_, (Component)this.warningFullText, this.dropTimeLabelX, this.dropTimeLabelY, 0xFF5555, false);
                guiGraphics.m_280168_().m_85849_();
                break;
            }
            case 4: {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(this.dropTimeLabelScale, this.dropTimeLabelScale, this.dropTimeLabelScale);
                guiGraphics.m_280614_(this.f_96547_, (Component)this.warningDisabledText, this.dropTimeLabelX, this.dropTimeLabelY, 0xFF5555, false);
                guiGraphics.m_280168_().m_85849_();
                break;
            }
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(Constants.TEXTURE_GENERIC_54, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280163_(Constants.TEXTURE_GENERIC_54, this.f_97735_ + 5, this.f_97736_ + 5, 50.0f, 50.0f, 165, 100, 2000, 2000);
        guiGraphics.m_280218_(Constants.TEXTURE_HOPPER, this.f_97735_ + 2, this.f_97736_ + 85, 2, 5, 170, 40);
        guiGraphics.m_280218_(Constants.TEXTURE_HOPPER, this.f_97735_ + 151, this.f_97736_ + 99, 43, 19, 18, 18);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.f_97735_ + 6, this.f_97736_ + 15, 25, 7, 51, 72);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.f_97735_ + 80, this.f_97736_ + 50, 76, 61, 18, 18);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.f_97735_ + 130, this.f_97736_ + 50, 76, 61, 18, 18);
        int mobDetailsLeftPos = this.f_97735_ + 58;
        int mobDetailsTopPos = this.f_97736_ + 15;
        guiGraphics.m_280218_(Constants.TEXTURE_HORSE, mobDetailsLeftPos, mobDetailsTopPos + 7, 79, 56, 90, 15);
        guiGraphics.m_280218_(Constants.TEXTURE_HORSE, mobDetailsLeftPos + 22, mobDetailsTopPos + 7, 80, 56, 90, 15);
        guiGraphics.m_280218_(Constants.TEXTURE_HORSE, mobDetailsLeftPos, mobDetailsTopPos, 79, 17, 90, 15);
        guiGraphics.m_280218_(Constants.TEXTURE_HORSE, mobDetailsLeftPos + 22, mobDetailsTopPos, 80, 17, 90, 15);
        guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 20, this.f_97736_ + 100, 40, 7, 20, 16);
        if (((MobFarmMenu)((Object)this.mobFarmMenu)).isMobFarmPowered()) {
            guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 21, this.f_97736_ + 100, 41, 45, 18, 16);
        }
        if (!((MobFarmMenu)((Object)this.mobFarmMenu)).hasMobFarmWeaponItem()) {
            guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 127, this.f_97736_ + 60, 105, 3, 23, 54);
        } else {
            guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 127, this.f_97736_ + 60, 81, 3, 23, 54);
        }
        if (!((MobFarmMenu)((Object)this.mobFarmMenu)).hasMobFarmCapturedMob()) {
            int capturedMobIconsLeft = this.animationTicker / 50 * 16;
            guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 81, this.f_97736_ + 50, capturedMobIconsLeft, 60, 16, 16);
        }
        switch (((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmStatus()) {
            case 0: 
            case 3: {
                guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 21, this.f_97736_ + 100, 41, 26, 18, ((MobFarmMenu)((Object)this.mobFarmMenu)).getMobFarmProgressImage());
                break;
            }
            case 1: {
                guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 23, this.f_97736_ + 99, 65, 6, 16, 14);
                break;
            }
            case 2: {
                guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 12, this.f_97736_ + 30, 1, 1, 40, 50);
                guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 100, this.f_97736_ + 54, 62, 28, 20, 14);
                break;
            }
            case 4: {
                guiGraphics.m_280218_(Constants.TEXTURE_ICONS, this.f_97735_ + 23, this.f_97736_ + 101, 66, 42, 16, 16);
                break;
            }
        }
    }
}

