/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easymobfarm.commands.CustomCommand;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityOverviewCommand
extends CustomCommand {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final EntityOverviewCommand command = new EntityOverviewCommand();
    private static final String NO_ENTITIES_TEXT = "Unable to find any entities. Server / World is not loaded?";

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"entities").requires(cs -> cs.m_6761_(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Set entitiesKeys = ForgeRegistries.ENTITY_TYPES.getKeys();
        if (entitiesKeys.isEmpty()) {
            EntityOverviewCommand.sendFeedback(context, NO_ENTITIES_TEXT);
            return 0;
        }
        EntityOverviewCommand.sendFeedback(context, String.format("Entity registry (%s types)\n===", entitiesKeys.size()));
        log.info("Entity registry: {}", (Object)entitiesKeys);
        for (ResourceLocation entityKey : entitiesKeys) {
            EntityOverviewCommand.sendFeedback(context, String.format("\u25cb %s", entityKey));
        }
        return 0;
    }
}

