/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.biome.Desert;
import de.markusbordihn.easymobfarm.config.biome.Jungle;
import de.markusbordihn.easymobfarm.config.biome.Ocean;
import de.markusbordihn.easymobfarm.config.biome.Plains;
import de.markusbordihn.easymobfarm.config.biome.PlainsCave;
import de.markusbordihn.easymobfarm.config.biome.Swamp;
import de.markusbordihn.easymobfarm.config.mobs.BeeAnimal;
import de.markusbordihn.easymobfarm.config.mobs.BossMonster;
import de.markusbordihn.easymobfarm.config.mobs.HostileMonster;
import de.markusbordihn.easymobfarm.config.mobs.PassiveAnimal;
import de.markusbordihn.easymobfarm.config.mobs.PassiveWaterAnimal;
import de.markusbordihn.easymobfarm.config.structure.NetherFortress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;
    private static final String MOB_CATCHING_LUCK_TEXT = "Defines the luck of capturing the mob e.g. luck of 3 means a change of 1 to 3 to capture a mob. Higher numbers requires more luck. 0 = disable luck.";
    private static final String PROCESS_TIME_TEXT = "Defines after how many seconds a loot drop is performed.";
    private static final String DROP_SOUND_TEXT = "Defines the sound which is played when a loot drop is performed.";
    private static final String SUPPORTED_MOBS_ANIMAL_PLANS_FARM = "Supported Mobs for the animal plains farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_ANIMAL_PLANS_FARM = "Denied Mobs for the animal plains farm.";
    private static final String SUPPORTED_MOBS_BEE_HIVE_FARM = "Supported Mobs for the bee hive farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_BEE_HIVE_FARM = "Denied Mobs for the bee hive farm.";
    private static final String SUPPORTED_MOBS_DESERT_FARM = "Supported Mobs for the desert farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_DESERT_FARM = "Denied Mobs for the desert farm.";
    private static final String SUPPORTED_MOBS_JUNGLE_FARM = "Supported Mobs for the jungle farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_JUNGLE_FARM = "Denied Mobs for the jungle farm.";
    private static final String SUPPORTED_MOBS_NETHER_FARM = "Supported Mobs for the nether farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_NETHER_FARM = "Denied Mobs for the nether farm.";
    private static final String SUPPORTED_MOBS_OCEAN_FARM = "Supported Mobs for the ocean farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_OCEAN_FARM = "Denied Mobs for the ocean farm.";
    private static final String SUPPORTED_MOBS_PLAINS_CAVE_FARM = "Supported Mobs for the plains cave farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_PLAINS_CAVE_FARM = "Denied Mobs for the plains cave farm.";
    private static final String SUPPORTED_MOBS_SWAMP_FARM = "Supported Mobs for the swamp farm. (Use empty list to allow all mobs.)";
    private static final String DENIED_MOBS_SWAMP_FARM = "Denied Mobs for the swamp farm.";

    protected CommonConfig() {
    }

    static {
        log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("{} Common config ...", (Object)"\ud83e\udea4 Register Bo's Easy Mob Farm");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue informOwnerAboutFullStorage;
        public final ForgeConfigSpec.BooleanValue logFullStorage;
        public final ForgeConfigSpec.IntValue lootPreviewRolls;
        public final ForgeConfigSpec.BooleanValue playDropSound;
        public final ForgeConfigSpec.BooleanValue damageWeaponItem;
        public final ForgeConfigSpec.ConfigValue<List<String>> generalAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> generalDeniedMobs;
        public final ForgeConfigSpec.IntValue experienceDropChanceNoWeapon;
        public final ForgeConfigSpec.IntValue experienceDropChanceWithWeapon;
        public final ForgeConfigSpec.IntValue experienceDropChanceWithEnchantedWeapon;
        public final ForgeConfigSpec.IntValue experienceDropMendingRepairAmount;
        public final ForgeConfigSpec.IntValue copperAnimalPlainsFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperAnimalPlainsFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperAnimalPlainsFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperAnimalPlainsFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue copperBeeHiveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperBeeHiveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperBeeHiveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperBeeHiveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue copperDesertFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperDesertFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperDesertFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperDesertFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue copperJungleFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperJungleFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperJungleFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperJungleFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue copperMonsterPlainsCaveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperMonsterPlainsCaveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperMonsterPlainsCaveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperMonsterPlainsCaveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue copperNetherFortressFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperNetherFortressFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperNetherFortressFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperNetherFortressFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue copperOceanFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperOceanFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperOceanFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperOceanFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue copperSwampFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> copperSwampFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperSwampFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> copperSwampFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironAnimalPlainsFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironAnimalPlainsFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironAnimalPlainsFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironAnimalPlainsFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironBeeHiveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironBeeHiveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironBeeHiveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironBeeHiveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironDesertFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironDesertFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironDesertFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironDesertFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironJungleFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironJungleFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironJungleFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironJungleFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironMonsterPlainsCaveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironMonsterPlainsCaveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironMonsterPlainsCaveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironMonsterPlainsCaveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironNetherFortressFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironNetherFortressFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironNetherFortressFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironNetherFortressFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironOceanFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironOceanFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironOceanFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironOceanFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue ironSwampFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironSwampFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironSwampFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironSwampFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldAnimalPlainsFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldAnimalPlainsFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldAnimalPlainsFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldAnimalPlainsFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldBeeHiveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldBeeHiveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldBeeHiveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldBeeHiveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldDesertFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldDesertFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldDesertFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldDesertFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldJungleFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldJungleFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldJungleFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldJungleFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldMonsterPlainsCaveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldMonsterPlainsCaveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldMonsterPlainsCaveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldMonsterPlainsCaveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldNetherFortressFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldNetherFortressFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldNetherFortressFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldNetherFortressFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldOceanFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldOceanFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldOceanFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldOceanFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue goldSwampFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> goldSwampFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldSwampFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldSwampFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteAnimalPlainsFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteAnimalPlainsFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteAnimalPlainsFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteAnimalPlainsFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteBeeHiveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteBeeHiveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteBeeHiveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteBeeHiveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteDesertFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteDesertFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteDesertFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteDesertFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteJungleFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteJungleFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteJungleFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteJungleFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteMonsterPlainsCaveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteMonsterPlainsCaveFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteMonsterPlainsCaveFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteMonsterPlainsCaveFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteNetherFortressFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteNetherFortressFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteNetherFortressFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteNetherFortressFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteOceanFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteOceanFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteOceanFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteOceanFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteSwampFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> netheriteSwampFarmDropSound;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteSwampFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteSwampFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue creativeMobFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> creativeMobFarmDropSound;
        public final ForgeConfigSpec.IntValue ironGolemFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<String> ironGolemFarmDropSound;
        public final ForgeConfigSpec.BooleanValue ironGolemFarmFilterPoppy;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironGolemFarmAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> ironGolemFarmDeniedMobs;
        public final ForgeConfigSpec.IntValue catchCageMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> catchCageAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> catchCageDeniedMobs;
        public final ForgeConfigSpec.IntValue catchCageSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> catchCageSmallAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> catchCageSmallDeniedMobs;
        public final ForgeConfigSpec.IntValue collarSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> collarSmallAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> collarSmallDeniedMobs;
        public final ForgeConfigSpec.IntValue enderLassoMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> enderLassoAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> enderLassoDeniedMobs;
        public final ForgeConfigSpec.IntValue fishingBowlMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> fishingBowlAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> fishingBowlDeniedMobs;
        public final ForgeConfigSpec.IntValue fishingNetSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> fishingNetSmallAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> fishingNetSmallDeniedMobs;
        public final ForgeConfigSpec.IntValue goldenLassoMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldenLassoAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> goldenLassoDeniedMobs;
        public final ForgeConfigSpec.IntValue insectNetMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> insectNetAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> insectNetDeniedMobs;
        public final ForgeConfigSpec.IntValue netheriteLassoMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteLassoAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> netheriteLassoDeniedMobs;
        public final ForgeConfigSpec.IntValue poppyBouquetMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> poppyBouquetAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> poppyBouquetDeniedMobs;
        public final ForgeConfigSpec.IntValue urnSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> urnSmallAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> urnSmallDeniedMobs;
        public final ForgeConfigSpec.IntValue witchBottleMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> witchBottleAllowedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> witchBottleDeniedMobs;
        public final ForgeConfigSpec.IntValue forceBeeDropHoneycombChance;
        public final ForgeConfigSpec.IntValue forceBlazeDropBlazeRodChance;
        public final ForgeConfigSpec.IntValue forceChickenDropEggChance;
        public final ForgeConfigSpec.BooleanValue disableChickenDropRawChicken;
        public final ForgeConfigSpec.BooleanValue disableCowDropRawBeef;
        public final ForgeConfigSpec.IntValue forceDrownedDropArmorChance;
        public final ForgeConfigSpec.IntValue forceDrownedDropCopperIngotChance;
        public final ForgeConfigSpec.IntValue forceDrownedDropTridentChance;
        public final ForgeConfigSpec.IntValue forceDrownedDropNautilusShellChance;
        public final ForgeConfigSpec.IntValue forceEndermanDropEnderPearlChance;
        public final ForgeConfigSpec.BooleanValue disableIronGolemDropPoppy;
        public final ForgeConfigSpec.BooleanValue disableSheepDropRawMutton;
        public final ForgeConfigSpec.IntValue forceSlimeDropSlimeBallChance;
        public final ForgeConfigSpec.IntValue forceMagmaCubeDropMagmaCreamChance;
        public final ForgeConfigSpec.IntValue forcePiglinDropArmorChance;
        public final ForgeConfigSpec.IntValue forcePiglinDropWeaponChance;
        public final ForgeConfigSpec.IntValue forcePillagerDropArmorChance;
        public final ForgeConfigSpec.IntValue forcePillagerDropEmeraldChance;
        public final ForgeConfigSpec.IntValue forcePillagerDropEnchantedBookChance;
        public final ForgeConfigSpec.IntValue forcePillagerDropWeaponChance;
        public final ForgeConfigSpec.IntValue forceWitherDropNetherStarChance;
        public final ForgeConfigSpec.IntValue forceWitherSkeletonDropWitherSkeletonSkullChance;
        public final ForgeConfigSpec.IntValue forceZombieDropArmorChance;
        public final ForgeConfigSpec.IntValue forceZombieDropWeaponChance;
        public final ForgeConfigSpec.IntValue forceZombifiedPiglinDropGoldIngotChance;
        public final ForgeConfigSpec.IntValue forceZombifiedPiglinDropGoldNuggetChance;
        public final ForgeConfigSpec.IntValue forceZombifiedPiglinDropWeaponChance;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Bo's Easy Mob Farm");
            builder.push("General");
            this.informOwnerAboutFullStorage = builder.comment("Enable/Disable owner messages about full storage to avoid lagging systems.").define("informOwnerAboutFullStorage", true);
            this.logFullStorage = builder.comment("Enable/Disable full storage log messages for the server logs.").define("logFullStorage", true);
            this.lootPreviewRolls = builder.comment("Number of roll's to get the loot preview for a captured mob. Higher numbers require more server load, but giving a more completed overview.").defineInRange("lootPreviewRolls", 2, 1, 5);
            this.playDropSound = builder.comment("Enable/Disable the drop sound for the loot drops.").define("playDropSound", true);
            this.damageWeaponItem = builder.comment("Enable/Disable the damage of the weapon item which is used for player killed drops.").define("damageWeaponItem", true);
            this.generalAllowedMobs = builder.comment("The following mobs are allowed to be captured with any mob catcher and all mob farms. (Use empty list to disable!)").define("generalAllowedMobs", new ArrayList());
            this.generalDeniedMobs = builder.comment("The following mobs are not allowed to be captured with any mob catcher and all mob farms. (Use empty list to allow all mobs!)").define("generalDeniedMobs", new ArrayList<String>(BossMonster.All));
            builder.pop();
            builder.push("Experience Dropping");
            this.experienceDropChanceNoWeapon = builder.comment("Defines the change of dropping experience without a weapon. (lower number = higher change)").defineInRange("experienceDropChanceNoWeapon", 10, 1, 100);
            this.experienceDropChanceWithWeapon = builder.comment("Defines the change of dropping experience with a weapon. (lower number = higher change)").defineInRange("experienceDropChanceWithWeapon", 5, 1, 100);
            this.experienceDropChanceWithEnchantedWeapon = builder.comment("Defines the change of dropping experience with an enchanted weapon. (lower number = higher change)").defineInRange("experienceDropChanceWithEnchantedWeapon", 3, 1, 100);
            this.experienceDropMendingRepairAmount = builder.comment("Defines the max amount to repair a mending weapon with experience points. (higher number = more repair)").defineInRange("experienceDropMendingRepairAmount", 10, 1, 100);
            builder.pop();
            builder.push("Copper Mob Farms");
            builder.comment("Configuration for the copper mob farms.");
            builder.push("Copper Animal Plains Farms");
            this.copperAnimalPlainsFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("copperAnimalPlainsFarmProcessTime", 600, 10, 3600);
            this.copperAnimalPlainsFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperAnimalPlainsFarmDropSound", (Object)"minecraft:entity.chicken.egg");
            this.copperAnimalPlainsFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_ANIMAL_PLANS_FARM).define("copperAnimalPlainsFarmAllowedMobs", new ArrayList<String>(Plains.Passive));
            this.copperAnimalPlainsFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_ANIMAL_PLANS_FARM).define("copperAnimalPlainsFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Copper Bee Hive Farms");
            this.copperBeeHiveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("copperBeeHiveFarmProcessTime", 600, 10, 3600);
            this.copperBeeHiveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperBeeHiveFarmDropSound", (Object)"minecraft:block.beehive.exit");
            this.copperBeeHiveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_BEE_HIVE_FARM).define("copperBeeHiveFarmAllowedMobs", new ArrayList<String>(BeeAnimal.AllLootable));
            this.copperBeeHiveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_BEE_HIVE_FARM).define("copperBeeHiveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Copper Desert Farm");
            this.copperDesertFarmProcessTime = builder.comment("Defines after how many seconds a drop is performed.").defineInRange("copperDesertFarmProcessTime", 600, 10, 3600);
            this.copperDesertFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperDesertFarmDropSound", (Object)"minecraft:block.sand.hit");
            this.copperDesertFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_DESERT_FARM).define("copperDesertFarmAllowedMobs", new ArrayList<String>(Desert.All));
            this.copperDesertFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_DESERT_FARM).define("copperDesertFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Copper Jungle Farm");
            this.copperJungleFarmProcessTime = builder.comment("Defines after how many seconds a drop is performed.").defineInRange("copperJungleFarmProcessTime", 600, 10, 3600);
            this.copperJungleFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperJungleFarmDropSound", (Object)"minecraft:block.azalea.hit");
            this.copperJungleFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_JUNGLE_FARM).define("copperJungleFarmAllowedMobs", new ArrayList<String>(Jungle.All));
            this.copperJungleFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_JUNGLE_FARM).define("copperJungleFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Copper Monster Plains Cave Farm");
            this.copperMonsterPlainsCaveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("copperMonsterPlainsCaveFarmProcessTime", 600, 10, 3600);
            this.copperMonsterPlainsCaveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperMonsterPlainsCaveFarmDropSound", (Object)"minecraft:block.cave_vines.fall");
            this.copperMonsterPlainsCaveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_PLAINS_CAVE_FARM).define("copperMonsterPlainsCaveFarmAllowedMobs", new ArrayList<String>(PlainsCave.Hostile));
            this.copperMonsterPlainsCaveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_PLAINS_CAVE_FARM).define("copperMonsterPlainsCaveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Copper Nether Fortress Farm");
            this.copperNetherFortressFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("copperNetherFortressFarmProcessTime", 600, 10, 3600);
            this.copperNetherFortressFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperNetherFortressFarmDropSound", (Object)"minecraft:block.netherrack.fall");
            this.copperNetherFortressFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_NETHER_FARM).define("copperNetherFortressFarmAllowedMobs", new ArrayList<String>(NetherFortress.All));
            this.copperNetherFortressFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_NETHER_FARM).define("copperNetherFortressFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Copper Ocean Farm");
            this.copperOceanFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("copperOceanFarmProcessTime", 600, 10, 3600);
            this.copperOceanFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperOceanFarmDropSound", (Object)"minecraft:entity.fish.swim");
            this.copperOceanFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_OCEAN_FARM).define("copperOceanFarmAllowedMobs", new ArrayList<String>(Ocean.All));
            this.copperOceanFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_OCEAN_FARM).define("copperOceanFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Copper Swamp Farm");
            this.copperSwampFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("copperSwampFarmProcessTime", 600, 10, 3600);
            this.copperSwampFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("copperSwampFarmDropSound", (Object)"minecraft:entity.slime.squish");
            this.copperSwampFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_SWAMP_FARM).define("copperSwampFarmAllowedMobs", new ArrayList<String>(Swamp.All));
            this.copperSwampFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_SWAMP_FARM).define("copperSwampFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.pop();
            builder.push("Iron Mob Farms");
            builder.comment("Configuration for the iron mob farms.");
            builder.push("Iron Animal Plains Farms");
            this.ironAnimalPlainsFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironAnimalPlainsFarmProcessTime", 300, 10, 3600);
            this.ironAnimalPlainsFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironAnimalPlainsFarmDropSound", (Object)"minecraft:entity.chicken.egg");
            this.ironAnimalPlainsFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_ANIMAL_PLANS_FARM).define("ironAnimalPlainsFarmAllowedMobs", new ArrayList<String>(Plains.Passive));
            this.ironAnimalPlainsFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_ANIMAL_PLANS_FARM).define("ironAnimalPlainsFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Iron Bee Hive Farms");
            this.ironBeeHiveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironBeeHiveFarmProcessTime", 300, 10, 3600);
            this.ironBeeHiveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironBeeHiveFarmDropSound", (Object)"minecraft:block.beehive.exit");
            this.ironBeeHiveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_BEE_HIVE_FARM).define("ironBeeHiveFarmAllowedMobs", new ArrayList<String>(BeeAnimal.AllLootable));
            this.ironBeeHiveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_BEE_HIVE_FARM).define("ironBeeHiveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Iron Desert Farm");
            this.ironDesertFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironDesertFarmProcessTime", 300, 10, 3600);
            this.ironDesertFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironDesertFarmDropSound", (Object)"minecraft:block.sand.hit");
            this.ironDesertFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_DESERT_FARM).define("ironDesertFarmAllowedMobs", new ArrayList<String>(Desert.All));
            this.ironDesertFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_DESERT_FARM).define("ironDesertFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Iron Jungle Farm");
            this.ironJungleFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironJungleFarmProcessTime", 300, 10, 3600);
            this.ironJungleFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironJungleFarmDropSound", (Object)"minecraft:block.azalea.hit");
            this.ironJungleFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_JUNGLE_FARM).define("ironJungleFarmAllowedMobs", new ArrayList<String>(Jungle.All));
            this.ironJungleFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_JUNGLE_FARM).define("ironJungleFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Iron Monster Plains Cave Farm");
            this.ironMonsterPlainsCaveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironMonsterPlainsCaveFarmProcessTime", 300, 10, 3600);
            this.ironMonsterPlainsCaveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironMonsterPlainsCaveFarmDropSound", (Object)"minecraft:block.cave_vines.fall");
            this.ironMonsterPlainsCaveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_PLAINS_CAVE_FARM).define("ironMonsterPlainsCaveFarmAllowedMobs", new ArrayList<String>(PlainsCave.Hostile));
            this.ironMonsterPlainsCaveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_PLAINS_CAVE_FARM).define("ironMonsterPlainsCaveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Iron Nether Fortress Farm");
            this.ironNetherFortressFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironNetherFortressFarmProcessTime", 300, 10, 3600);
            this.ironNetherFortressFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironNetherFortressFarmDropSound", (Object)"minecraft:block.netherrack.fall");
            this.ironNetherFortressFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_NETHER_FARM).define("ironNetherFortressFarmAllowedMobs", new ArrayList<String>(NetherFortress.All));
            this.ironNetherFortressFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_NETHER_FARM).define("ironNetherFortressFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Iron Ocean Farm");
            this.ironOceanFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironOceanFarmProcessTime", 300, 10, 3600);
            this.ironOceanFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironOceanFarmDropSound", (Object)"minecraft:entity.fish.swim");
            this.ironOceanFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_OCEAN_FARM).define("ironOceanFarmAllowedMobs", new ArrayList<String>(Ocean.All));
            this.ironOceanFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_OCEAN_FARM).define("ironOceanFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Iron Swamp Farm");
            this.ironSwampFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironSwampFarmProcessTime", 300, 10, 3600);
            this.ironSwampFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironSwampFarmDropSound", (Object)"minecraft:entity.slime.squish");
            this.ironSwampFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_SWAMP_FARM).define("ironSwampFarmAllowedMobs", new ArrayList<String>(Swamp.All));
            this.ironSwampFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_SWAMP_FARM).define("ironSwampFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.pop();
            builder.push("Gold Mob Farms");
            builder.comment("Configuration for the gold mob farms.");
            builder.push("Gold Animal Plains Farms");
            this.goldAnimalPlainsFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldAnimalPlainsFarmProcessTime", 150, 10, 3600);
            this.goldAnimalPlainsFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldAnimalPlainsFarmDropSound", (Object)"minecraft:entity.chicken.egg");
            this.goldAnimalPlainsFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_ANIMAL_PLANS_FARM).define("goldAnimalPlainsFarmAllowedMobs", new ArrayList<String>(Plains.Passive));
            this.goldAnimalPlainsFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_ANIMAL_PLANS_FARM).define("goldAnimalPlainsFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Gold Bee Hive Farms");
            this.goldBeeHiveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldBeeHiveFarmProcessTime", 150, 10, 3600);
            this.goldBeeHiveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldBeeHiveFarmDropSound", (Object)"minecraft:block.beehive.exit");
            this.goldBeeHiveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_BEE_HIVE_FARM).define("goldBeeHiveFarmAllowedMobs", new ArrayList<String>(BeeAnimal.AllLootable));
            this.goldBeeHiveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_BEE_HIVE_FARM).define("goldBeeHiveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Gold Desert Farm");
            this.goldDesertFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldDesertFarmProcessTime", 150, 10, 3600);
            this.goldDesertFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldDesertFarmDropSound", (Object)"minecraft:block.sand.hit");
            this.goldDesertFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_DESERT_FARM).define("goldDesertFarmAllowedMobs", new ArrayList<String>(Desert.All));
            this.goldDesertFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_DESERT_FARM).define("goldDesertFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Gold Jungle Farm");
            this.goldJungleFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldJungleFarmProcessTime", 150, 10, 3600);
            this.goldJungleFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldJungleFarmDropSound", (Object)"minecraft:block.azalea.hit");
            this.goldJungleFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_JUNGLE_FARM).define("goldJungleFarmAllowedMobs", new ArrayList<String>(Jungle.All));
            this.goldJungleFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_JUNGLE_FARM).define("goldJungleFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Gold Monster Plains Cave Farm");
            this.goldMonsterPlainsCaveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldMonsterPlainsCaveFarmProcessTime", 150, 10, 3600);
            this.goldMonsterPlainsCaveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldMonsterPlainsCaveFarmDropSound", (Object)"minecraft:block.cave_vines.fall");
            this.goldMonsterPlainsCaveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_PLAINS_CAVE_FARM).define("goldMonsterPlainsCaveFarmAllowedMobs", new ArrayList<String>(PlainsCave.Hostile));
            this.goldMonsterPlainsCaveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_PLAINS_CAVE_FARM).define("goldMonsterPlainsCaveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Gold Nether Fortress Farm");
            this.goldNetherFortressFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldNetherFortressFarmProcessTime", 150, 10, 3600);
            this.goldNetherFortressFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldNetherFortressFarmDropSound", (Object)"minecraft:block.netherrack.fall");
            this.goldNetherFortressFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_NETHER_FARM).define("goldNetherFortressFarmAllowedMobs", new ArrayList<String>(NetherFortress.All));
            this.goldNetherFortressFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_NETHER_FARM).define("goldNetherFortressFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Gold Ocean Farm");
            this.goldOceanFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldOceanFarmProcessTime", 150, 10, 3600);
            this.goldOceanFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldOceanFarmDropSound", (Object)"minecraft:entity.fish.swim");
            this.goldOceanFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_OCEAN_FARM).define("goldOceanFarmAllowedMobs", new ArrayList<String>(Ocean.All));
            this.goldOceanFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_OCEAN_FARM).define("goldOceanFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Gold Swamp Farm");
            this.goldSwampFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("goldSwampFarmProcessTime", 150, 10, 3600);
            this.goldSwampFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("goldSwampFarmDropSound", (Object)"minecraft:entity.slime.squish");
            this.goldSwampFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_SWAMP_FARM).define("goldSwampFarmAllowedMobs", new ArrayList<String>(Swamp.All));
            this.goldSwampFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_SWAMP_FARM).define("goldSwampFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.pop();
            builder.push("Netherite Mob Farms");
            builder.comment("Configuration for the netherite mob farms.");
            builder.push("Netherite Animal Plains Farms");
            this.netheriteAnimalPlainsFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteAnimalPlainsFarmProcessTime", 75, 10, 3600);
            this.netheriteAnimalPlainsFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteAnimalPlainsFarmDropSound", (Object)"minecraft:entity.chicken.egg");
            this.netheriteAnimalPlainsFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_ANIMAL_PLANS_FARM).define("netheriteAnimalPlainsFarmAllowedMobs", new ArrayList());
            this.netheriteAnimalPlainsFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_ANIMAL_PLANS_FARM).define("netheriteAnimalPlainsFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Bee Hive Farms");
            this.netheriteBeeHiveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteBeeHiveFarmProcessTime", 75, 10, 3600);
            this.netheriteBeeHiveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteBeeHiveFarmDropSound", (Object)"minecraft:block.beehive.exit");
            this.netheriteBeeHiveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_BEE_HIVE_FARM).define("netheriteBeeHiveFarmAllowedMobs", new ArrayList());
            this.netheriteBeeHiveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_BEE_HIVE_FARM).define("netheriteBeeHiveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Desert Farms");
            this.netheriteDesertFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteDesertFarmProcessTime", 75, 10, 3600);
            this.netheriteDesertFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteDesertFarmDropSound", (Object)"minecraft:block.sand.hit");
            this.netheriteDesertFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_DESERT_FARM).define("netheriteDesertFarmAllowedMobs", new ArrayList());
            this.netheriteDesertFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_DESERT_FARM).define("netheriteDesertFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Jungle Farm");
            this.netheriteJungleFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteJungleFarmProcessTime", 75, 10, 3600);
            this.netheriteJungleFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteJungleFarmDropSound", (Object)"minecraft:block.bamboo.break");
            this.netheriteJungleFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_JUNGLE_FARM).define("netheriteJungleFarmAllowedMobs", new ArrayList());
            this.netheriteJungleFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_JUNGLE_FARM).define("netheriteJungleFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Monster Plains Cave Farms");
            this.netheriteMonsterPlainsCaveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteMonsterPlainsCaveFarmProcessTime", 75, 10, 3600);
            this.netheriteMonsterPlainsCaveFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteMonsterPlainsCaveFarmDropSound", (Object)"minecraft:block.netherrack.fall");
            this.netheriteMonsterPlainsCaveFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_PLAINS_CAVE_FARM).define("netheriteMonsterPlainsCaveFarmAllowedMobs", new ArrayList());
            this.netheriteMonsterPlainsCaveFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_PLAINS_CAVE_FARM).define("netheriteMonsterPlainsCaveFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Nether Fortress Farm");
            this.netheriteNetherFortressFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteNetherFortressFarmProcessTime", 75, 10, 3600);
            this.netheriteNetherFortressFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteNetherFortressFarmDropSound", (Object)"minecraft:block.nether_wart.break");
            this.netheriteNetherFortressFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_NETHER_FARM).define("netheriteNetherFortressFarmAllowedMobs", new ArrayList());
            this.netheriteNetherFortressFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_NETHER_FARM).define("netheriteNetherFortressFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Ocean Farm");
            this.netheriteOceanFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteOceanFarmProcessTime", 75, 10, 3600);
            this.netheriteOceanFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteOceanFarmDropSound", (Object)"minecraft:block.bubble_column.bubble_pop");
            this.netheriteOceanFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_OCEAN_FARM).define("netheriteOceanFarmAllowedMobs", new ArrayList());
            this.netheriteOceanFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_OCEAN_FARM).define("netheriteOceanFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Swamp Farm");
            this.netheriteSwampFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netheriteSwampFarmProcessTime", 75, 10, 3600);
            this.netheriteSwampFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("netheriteSwampFarmDropSound", (Object)"minecraft:block.slime_block.break");
            this.netheriteSwampFarmAllowedMobs = builder.comment(CommonConfig.SUPPORTED_MOBS_SWAMP_FARM).define("netheriteSwampFarmAllowedMobs", new ArrayList());
            this.netheriteSwampFarmDeniedMobs = builder.comment(CommonConfig.DENIED_MOBS_SWAMP_FARM).define("netheriteSwampFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.pop();
            builder.push("Special Mob Farms");
            builder.comment("Configuration for special mob farms.");
            builder.push("Creative Mob Farm");
            this.creativeMobFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("creativeMobFarmProcessTime", 60, 10, 3600);
            this.creativeMobFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("creativeMobFarmDropSound", (Object)"minecraft:entity.chicken.egg");
            builder.pop();
            builder.push("Iron Golem Farm");
            this.ironGolemFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("ironGolemFarmProcessTime", 100, 10, 3600);
            this.ironGolemFarmDropSound = builder.comment(CommonConfig.DROP_SOUND_TEXT).define("ironGolemFarmDropSound", (Object)"minecraft:block.anvil.fall");
            this.ironGolemFarmFilterPoppy = builder.comment("Enable/Disable filtering of poppies drop.").define("ironGolemFarmFilterPoppy", true);
            this.ironGolemFarmAllowedMobs = builder.comment("Supported Mobs for the iron golem farm. (Use empty list to allow all mobs.)").define("ironGolemFarmAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:iron_golem")));
            this.ironGolemFarmDeniedMobs = builder.comment("Denied Mobs for the iron golem farm.").define("ironGolemFarmDeniedMobs", new ArrayList());
            builder.pop();
            builder.pop();
            builder.push("Mob Catching Item");
            builder.comment("Configuration for the mob catching item.");
            builder.push("Catch Cage");
            this.catchCageMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("catchCageMobCatchingLuck", 6, 0, 100);
            this.catchCageAllowedMobs = builder.comment(Config.getCatchableMobsText("catch cage")).define("catchCageAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:panda", "minecraft:polar_bear")));
            this.catchCageDeniedMobs = builder.comment(Config.getDeniedMobsText("catch cage")).define("catchCageDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Catch Cage small");
            this.catchCageSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("catchCageSmallMobCatchingLuck", 3, 0, 100);
            this.catchCageSmallAllowedMobs = builder.comment(Config.getCatchableMobsText("catch cage small")).define("catchCageSmallAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:chicken", "minecraft:rabbit", "minecraft:parrot")));
            this.catchCageSmallDeniedMobs = builder.comment(Config.getDeniedMobsText("catch cage small")).define("catchCageSmallDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Collar small");
            this.collarSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("collarSmallMobCatchingLuck", 3, 0, 100);
            this.collarSmallAllowedMobs = builder.comment(Config.getCatchableMobsText("collar small")).define("collarSmallAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:chicken", "minecraft:cow", "minecraft:donkey", "minecraft:horse", "minecraft:pig", "minecraft:sheep")));
            this.collarSmallDeniedMobs = builder.comment(Config.getDeniedMobsText("collar small")).define("collarSmallDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Ender Lasso");
            this.enderLassoMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("enderLassoMobCatchingLuck", 4, 0, 100);
            this.enderLassoAllowedMobs = builder.comment(Config.getCatchableMobsText("ender lasso")).define("enderLassoAllowedMobs", new ArrayList<String>(HostileMonster.All));
            this.enderLassoDeniedMobs = builder.comment(Config.getDeniedMobsText("ender lasso")).define("enderLassoDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Fishing bowl");
            this.fishingBowlMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("fishingBowlMobCatchingLuck", 3, 0, 100);
            this.fishingBowlAllowedMobs = builder.comment(Config.getCatchableMobsText("fishing bowl")).define("fishingBowlAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:cod", "minecraft:salmon", "aquaculture:atlantic_cod", "aquaculture:atlantic_halibut", "aquaculture:atlantic_herring", "aquaculture:blackfish", "aquaculture:pacific_halibut", "aquaculture:pink_salmon", "aquaculture:pollock", "aquaculture:rainbow_trout")));
            this.fishingBowlDeniedMobs = builder.comment(Config.getDeniedMobsText("fishing bowl")).define("fishingBowlDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Fishing net small");
            this.fishingNetSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("fishingNetSmallMobCatchingLuck", 3, 0, 100);
            this.fishingNetSmallAllowedMobs = builder.comment(Config.getCatchableMobsText("fishing net small")).define("fishingNetSmallAllowedMobs", new ArrayList(Stream.concat(PassiveWaterAnimal.All.stream(), Arrays.asList("minecraft:cod", "minecraft:salmon", "minecraft:drowned").stream()).collect(Collectors.toList())));
            this.fishingNetSmallDeniedMobs = builder.comment(Config.getDeniedMobsText("fishing net small")).define("fishingNetSmallDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Golden Lasso");
            this.goldenLassoMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("goldenLassoMobCatchingLuck", 8, 0, 100);
            this.goldenLassoAllowedMobs = builder.comment(Config.getCatchableMobsText("golden lasso")).define("goldenLassoAllowedMobs", new ArrayList<String>(PassiveAnimal.All));
            this.goldenLassoDeniedMobs = builder.comment(Config.getDeniedMobsText("golden lasso")).define("goldenLassoDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Insect net");
            this.insectNetMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("insectNetMobCatchingLuck", 3, 0, 100);
            this.insectNetAllowedMobs = builder.comment(Config.getCatchableMobsText("insect net")).define("insectNetAllowedMobs", new ArrayList(Stream.concat(BeeAnimal.All.stream(), Arrays.asList("alexsmobs:fly").stream()).collect(Collectors.toList())));
            this.insectNetDeniedMobs = builder.comment(Config.getDeniedMobsText("insect net")).define("insectNetDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Netherite Lasso");
            this.netheriteLassoMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("netheriteLassoMobCatchingLuck", 2, 0, 100);
            this.netheriteLassoAllowedMobs = builder.comment(Config.getCatchableMobsText("netherite lasso")).define("netheriteLassoAllowedMobs", new ArrayList());
            this.netheriteLassoDeniedMobs = builder.comment(Config.getDeniedMobsText("netherite lasso")).define("netheriteLassoDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Poppy Bouquet");
            this.poppyBouquetMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("poppyBouquetMobCatchingLuck", 3, 0, 100);
            this.poppyBouquetAllowedMobs = builder.comment(Config.getCatchableMobsText("poppy bouquet")).define("poppyBouquetAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:iron_golem")));
            this.poppyBouquetDeniedMobs = builder.comment(Config.getDeniedMobsText("poppy bouquet")).define("poppyBouquetDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Urn small");
            this.urnSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("urnSmallMobCatchingLuck", 3, 0, 100);
            this.urnSmallAllowedMobs = builder.comment(Config.getCatchableMobsText("urn small")).define("urnSmallAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:cave_spider", "minecraft:creeper", "minecraft:spider", "minecraft:skeleton", "minecraft:husk", "minecraft:zombie", "minecraft:zombie_villager")));
            this.urnSmallDeniedMobs = builder.comment(Config.getDeniedMobsText("urn small")).define("urnSmallDeniedMobs", new ArrayList());
            builder.pop();
            builder.push("Witch Bottle (Mob Catching Item)");
            this.witchBottleMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("witchBottleMobCatchingLuck", 10, 0, 100);
            this.witchBottleAllowedMobs = builder.comment(Config.getCatchableMobsText("witch bottle")).define("witchBottleAllowedMobs", new ArrayList<String>(Arrays.asList("minecraft:enderman", "minecraft:slime", "minecraft:witch")));
            this.witchBottleDeniedMobs = builder.comment(Config.getDeniedMobsText("witch bottle")).define("witchBottleDeniedMobs", new ArrayList());
            builder.pop();
            builder.pop();
            builder.push("Additional Drop Settings");
            builder.comment("Configuration for drops like forced and disabled drops.");
            builder.push("Bee Drop Settings");
            this.forceBeeDropHoneycombChance = builder.comment(Config.getForcedDropChanceText("honeycomb", "bee")).defineInRange("forceBeeDropHoneycombChance", 2, 0, 100);
            builder.pop();
            builder.push("Blaze Drop Settings");
            this.forceBlazeDropBlazeRodChance = builder.comment(Config.getForcedDropChanceText("blaze rod", "blaze")).defineInRange("forceBlazeDropBlazeRodChance", 4, 0, 100);
            builder.pop();
            builder.push("Chicken Drop Settings");
            this.disableChickenDropRawChicken = builder.comment("Disable raw chicken drops.").define("disableChickenDropRawChicken", false);
            this.forceChickenDropEggChance = builder.comment(Config.getForcedDropChanceText("egg", "chicken")).defineInRange("forceChickenDropEggChance", 2, 0, 100);
            builder.pop();
            builder.push("Cow Drop Settings");
            this.disableCowDropRawBeef = builder.comment("Disable cow raw beef drops.").define("disableCowDropRawBeef", false);
            builder.pop();
            builder.push("Drowned Drop Settings");
            this.forceDrownedDropArmorChance = builder.comment(Config.getForcedDropChanceText("armor", "drowned")).defineInRange("forceDrownedDropArmorChance", 12, 0, 100);
            this.forceDrownedDropCopperIngotChance = builder.comment(Config.getForcedDropChanceText("copper ingot", "drowned")).defineInRange("forceDrownedDropCopperIngotChance", 10, 0, 100);
            this.forceDrownedDropNautilusShellChance = builder.comment(Config.getForcedDropChanceText("nautilus shell", "drowned")).defineInRange("forceDrownedDropNautilusShellChance", 30, 0, 100);
            this.forceDrownedDropTridentChance = builder.comment(Config.getForcedDropChanceText("trident", "drowned")).defineInRange("forceDrownedDropTridentChance", 18, 0, 100);
            builder.pop();
            builder.push("Enderman Drop Settings");
            this.forceEndermanDropEnderPearlChance = builder.comment(Config.getForcedDropChanceText("ender pearl", "enderman")).defineInRange("forceEndermanDropEnderPearlChance", 2, 0, 100);
            builder.pop();
            builder.push("Iron Golem Drop Settings");
            this.disableIronGolemDropPoppy = builder.comment("Disable iron golem poppy drops.").define("disableIronGolemDropPoppy", false);
            builder.pop();
            builder.push("Sheep Drop Settings");
            this.disableSheepDropRawMutton = builder.comment("Disable sheep raw mutton drops.").define("disableSheepDropRawMutton", false);
            builder.pop();
            builder.push("Slime Drop Settings");
            this.forceSlimeDropSlimeBallChance = builder.comment(Config.getForcedDropChanceText("slime", "slime")).defineInRange("forceSlimeDropSlimeBallChance", 2, 0, 100);
            builder.pop();
            builder.push("Magma Cube Drop Settings");
            this.forceMagmaCubeDropMagmaCreamChance = builder.comment(Config.getForcedDropChanceText("magma cream", "magma cube")).defineInRange("forceMagmaCubeDropMagmaCreamChance", 2, 0, 100);
            builder.pop();
            builder.push("Piglin Drop Settings");
            this.forcePiglinDropArmorChance = builder.comment(Config.getForcedDropChanceText("armor", "piglin")).defineInRange("forcePiglinDropArmorChance", 12, 0, 100);
            this.forcePiglinDropWeaponChance = builder.comment(Config.getForcedDropChanceText("weapon", "piglin")).defineInRange("forcePiglinDropWeaponChance", 12, 0, 100);
            builder.pop();
            builder.push("Pillager Drop Settings");
            this.forcePillagerDropArmorChance = builder.comment(Config.getForcedDropChanceText("armor", "pillager")).defineInRange("forcePillagerDropArmorChance", 16, 0, 100);
            this.forcePillagerDropEmeraldChance = builder.comment(Config.getForcedDropChanceText("emerald", "pillager")).defineInRange("forcePillagerDropEmeraldChance", 8, 0, 100);
            this.forcePillagerDropEnchantedBookChance = builder.comment(Config.getForcedDropChanceText("enchanted book", "pillager")).defineInRange("forcePillagerDropEnchantedBookChance", 20, 0, 100);
            this.forcePillagerDropWeaponChance = builder.comment(Config.getForcedDropChanceText("weapon", "pillager")).defineInRange("forcePillagerDropWeaponChance", 16, 0, 100);
            builder.pop();
            builder.push("Wither Drop Settings");
            this.forceWitherDropNetherStarChance = builder.comment(Config.getForcedDropChanceText("nether star", "wither")).defineInRange("forceWitherDropNetherStarChance", 1, 0, 100);
            builder.pop();
            builder.push("Wither Skeleton Drop Settings");
            this.forceWitherSkeletonDropWitherSkeletonSkullChance = builder.comment(Config.getForcedDropChanceText("wither skeleton skull", "wither skeleton")).defineInRange("forceWitherSkeletonDropWitherSkeletonSkullChance", 10, 0, 100);
            builder.pop();
            builder.push("Zombie Drop Settings");
            this.forceZombieDropArmorChance = builder.comment(Config.getForcedDropChanceText("armor", "zombie")).defineInRange("forceZombieDropArmorChance", 50, 0, 100);
            this.forceZombieDropWeaponChance = builder.comment(Config.getForcedDropChanceText("weapon", "zombie")).defineInRange("forceZombieDropWeaponChance", 100, 0, 100);
            builder.pop();
            builder.push("Zombified Piglin Drop Settings");
            this.forceZombifiedPiglinDropGoldNuggetChance = builder.comment(Config.getForcedDropChanceText("gold nugget", "zombified piglin")).defineInRange("forceZombifiedPiglinDropGoldNuggetChance", 2, 0, 100);
            this.forceZombifiedPiglinDropGoldIngotChance = builder.comment(Config.getForcedDropChanceText("gold ingot", "zombified piglin")).defineInRange("forceZombifiedPiglinDropGoldIngotChance", 4, 0, 100);
            this.forceZombifiedPiglinDropWeaponChance = builder.comment(Config.getForcedDropChanceText("weapon", "zombified piglin")).defineInRange("forceZombifiedPiglinDropWeaponChance", 12, 0, 100);
            builder.pop();
            builder.pop();
        }

        private static final String getCatchableMobsText(String itemName) {
            return "The following mobs can be catched with the " + itemName + ". (Use empty list to allow all mobs!)";
        }

        private static final String getDeniedMobsText(String itemName) {
            return "The following mobs are not catchable with the " + itemName + ". (Use empty list to allow all mobs!)";
        }

        private static final String getForcedDropChanceText(String itemName, String mobName) {
            return "Defines the forced drop change of " + itemName + " from " + mobName + ". (0 = disabled, lower number = higher change, 1 = every drop)";
        }
    }
}

