/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.CommonConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class MobTypeManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected static final Set<String> EMPTY_LIST = Collections.emptySet();
    private static Map<String, Set<String>> acceptedMobTypesMap = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> deniedMobTypesMap = new HashMap<String, Set<String>>();
    private static Set<String> generalAllowedMobTypesSet = Collections.emptySet();
    private static Set<String> generalDeniedMobTypesSet = Collections.emptySet();

    protected MobTypeManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        MobTypeManager.handleMobTypeMapping();
    }

    @SubscribeEvent
    public static void handleWorldEventLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            MobTypeManager.handleMobTypeMapping();
        }
    }

    public static void handleMobTypeMapping() {
        if (generalAllowedMobTypesSet.isEmpty()) {
            generalAllowedMobTypesSet = new HashSet<String>((Collection)MobTypeManager.COMMON.generalAllowedMobs.get());
        }
        if (generalDeniedMobTypesSet.isEmpty()) {
            generalDeniedMobTypesSet = new HashSet<String>((Collection)MobTypeManager.COMMON.generalDeniedMobs.get());
        }
        MobTypeManager.updateMobTypesForKey("Catch Cage", (List)MobTypeManager.COMMON.catchCageAllowedMobs.get(), (List)MobTypeManager.COMMON.catchCageDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Catch Cage Small", (List)MobTypeManager.COMMON.catchCageSmallAllowedMobs.get(), (List)MobTypeManager.COMMON.catchCageSmallDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Collar Small", (List)MobTypeManager.COMMON.collarSmallAllowedMobs.get(), (List)MobTypeManager.COMMON.collarSmallDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Ender Lasso", (List)MobTypeManager.COMMON.enderLassoAllowedMobs.get(), (List)MobTypeManager.COMMON.enderLassoDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Fishing Bowl", (List)MobTypeManager.COMMON.fishingBowlAllowedMobs.get(), (List)MobTypeManager.COMMON.fishingBowlDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Fishing Net Small", (List)MobTypeManager.COMMON.fishingNetSmallAllowedMobs.get(), (List)MobTypeManager.COMMON.fishingNetSmallDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Golden Lasso", (List)MobTypeManager.COMMON.goldenLassoAllowedMobs.get(), (List)MobTypeManager.COMMON.goldenLassoDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Insect Net", (List)MobTypeManager.COMMON.insectNetAllowedMobs.get(), (List)MobTypeManager.COMMON.insectNetDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Netherite Lasso", (List)MobTypeManager.COMMON.netheriteLassoAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteLassoDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Poppy Bouquet", (List)MobTypeManager.COMMON.poppyBouquetAllowedMobs.get(), (List)MobTypeManager.COMMON.poppyBouquetDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Urn Small", (List)MobTypeManager.COMMON.urnSmallAllowedMobs.get(), (List)MobTypeManager.COMMON.urnSmallDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("Witch Bottle", (List)MobTypeManager.COMMON.witchBottleAllowedMobs.get(), (List)MobTypeManager.COMMON.witchBottleDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_animal_plains_farm", (List)MobTypeManager.COMMON.copperAnimalPlainsFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperAnimalPlainsFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_bee_hive_farm", (List)MobTypeManager.COMMON.copperBeeHiveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperBeeHiveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_desert_farm", (List)MobTypeManager.COMMON.copperDesertFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperDesertFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_jungle_farm", (List)MobTypeManager.COMMON.copperJungleFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperJungleFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_monster_plains_cave_farm", (List)MobTypeManager.COMMON.copperMonsterPlainsCaveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperMonsterPlainsCaveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_nether_fortress_farm", (List)MobTypeManager.COMMON.copperNetherFortressFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperNetherFortressFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_ocean_farm", (List)MobTypeManager.COMMON.copperOceanFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperOceanFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("copper_swamp_farm", (List)MobTypeManager.COMMON.copperSwampFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.copperSwampFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_animal_plains_farm", (List)MobTypeManager.COMMON.ironAnimalPlainsFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironAnimalPlainsFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_bee_hive_farm", (List)MobTypeManager.COMMON.ironBeeHiveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironBeeHiveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_desert_farm", (List)MobTypeManager.COMMON.ironDesertFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironDesertFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_jungle_farm", (List)MobTypeManager.COMMON.ironJungleFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironJungleFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_monster_plains_cave_farm", (List)MobTypeManager.COMMON.ironMonsterPlainsCaveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironMonsterPlainsCaveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_nether_fortress_farm", (List)MobTypeManager.COMMON.ironNetherFortressFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironNetherFortressFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_ocean_farm", (List)MobTypeManager.COMMON.ironOceanFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironOceanFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_swamp_farm", (List)MobTypeManager.COMMON.ironSwampFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironSwampFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_animal_plains_farm", (List)MobTypeManager.COMMON.goldAnimalPlainsFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldAnimalPlainsFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_bee_hive_farm", (List)MobTypeManager.COMMON.goldBeeHiveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldBeeHiveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_desert_farm", (List)MobTypeManager.COMMON.goldDesertFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldDesertFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_jungle_farm", (List)MobTypeManager.COMMON.goldJungleFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldJungleFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_monster_plains_cave_farm", (List)MobTypeManager.COMMON.goldMonsterPlainsCaveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldMonsterPlainsCaveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_nether_fortress_farm", (List)MobTypeManager.COMMON.goldNetherFortressFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldNetherFortressFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_ocean_farm", (List)MobTypeManager.COMMON.goldOceanFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldOceanFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("gold_swamp_farm", (List)MobTypeManager.COMMON.goldSwampFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.goldSwampFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_animal_plains_farm", (List)MobTypeManager.COMMON.netheriteAnimalPlainsFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteAnimalPlainsFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_bee_hive_farm", (List)MobTypeManager.COMMON.netheriteBeeHiveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteBeeHiveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_desert_farm", (List)MobTypeManager.COMMON.netheriteDesertFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteDesertFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_jungle_farm", (List)MobTypeManager.COMMON.netheriteJungleFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteJungleFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_monster_plains_cave_farm", (List)MobTypeManager.COMMON.netheriteMonsterPlainsCaveFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteMonsterPlainsCaveFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_nether_fortress_farm", (List)MobTypeManager.COMMON.netheriteNetherFortressFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteNetherFortressFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_ocean_farm", (List)MobTypeManager.COMMON.netheriteOceanFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteOceanFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("netherite_swamp_farm", (List)MobTypeManager.COMMON.netheriteSwampFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.netheriteSwampFarmDeniedMobs.get());
        MobTypeManager.updateMobTypesForKey("iron_golem_farm", (List)MobTypeManager.COMMON.ironGolemFarmAllowedMobs.get(), (List)MobTypeManager.COMMON.ironGolemFarmDeniedMobs.get());
    }

    public static Set<String> getGeneralAllowedMobTypes() {
        return generalAllowedMobTypesSet;
    }

    public static Set<String> getGeneralDeniedMobTypes() {
        return generalDeniedMobTypesSet;
    }

    public static Set<String> getAcceptedMobTypes(String key) {
        return acceptedMobTypesMap.getOrDefault(key, EMPTY_LIST);
    }

    public static Set<String> getDeniedMobTypes(String key) {
        return deniedMobTypesMap.getOrDefault(key, EMPTY_LIST);
    }

    public static boolean isAcceptedMobType(String key, String mobType) {
        if (mobType == null || mobType.isEmpty()) {
            return false;
        }
        if (MobTypeManager.getGeneralDeniedMobTypes().contains(mobType)) {
            return false;
        }
        if (MobTypeManager.getGeneralAllowedMobTypes().contains(mobType)) {
            return true;
        }
        Set<String> deniedMobTypes = MobTypeManager.getDeniedMobTypes(key);
        if (deniedMobTypes.contains(mobType)) {
            return false;
        }
        Set<String> acceptedMobTypes = MobTypeManager.getAcceptedMobTypes(key);
        return acceptedMobTypes.isEmpty() || acceptedMobTypes.contains(mobType);
    }

    public static void updateMobTypesForKey(String key, List<String> acceptedMobs, List<String> deniedMobs) {
        if (key == null) {
            return;
        }
        boolean hasUpdate = false;
        if (acceptedMobs != null && !acceptedMobs.isEmpty()) {
            acceptedMobTypesMap.computeIfAbsent(key, k -> new HashSet(acceptedMobs));
            hasUpdate = true;
        }
        if (deniedMobs != null && !deniedMobs.isEmpty()) {
            deniedMobTypesMap.computeIfAbsent(key, k -> new HashSet(deniedMobs));
            hasUpdate = true;
        }
        if (hasUpdate) {
            MobTypeManager.logSupportedMobs(key, MobTypeManager.getAcceptedMobTypes(key), MobTypeManager.getDeniedMobTypes(key));
        }
    }

    public static void logSupportedMobs(String key, Set<String> acceptedMobTypes, Set<String> deniedMobTypes) {
        if (!acceptedMobTypes.isEmpty() && !deniedMobTypes.isEmpty()) {
            log.info("The {} accepts the following mobs: {}, excluding the following mobs: {}", (Object)key, deniedMobTypes, deniedMobTypes);
        } else if (!acceptedMobTypes.isEmpty()) {
            log.info("The {} accepts the following mobs: {}", (Object)key, acceptedMobTypes);
        } else if (!deniedMobTypes.isEmpty()) {
            log.info("The {} accepts all mobs, excluding the following mobs: {}", (Object)key, deniedMobTypes);
        } else {
            log.info("The {} accepts all mobs.", (Object)key);
        }
    }
}

