/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.datafixer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModDataFixer {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final Map<String, String> missingBlocksMap = ImmutableMap.builder().put((Object)"animal_plains_farm", (Object)"iron_animal_plains_farm").put((Object)"bee_hive_farm", (Object)"iron_bee_hive_farm").put((Object)"desert_farm", (Object)"iron_desert_farm").put((Object)"jungle_farm", (Object)"iron_jungle_farm").put((Object)"monster_plains_cave_farm", (Object)"iron_monster_plains_cave_farm").put((Object)"nether_fortress_farm", (Object)"iron_nether_fortress_farm").put((Object)"ocean_farm", (Object)"iron_ocean_farm").put((Object)"swamp_farm", (Object)"iron_swamp_farm").build();
    private static final Map<String, String> missingBlockEntityTypesMap = ImmutableMap.builder().build();
    private static final Map<String, String> missingItemsMap = ImmutableMap.builder().put((Object)"animal_plains_farm", (Object)"iron_animal_plains_farm").put((Object)"bee_hive_farm", (Object)"iron_bee_hive_farm").put((Object)"desert_farm", (Object)"iron_desert_farm").put((Object)"jungle_farm", (Object)"iron_jungle_farm").put((Object)"monster_plains_cave_farm", (Object)"iron_monster_plains_cave_farm").put((Object)"nether_fortress_farm", (Object)"iron_nether_fortress_farm").put((Object)"ocean_farm", (Object)"iron_ocean_farm").put((Object)"swamp_farm", (Object)"iron_swamp_farm").build();

    @SubscribeEvent
    public static void onMissingMapping(MissingMappingsEvent missingBlockMappingEvent) {
        for (MissingMappingsEvent.Mapping missingBlock : missingBlockMappingEvent.getMappings(ForgeRegistries.Keys.BLOCKS, "easy_mob_farm")) {
            Block block;
            log.warn("Missing block {} with key {}", (Object)missingBlock.getRegistry(), (Object)missingBlock.getKey().m_135815_());
            String blockReplacement = missingBlocksMap.get(missingBlock.getKey().m_135815_());
            if (blockReplacement == null || (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("easy_mob_farm", blockReplacement))) == null) continue;
            log.info("Remapped missing block {} to {}", (Object)missingBlock.getRegistry(), (Object)block);
            missingBlock.remap((Object)block);
        }
        for (MissingMappingsEvent.Mapping missingBlockEntityType : missingBlockMappingEvent.getMappings(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, "easy_mob_farm")) {
            BlockEntityType blockEntityType;
            log.warn("Missing block entity type {} with key {}", (Object)missingBlockEntityType.getRegistry(), (Object)missingBlockEntityType.getKey().m_135815_());
            String blockEntityTypeReplacement = missingBlockEntityTypesMap.get(missingBlockEntityType.getKey().m_135815_());
            if (blockEntityTypeReplacement == null || (blockEntityType = (BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(new ResourceLocation("easy_mob_farm", blockEntityTypeReplacement))) == null) continue;
            log.info("Remapped missing block entity type {} to {}", (Object)missingBlockEntityType.getRegistry(), (Object)blockEntityType);
            missingBlockEntityType.remap((Object)blockEntityType);
        }
        for (MissingMappingsEvent.Mapping missingItem : missingBlockMappingEvent.getMappings(ForgeRegistries.Keys.ITEMS, "easy_mob_farm")) {
            Item item;
            log.warn("Missing item {} with key {}", (Object)missingItem.getRegistry(), (Object)missingItem.getKey().m_135815_());
            String itemReplacement = missingItemsMap.get(missingItem.getKey().m_135815_());
            if (itemReplacement == null || (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("easy_mob_farm", itemReplacement))) == null) continue;
            log.info("Remapped missing item {} to {}", (Object)missingItem.getRegistry(), (Object)item);
            missingItem.remap((Object)item);
        }
    }
}

